  <!-- The Modal -->
  <div class="modal fade" id="modal-edit">
    <div class="modal-dialog">
      <div class="modal-content">
      
        <!-- Modal Header -->
        <div class="modal-header">
          <h4 class="modal-title">Edit Client</h4>
          <button type="button" class="close" data-dismiss="modal">&times;</button>
        </div>
        
        <!-- Modal body -->
        <div class="modal-body">
          <div id="edit_alert" class="alert" style="display: none;"></div>
                <form role="editClient" method="POST" action="">
                    <?php echo csrf_field(); ?>
                    <input type="hidden" name="edit_id" id="edit_id">
                    <div class="form-group row">
                        <label for="edit_business_name" class="col-sm-4 col-form-label col-form-label-sm">Business Name</label>
                        <div class="col-8">
                            <input type="text" class="form-control form-control-sm" name="edit_business_name" id="edit_business_name" placeholder="Business Name">
                        </div>
                    </div>

                    <div class="form-group row">
                        <label for="edit_address" class="col-sm-4 col-form-label col-form-label-sm">Address</label>
                        <div class="col-8">
                            <textarea name="edit_address" class="form-control form-control-sm" id="edit_address" rows="4" placeholder="Address"></textarea>
                        </div>
                    </div>


                    <div class="form-group row">
                        <label for="edit_phone_contact" class="col-sm-4 col-form-label col-form-label-sm">Phone Contact</label>
                        <div class="col-8">
                            <input type="number" class="form-control form-control-sm" name="edit_phone_contact" id="edit_phone_contact" placeholder="Phone Contact">
                        </div>
                    </div>
                    

                    <div class="form-group row">
                        <label for="edit_tin_number" class="col-sm-4 col-form-label col-form-label-sm">TIN</label>
                        <div class="col-8">
                            <input type="text" class="form-control form-control-sm" name="edit_tin_number" id="edit_tin_number" placeholder="Tin Number">
                        </div>
                    </div>

                    <div class="form-group row">
                        <label for="edit_email" class="col-sm-4 col-form-label col-form-label-sm">E-Mail Address</label>
                        <div class="col-8">
                            <input type="email" class="form-control form-control-sm" name="edit_email" id="edit_email" placeholder="Email">
                        </div>
                    </div>

                    <div class="form-group row">
                        <label for="edit_contact_name" class="col-sm-4 col-form-label col-form-label-sm">Contact</label>
                        <div class="col-8">
                            <input type="text" class="form-control form-control-sm" name="edit_contact_name" id="edit_contact_name" placeholder="Contact Name">
                        </div>
                    </div>
                </form>
        </div>
        
        <!-- Modal footer -->
        <div class="modal-footer">
          <button type="submit" class="btn btn-primary" id="submit-edit">Edit</button>
          <button type="button" class="btn btn-danger" data-dismiss="modal">Close</button>
        </div>
        
      </div>
    </div>
  </div>
  
</div>

<script type="text/javascript">
  $(document).ready(function(){
    $('#submit-edit').on('click',function(){
      $.ajax({
        type:"post",
        url:"<?php echo e(url('client.edit')); ?>",
        data:{
            '_token': $('input[name=_token]').val(),
            'business_name': $("#edit_business_name").val(),
            'address': $('#edit_address').val(), 
            'phone_contact': $('#edit_phone_contact').val(), 
            'email': $('#edit_email').val(), 
            'tin_number': $('#edit_tin_number').val(), 
            'contact_name': $('#edit_contact_name').val(),
            'id': $('#edit_id').val()
        },
        beforeSend:function(data){
            $('#edit_alert').removeClass('alert-success');
            $('#edit_alert').removeClass('alert-danger');
            $('#edit_alert').fadeOut('slow');

            //Error remove classes
            $('#business_name').removeClass('is-invalid');
            $('#address').removeClass('is-invalid');
            $('#phone_contact').removeClass('is-invalid');
            $('#email').removeClass('is-invalid');
            $('#tin_number').removeClass('is-invalid');
            $('#contact_name').removeClass('is-invalid');
        },
        success:function(data){
          if(data.success)
          {
            $('#edit_alert').addClass('alert-success');
            $('#edit_alert').fadeIn('slow');
            $('#edit_alert').html(data.success);

            client_list_refresh();
            loader_start();

            setTimeout(function() {
              
              $('#modal-edit').modal('hide');
              loader_stop();
            }, 4000);
          }

          if(data.error)
          {
            $('#edit_alert').addClass('alert-danger');
            $('#edit_alert').fadeIn('slow');
            $('#edit_alert').html(data.error);
          }
        },
        error:function(data){

          var obj = jQuery.parseJSON(data.responseText) ;
          var errors = obj.errors;

          if(obj.message)
          {
            $('#edit_alert').addClass('alert-danger');
            $('#edit_alert').fadeIn('slow');
            $('#edit_alert').html(obj.message);
          }

          if(errors.business_name)
          {
            $('#edit_business_name').addClass('is-invalid');
          }

          if(errors.address)
          {
            $('#edit_address').addClass('is-invalid');
          }

          if(errors.phone_contact)
          {
            $('#edit_phone_contact').addClass('is-invalid');
          }

          if(errors.email)
          {
            $('#edit_email').addClass('is-invalid');
          }

          if(errors.tin_number)
          {
            $('#edit_tin_number').addClass('is-invalid');
          }

          if(errors.contact_name)
          {
            $('#edit_contact_name').addClass('is-invalid');
          }
        }
      });
    });//end AJAX edit 

  });//end ready doc


  $(document).on('click', '.edit-modal', function() {
      $('#edit_id').val($(this).data('id'));
      $('#edit_business_name').val($(this).data('business_name'));
      $('#edit_address').val($(this).data('address'));
      $('#edit_phone_contact').val($(this).data('phone_contact'));
      $('#edit_email').val($(this).data('email'));
      $('#edit_tin_number').val($(this).data('tin_number'));
      $('#edit_contact_name').val($(this).data('contact_name'));
      $('#modal-edit').modal('show');
  });
</script><?php /**PATH C:\xampp\htdocs\clouddev\local\resources\views/clients/edit.blade.php ENDPATH**/ ?>