<?php $__env->startSection('pageTitle', 'Clients'); ?>
<?php $__env->startSection('content'); ?>

<?php use App\Http\Controllers\ConfigController; ?>
	<div class="container">
	
		<div class="card">
			<div class="card-header">Invoices <?php if(ConfigController::check_privilege('ACCESS_ADD_INVOICE')): ?><span class="float-right"><span class="btn btn-sm btn-primary">Add</span></span><?php endif; ?></div>
			<div class="card-body" id="invoices-data">

				<?php if(count($invoices) > 0): ?>
					<div class="table table-striped table-inverse table-hover table-bordered table-sm table-responsive">
					<table class="table " style="font-size: 12px;">

						<thead class="thead-dark">
							<tr>
								<th>ID</th>
								<th>Business Name</th>
								<th>Invoice Type</th>
								<th>Transaction Type</th>
								<th>Updated at</th>
								<th>Status</th>
								<th>Balance</th>
								<th>Total Amount</th>
								<th></th>
								<th></th>
							</tr>
						</thead>
						<tbody>
							<?php $__currentLoopData = $invoices; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $invoice): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
							<tr <?php if($invoice->deleted_at <> ''): ?> class="bg-danger text-white" <?php endif; ?> <?php if($invoice->frcs_verified =='x'): ?> class="bg-warning text-white" title="Invoice on DOUBT status. Please check on VMS if this invoice has been created." <?php endif; ?>>
								<td><?php echo e($invoice->uuid); ?></td>
								<td><?php echo e(ConfigController::get_clientname($invoice->client_id)); ?></td>
								<td><?php echo e(ucfirst($invoice->invoice_type)); ?></td>
								<td><?php echo e(ucfirst($invoice->transaction_type)); ?></td>
								<td><?php echo e($invoice->updated_at); ?></td>
								<td><?php echo e(ConfigController::print_invoice_status($invoice->status)); ?></td>
								<td><?php echo e(ConfigController::get_invoice_balance($invoice->id)); ?></td>
								<td><?php echo e($invoice->total_amount); ?></td>
								<td><a href="<?php echo e(url('invoice.view')); ?>.<?php echo e($invoice->uuid); ?>" class="btn btn-sm btn-info"><i class="fa fa-eye"></i></a></td>
								<?php if($invoice->frcs_verified == '1'): ?>
								<td><a href="<?php echo e(url('invoice.pdf.view')); ?>.<?php echo e($invoice->uuid); ?>" class="btn btn-sm btn-danger"><i class="fas fa-file-pdf"></i></a></td>
								<?php else: ?>
								<td>
									<?php if(ConfigController::check_privilege('ACCESS_UNLOCK_INVOICE')): ?>
										<a href="<?php echo e(url('invoice.unlock')); ?>.<?php echo e($invoice->uuid); ?>" class="btn btn-sm btn-warning"><i class="fas fa-unlock"></i>
										</a>
									<?php endif; ?>
								</td>
								<?php endif; ?>

							</tr>
							<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
						</tbody>
					</table>
					</div>
					<?php echo e($invoices->links()); ?>

				<?php else: ?>
					<div class="alert alert-warning text-center">No Records Found</div>
				<?php endif; ?>


			</div>
			
		</div>
	
	</div>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\clouddev_vms\local\resources\views/invoices/list.blade.php ENDPATH**/ ?>