  <!-- The Modal -->
  <div class="modal fade" id="modal-subRestore">
    <div class="modal-dialog">
      <div class="modal-content">
      
        <!-- Modal Header -->
        <div class="modal-header">
          <h4 class="modal-title">Restore Subscription</h4>
          <button type="button" class="close" data-dismiss="modal">&times;</button>
        </div>
        <input type="hidden" id="restore_id">
        <!-- Modal body -->
        <div class="modal-body">
            <div id="restore_alert"></div>
            <div>Do you wish to restore Subscription id <span id='restore_param'></span>?</div>
        </div>
        
        <!-- Modal footer -->
        <div class="modal-footer">
          <button type="submit" class="btn btn-danger" id="submit-restore">Restore</button>
          <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
        </div>
        
      </div>
    </div>
  </div>
  

<script type="text/javascript">
  $(document).ready(function(){
    $('#submit-restore').on('click',function(){
      alert($('#restore_id').val());
      $.ajax({
        type:"post",
        url:"<?php echo e(url('subscription.restore')); ?>",
        data:{
            '_token': $('input[name=_token]').val(),
            'id': $('#restore_id').val() 
        },
        beforeSend:function(data){
            $('#restore_alert').removeClass('alert-success');
            $('#restore_alert').removeClass('alert-danger');
            $('#restore_alert').fadeOut('slow');

        },
        success:function(data){
          if(data.success)
          {
            $('#restore_alert').addClass('alert-success');
            $('#restore_alert').fadeIn('slow');
            $('#restore_alert').html(data.success);
            
            swal({
              type:'success',
              title: 'Done',
              text: 'Restored successfully'
            });
            load_subscription();

            setTimeout(function() {
              $('#modal-subRestore').modal('hide');
            }, 4000);
          }

          if(data.error)
          {
            $('#restore_alert').addClass('alert-danger');
            $('#restore_alert').fadeIn('slow');
            $('#restore_alert').html(data.error);
          }
        },
        error:function(data){

          var obj = jQuery.parseJSON(data.responseText) ;
          var errors = obj.errors;

          if(obj.message)
          {
            $('#restore_alert').addClass('alert-danger');
            $('#restore_alert').fadeIn('slow');
            $('#restore_alert').html(obj.message);
          }

        }
      });
    });//end AJAX edit 

  });//end ready doc


  $('.restoreSubs').on('click',function(){
      $('#restore_id').val($(this).data('id'));
      $('#restore_param').text($(this).data('id'));

      $('#modal-subRestore').modal('show');
  });
</script><?php /**PATH C:\xampp\htdocs\clouddev\local\resources\views/clients/sub_restore.blade.php ENDPATH**/ ?>