  <!-- The Modal -->
  <div class="modal fade" id="modal-add">
    <div class="modal-dialog">
      <div class="modal-content">
      
        <!-- Modal Header -->
        <div class="modal-header">
          <h4 class="modal-title">Add Client</h4>
          <button type="button" class="close" data-dismiss="modal">&times;</button>
        </div>
        
        <!-- Modal body -->
        <div class="modal-body">
          <div id="alert" class="alert" style="display: none;"></div>
                <form role="addClient" method="POST" action="">
                    <?php echo csrf_field(); ?>
                    <div class="form-group">
                        <div>
                            <input type="text" class="form-control" name="business_name" id="business_name" placeholder="Business Name">
                        </div>
                    </div>

                    <div class="form-group">
                        <div>
                            <textarea name="address" class="form-control" id="address" rows="4" placeholder="Address"></textarea>
                        </div>
                    </div>


                    <div class="form-group">
                        <div>
                            <input type="number" class="form-control" name="phone_contact" id="phone_contact" placeholder="Phone Contact">
                        </div>
                    </div>
                    

                    <div class="form-group">
                        <div>
                            <input type="text" class="form-control" name="tin_number" id="tin_number" placeholder="Tin Number">
                        </div>
                    </div>

                    <div class="form-group">
                        <div>
                            <input type="email" class="form-control" name="email" id="email" placeholder="Email">
                        </div>
                    </div>

                    <div class="form-group">
                        <div>
                            <input type="text" class="form-control" name="contact_name" id="contact_name" placeholder="Contact Name">
                        </div>
                    </div>
                </form>
        </div>
        
        <!-- Modal footer -->
        <div class="modal-footer">
          <button type="submit" class="btn btn-primary" id="submit-add">Add</button>
          <button type="button" class="btn btn-danger" data-dismiss="modal">Close</button>
        </div>
        
      </div>
    </div>
  </div>
  
</div>

<script type="text/javascript">
  $(document).ready(function(){
    $('#submit-add').on('click',function(){
      $.ajax({
        type:"post",
        url:"<?php echo e(url('client.add')); ?>",
        data:{
            '_token': $('input[name=_token]').val(),
            'business_name': $("#business_name").val(),
            'address': $('#address').val(), 
            'phone_contact': $('#phone_contact').val(), 
            'email': $('#email').val(), 
            'tin_number': $('#tin_number').val(), 
            'contact_name': $('#contact_name').val() 
        },
        beforeSend:function(data){
            $('#alert').removeClass('alert-success');
            $('#alert').removeClass('alert-danger');
            $('#alert').fadeOut('slow');

            //Error remove classes
            $('#business_name').removeClass('is-invalid');
            $('#address').removeClass('is-invalid');
            $('#phone_contact').removeClass('is-invalid');
            $('#email').removeClass('is-invalid');
            $('#tin_number').removeClass('is-invalid');
            $('#contact_name').removeClass('is-invalid');
        },
        success:function(data){
          if(data.success)
          {
            $('#alert').addClass('alert-success');
            $('#alert').fadeIn('slow');
            $('#alert').html(data.success);

            client_list_refresh();
            loader_start();
            setTimeout(function() {
              $('#modal-add').modal('hide');
              loader_stop();
            }, 4000);
          }

          if(data.error)
          {
            $('#alert').addClass('alert-danger');
            $('#alert').fadeIn('slow');
            $('#alert').html(data.error);
          }
        },
        error:function(data){

          var obj = jQuery.parseJSON(data.responseText) ;
          var errors = obj.errors;

          if(obj.message)
          {
            $('#alert').addClass('alert-danger');
            $('#alert').fadeIn('slow');
            $('#alert').html(obj.message);
          }

          if(errors.business_name)
          {
            $('#business_name').addClass('is-invalid');
          }

          if(errors.address)
          {
            $('#address').addClass('is-invalid');
          }

          if(errors.phone_contact)
          {
            $('#phone_contact').addClass('is-invalid');
          }
          if(errors.email)
          {
            $('#email').addClass('is-invalid');
          }
          if(errors.tin_number)
          {
            $('#tin_number').addClass('is-invalid');
          }
          if(errors.contact_name)
          {
            $('#contact_name').addClass('is-invalid');
          }
        }
      });
    });
  });
</script><?php /**PATH C:\xampp\htdocs\clouddev\local\resources\views/clients/add.blade.php ENDPATH**/ ?>