<br>
<?php use App\Http\Controllers\ConfigController; ?>
<?php if(ConfigController::check_privilege('ACCESS_ADD_SUBSCRIPTION')): ?>
	<?php echo $__env->make('clients.sub_add', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php endif; ?>

<?php if(ConfigController::check_privilege('ACCESS_EDIT_SUBSCRIPTION')): ?>
	<?php echo $__env->make('clients.sub_edit', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php endif; ?>

<?php if(ConfigController::check_privilege('ACCESS_DELETE_SUBSCRIPTION')): ?>
	<?php echo $__env->make('clients.sub_delete', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php endif; ?>

<?php if(ConfigController::check_privilege('ACCESS_RESTORE_SUBSCRIPTION')): ?>
	<?php echo $__env->make('clients.sub_restore', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php endif; ?>

<div class="col-md-12">
	<div class="card">
		<div class="card-header"><span class="float-right"><?php if(ConfigController::check_privilege('ACCESS_ADD_SUBSCRIPTION')): ?><i class="btn btn-sm btn-primary"  data-toggle="modal" data-target="#modal-add"><span class="fa fa-plus"></span></i><?php endif; ?></span></div>
		<div class="card-body" id="subs-data">
			<?php if(count($subscriptions) > 0): ?>
			<table class="table table-hover table-striped table-bordered table-sm table-responsive-sm" style="font-size: 12px;">
			
				<thead class="thead-dark">
					<th>Subscription ID</th>
					<th>Product</th>
					<th>Next Payment</th>
					<th>Type</th>
					<th>Days</th>
					<th>Created by</th>
					<th>Updated by</th>
					<th>Created at</th>
					<th>Updated at</th>
					<th></th>
					<?php if(ConfigController::check_privilege('ACCESS_DELETE_SUBSCRIPTION')): ?>
						<th></th>
					<?php endif; ?>
				</thead>
				<tbody>
					<?php $__currentLoopData = $subscriptions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $subscription): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
					<tr>
						<td><?php echo e($subscription->id); ?></td>
						<td><?php echo e(ConfigController::get_productName($subscription->product_id)); ?> - <?php echo e($subscription->amount); ?> FJD</td>
						<td><?php echo e($subscription->next_payment); ?></td>
						<td><?php echo e($subscription->type); ?></td>
						<td><?php echo e($subscription->days); ?></td>
						<td><?php echo e(ConfigController::get_username($subscription->created_by)); ?></td>
						<td><?php echo e(ConfigController::get_username($subscription->updated_by)); ?></td>
						<td><?php echo e($subscription->created_at); ?></td>
						<td><?php echo e($subscription->updated_at); ?></td>
						<?php if($subscription->deleted_at == ''): ?>
						<td><a class="btn btn-info btn-sm editSubs"
									data-client_id="<?php echo e($subscription->client_id); ?>" 
									data-id="<?php echo e($subscription->id); ?>"
									data-type="<?php echo e($subscription->type); ?>"
									data-days="<?php echo e($subscription->days); ?>"
									data-amount="<?php echo e($subscription->amount); ?>"
									data-product_id="<?php echo e($subscription->product_id); ?>"
							><span class="fa fa-edit"></span></a></td>
						<td><a class="btn btn-danger btn-sm deleteSubs" data-id="<?php echo e($subscription->id); ?>"><i class="fas fa-trash"></i></a></td>
						<?php else: ?>
							<td colspan="2" style="text-align: center;"><a class="btn btn-warning btn-sm restoreSubs" data-id="<?php echo e($subscription->id); ?>"><i class="fab fa-creative-commons-sa"></i></a></td>
						<?php endif; ?>
					</tr>
					<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
				</tbody>
			</table>
			<?php else: ?>
				<div class="alert alert-info text-center">No data found.</div>
			<?php endif; ?>
		</div>
	</div>
</div>


<script type="text/javascript">
	function load_subscription(){
		$.ajax({
			type:'post',
			url: "<?php echo e(url('subscription.client.load')); ?>",
			data:{'_token': $('input[name=_token]').val(), 'client_id':'<?php echo e($id); ?>'},
			beforeSend:function(){
				loader();
			},
			success:function(data){
				stop_loader();
				if(data.html)
				{
					$('#subs-data').html(data.html);
				}		
			},
			error:function(data){
				stop_loader();	

				swal({
	  				type:'error',
	  				title: 'Error occured',
	  				text: 'Oops, Something went wrong. Please contact admin.',
	  				animation:true
	  			});
			}
		});	
	}
</script>

<?php /**PATH C:\xampp\htdocs\clouddev\local\resources\views/clients/sub_data.blade.php ENDPATH**/ ?>