  <!-- The Modal -->
  <div class="modal fade" id="modal-restore">
    <div class="modal-dialog">
      <div class="modal-content">
      
        <!-- Modal Header -->
        <div class="modal-header">
          <h4 class="modal-title">Restore Client</h4>
          <button type="button" class="close" data-dismiss="modal">&times;</button>
        </div>
        <input type="hidden" id="restore_id">
        <!-- Modal body -->
        <div class="modal-body">
            <div>Do you wish to restore Client id <span id='param_restore'></span>?</div>
        </div>
        
        <!-- Modal footer -->
        <div class="modal-footer">
          <button type="submit" class="btn btn-danger" id="submit-restore">Restore</button>
          <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
        </div>
        
      </div>
    </div>
  </div>
  
</div>

<script type="text/javascript">
  $(document).ready(function(){
    $('#submit-restore').on('click',function(){
      $.ajax({
        type:"post",
        url:"<?php echo e(url('client.restore')); ?>",
        data:{
            '_token': $('input[name=_token]').val(),
            'id': $('#restore_id').val() 
        },
        success:function(data){
          if(data.success)
          {
            loader_start();
            swal({
              type:'success',
              title: 'Done',
              text: 'Removed successfully'
            });
            client_list_refresh();

            setTimeout(function() {
              loader_stop();
              $('#modal-restore').modal('hide');
            }, 4000);
          }

          if(data.error)
          {
              $('#modal-restore').modal('hide');

            swal({
              type:'error',
              title: 'Error',
              text: 'Something went wrong. Please contact your administrator.'
            });
          }
        },
        error:function(data){
              $('#modal-restore').modal('hide');


            swal({
              type:'error',
              title: 'Error',
              text: 'Something went wrong. Please contact your administrator.'
            });
          

        }
      });
    });//end AJAX edit 

  });//end ready doc


  $(document).on('click', '.restore-modal', function() {
      $('#restore_id').val($(this).data('id'));
      $('#param_restore').text($(this).data('id'));

      $('#modal-restore').modal('show');
  });
</script><?php /**PATH C:\xampp\htdocs\clouddev\local\resources\views/clients/restore.blade.php ENDPATH**/ ?>