<!doctype html>
<html>
  <head>
	<?php use App\Http\Controllers\ConfigController; ?>    
	<style type="text/css">
	@import  url("<?php echo e(url('/startbootstrap/css/style.css')); ?>");
	@media  url("<?php echo e(url('/startbootstrap/ccss/print.css')); ?>");
</style>
<!-- 	<link rel='stylesheet' type='text/css' href='css/style.css' />
	<link rel='stylesheet' type='text/css' href='css/print.css' media="print" /> -->


</head>

<body>

	<div id="page-wrap">

		<textarea id="header">INVOICE</textarea>
		<div class="text-center"><?php echo e(ConfigController::get_fiscal_status($data['invoice']->id)); ?></div>
		<div id="identity">
			
            <textarea id="address">TIN: <?php echo e(config('app.tin_number')); ?>      
Company: <?php echo e(config('app.name')); ?>

Store: <?php echo e(config('app.store')); ?>

Address: <?php echo e(config('app.address')); ?>

District: <?php echo e(config('app.district')); ?>

Cashier TIN: <?php echo e(ConfigController::get_userTIN($data['invoice']->updated_by)); ?>

Email: <?php echo e(config('app.email')); ?>

	Mobile: <?php echo e(config('app.mobile')); ?></textarea>

            <div id="logo">
              <div id="logohelp">
                <input id="imageloc" type="text" size="50" value="" /><br />
                (max width: 540px, max height: 100px)
              </div>
              <img id="image" src="<?php echo e(url('img/client_logo.png')); ?>" alt="logo" height="40px" width="150px" />
            </div>
		
		</div>
		
		<div style="clear:both"></div>
		
		<div id="customer">

            <textarea id="customer-title" rows="7">

<?php echo e($data['client']->business_name); ?>

<?php echo e($data['client']->address); ?>

Contact: <?php echo e($data['client']->phone_contact); ?>

<?php if($data['client']->tin_number <> ''): ?>Buyer TIN: <?php echo e($data['client']->tin_number); ?><?php endif; ?></textarea>

            <table id="meta">
                <tr>
                    <td class="meta-head">Invoice #</td>
                    <td><textarea><?php echo e($data['invoice']->uuid); ?></textarea></td>
                </tr>
                <tr>

                    <td class="meta-head">Pos Date</td>
                    <td><textarea id="date"><?php echo e($data['pos_time']); ?></textarea></td>
                </tr>
                <tr>
                    <td class="meta-head">Total Amount</td>
                    <td><div class="due">$ <?php echo e(ConfigController::two_decimal($data['total_amount'])); ?></div></td>
                </tr>
                <tr>
                    <td class="meta-head">Balance</td>
                    <td><div class="due">$ <?php echo e(ConfigController::two_decimal($data['transaction_bal'])); ?></div></td>
                </tr>                

                <tr>
                    <td class="meta-head">Status</td>
                    <td><div class="due"><?php echo e(ConfigController::print_invoice_status($data['status'])); ?></div></td>
                </tr>
                <tr>
                    <td class="meta-head">Payment Type</td>
                    <td><div class="due"><?php echo e($data['payment_type']); ?></div></td>
                </tr>
                <?php if($data['invoice']->payee_reference <> ''): ?>
                <tr>
                    <td class="meta-head">Invoice Ref No.</td>
                    <td><div class="due"><?php echo e(ConfigController::get_uuid($data['invoice']->payee_reference)); ?></div></td>
                </tr>
                <tr>
                    <td class="meta-head">SDC Ref No.</td>
                    <td><div class="due"><?php echo e(ConfigController::get_sdc_ref($data['invoice']->payee_reference)); ?></div></td>
                </tr>
                <?php endif; ?>
            </table>
		
		</div>
		
		<table id="items">
		
		  <tr>
		      <th>Item</th>
		      <th>Description</th>
		      <th>Unit Cost</th>
		      <th>Quantity</th>
		      <th>Price</th>
		  </tr>
		  <?php $__currentLoopData = $data['charges']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $charge): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
		  <tr class="item-row">
		      <td class="item-name"><div class="delete-wpr"><textarea><?php echo e(ConfigController::get_productName($charge->product_id)); ?> - <?php echo e(ConfigController::get_product_labels($charge->product_id)); ?></textarea></div></td>
		      <td class="description"><textarea><?php echo e($charge->description); ?></textarea></td>
		      <td><textarea class="cost">$ <?php echo e(ConfigController::two_decimal($charge->amount)); ?></textarea></td>
		      <td><textarea class="qty"><?php echo e($charge->quantity); ?></textarea></td>
		      <?php if($data['invoice']->transaction_type == 'Refund'): ?>
		      <td><span class="price">$ <?php echo e('-'.ConfigController::two_decimal($charge->amount * $charge->quantity)); ?></span></td>
		      <?php else: ?>
		      <td><span class="price">$<?php echo e(ConfigController::two_decimal($charge->amount * $charge->quantity)); ?></span></td>
		      <?php endif; ?>
		  </tr>
		  <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>		  		  
		  <tr>
		      <td colspan="2" rowspan="3"style="border-top: 0;border-right: 0;">
		      	<table id="items">
		      		<tr><th colspan="4"style="text-align: center;">Tax Details</th></tr>
		      		<tr>
		              <th><span >Label</span></th>
		              <th><span >Name</span></th>
		              <th><span >Rate</span></th>
		              <th><span >Tax</span></th>
	              	</tr>

  					<?php $total_tax = 0; ?>
		        	<?php $__currentLoopData = $data['taxs']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $tax): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
		          		<?php if($tax->label == 'P'): ?>
		          		<tr>
			              <td><span ><?php echo e($tax->label); ?></span></td>
			              <td><span ><?php echo e($tax->name); ?></span></td>
			              <td><span data-prefix>$</span><span ><?php echo e(ConfigController::two_decimal($tax->rate)); ?></span></td>
			              <td><span ><?php echo e(ConfigController::two_decimal($tax->tax)); ?></span></td>
			              <?php $total_tax = $total_tax + $tax->tax; ?>
			            </tr>						          		
			          	<?php else: ?>
			            <tr>
			              <td><span ><?php echo e($tax->label); ?></span></td>
			              <td><span ><?php echo e($tax->name); ?></span></td>
			              <td><span ><?php echo e($tax->rate.'%'); ?></span></td>
			              <td><span ><?php echo e(ConfigController::two_decimal($tax->tax)); ?></span></td>
			              <?php $total_tax = $total_tax + $tax->tax; ?>
			            </tr>
			            <?php endif; ?>
			        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
		      	</table>
		      </td>
		      <td colspan="1" class="blank"> </td>
		      <td colspan="1" class="total-line">Subtotal</td>
		      <td class="total-value"><div id="subtotal">$ <?php echo ConfigController::two_decimal($data['total_amount']-$data['total_tax']); ?></div></td>
		  </tr>
		  <tr>
		      <td colspan="1" class="blank"> </td>
		      <td colspan="1" class="total-line">Total Tax</td>

		      <td class="total-value"><textarea id="paid">$ <?php echo e(ConfigController::two_decimal($data['total_tax'])); ?></textarea></td>
		  </tr>
		  <tr>
		      <td colspan="1" class="blank"> </td>
		      <td colspan="1" class="total-line balance">Total Amount</td>
		      <td class="total-value balance"><div class="due">$ <?php echo e(ConfigController::two_decimal($data['total_amount'])); ?></div></td>
		  </tr>
		
		</table>
		<table id="items">			
			<tr class="thead-dark">
				<th><span >SDC Invoice Number</span></th>
	            <td><span><?php echo e($data['sdc_invoice_no']); ?></span></td>
				<td style="text-align: center;" rowspan="3">		  	
					<?php if($data['url'] <> ''): ?>
			          <img src="data:image/png;base64,<?php echo e(DNS2D::getBarcodePNG($data['url'], 'QRCODE')); ?>" alt="qrcode" id="qrcode" width="<?php echo e(config('app.qr_size')); ?>" height="<?php echo e(config('app.qr_size')); ?>">
			        <?php else: ?>
			          <img src="<?php echo e(url('img/qr_code_na.png')); ?>" alt="qrcode" id="qrcode" width="<?php echo e(config('app.qr_size')); ?>" height="<?php echo e(config('app.qr_size')); ?>">
			        <?php endif; ?>
				</td>
			</tr>

	          <tr>
	            <th><span >Invoice Counter:</span></th>
	            <td><span><?php echo e($data['invoice_counter']); ?></span></td>
	          </tr>
	          <tr>
	            <th><span >SDC Time</span></th>
	            <td><span><?php echo e(ConfigController::convert_date($data['sdc_time'])); ?></span></td>
	          </tr>
				

			</tr>
		</table>
		<div id="terms">
		  
		  <div class="text-center"><?php echo e(ConfigController::get_fiscal_status_end($data['invoice']->id)); ?></div>
		</div>
	
	</div>
	
</body>

</html><?php /**PATH C:\xampp\htdocs\clouddev\local\resources\views/pdf/custom.blade.php ENDPATH**/ ?>