<?php use App\Http\Controllers\ConfigController; ?>
<?php if(count($clients) > 0): ?>
	<table class="table table-striped table-inverse table-hover table-bordered table-sm" style="font-size: 12px;">

		<thead class="thead-dark">
			<tr>
				<th>ID</th>
				<th>Business Name</th>
				<th>Address</th>
				<th>Phone Contact</th>
				<th>Email</th>
				<th>Tin Number</th>
				<th>Contact Name</th>
				<?php if(ConfigController::check_privilege('ACCESS_EDIT_CLIENT')): ?>
					<th></th>
				<?php endif; ?>

				<?php if(ConfigController::check_privilege('ACCESS_DELETE_CLIENT')): ?>
					<th></th>
				<?php endif; ?>
				<th></th>
			</tr>
		</thead>
		<tbody>
			<?php $__currentLoopData = $clients; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $client): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
			<tr <?php if($client->deleted_at <> ''): ?> class="bg-danger text-white" <?php endif; ?>>
				<td><?php echo e($client->id); ?></td>
				<td><?php echo e(ucfirst($client->business_name)); ?></td>
				<td><?php echo e($client->address); ?></td>
				<td><?php echo e($client->phone_contact); ?></td>
				<td><?php echo e($client->email); ?></td>
				<td><?php echo e($client->tin_number); ?></td>
				<td><?php echo e($client->contact_name); ?></td>
				<?php if($client->deleted_at == ''): ?>
					<?php if(ConfigController::check_privilege('ACCESS_EDIT_CLIENT')): ?>
						<td><button class="btn btn-sm btn-secondary edit-modal"
								data-id="<?php echo e($client->id); ?>"
								data-business_name="<?php echo e($client->business_name); ?>"
								data-address="<?php echo e($client->address); ?>"
								data-phone_contact="<?php echo e($client->phone_contact); ?>"
								data-email="<?php echo e($client->email); ?>"
								data-tin_number="<?php echo e($client->tin_number); ?>"
								data-contact_name="<?php echo e($client->contact_name); ?>"
							>
								<span class="fa fa-edit"></span>
							</button>
						</td>
					<?php endif; ?>

					<?php if(ConfigController::check_privilege('ACCESS_DELETE_CLIENT')): ?>
						<td><button class="btn btn-sm btn-danger delete-modal"
								data-id="<?php echo e($client->id); ?>">
								<span class="fa fa-trash"></span>
							</button>
						</td>
					<?php endif; ?>
				<?php endif; ?>

				<?php if($client->deleted_at <> ''): ?>
					<td colspan="2" class="text-center">
						<?php if(ConfigController::check_privilege('ACCESS_RESTORE_CLIENT')): ?>
						<button class="btn btn-sm btn-success restore-modal" title="Restore" 
							data-id="<?php echo e($client->id); ?>">
							<i class="fab fa-creative-commons-sa"></i>
						</button>
						<?php endif; ?>
					</td>
				<?php endif; ?>

				<td><a href="<?php echo e(url('client.detail')); ?>.<?php echo e($client->id); ?>" class="btn btn-primary btn-sm">
					<span class="fa fa-eye"></span></a>
				</td>

			</tr>
			<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
		</tbody>
	</table>
<?php else: ?>
	<div class="alert alert-warning text-center">No Records Found</div>
<?php endif; ?>




<?php /**PATH C:\xampp\htdocs\clouddev\local\resources\views/clients/data.blade.php ENDPATH**/ ?>