<?php $__env->startSection('pageTitle', 'Transaction Details'); ?>
<?php $__env->startSection('content'); ?>
<?php use App\Http\Controllers\ConfigController; ?>  
<?php if($transaction <> ''): ?>
<div class="row" style="font-size: 12px;">		
	<!-- Transaction	 -->
	
	<div class="col-xl-4 col-md-4  col-sm-12 col-xs-12 mb-4">
      <div class="card border-left-primary shadow h-100 py-2">
        <div class="card-body">
        	<label  class="col-md-12 control-label control-label-sm font-weight-bold text-primary text-uppercase mb-1">Transaction Details</label>
        	<div class="table-responsive  table-hover">
	        	<table class="table">
	        		<tbody>
	        			<tr>
	        				<th>Transaction #: </th>
	        				<td><?php echo e($transaction->id); ?></td>
	        			</tr>

	        			<tr>
	        				<th>Brand Name: </th>
	        				<td><?php echo e(ConfigController::get_brand_name($transaction->brand_id)); ?></td>
	        			</tr>

	        			<tr>
	        				<th>Client Name: </th>
	        				<td><?php echo e(ConfigController::get_clientname($transaction->client_id)); ?></td>
	        			</tr>

	        			<tr>
	        				<th>Status: </th>
	        				<td><?php if($transaction->status): ?> <?php echo e('POSTED'); ?> <?php endif; ?></td>
	        			</tr>
	        			<tr>
	        				<th>Created By</th>
	        				<td><?php echo e(ConfigController::get_username($transaction->created_by)); ?></td>
	        			</tr>

	        		</tbody>
	        	</table>
        	</div>

        </div>
      </div>
    </div>

<!-- FRCS -->
	<div class="col-xl-4 col-md-4 col-sm-12 col-xs-12 mb-4">
      <div class="card border-left-warning shadow h-100 py-2">
        <div class="card-body">
        	<label  class="col-md-12 control-label control-label-sm font-weight-bold text-primary text-uppercase mb-1">Balances & Payment</label>
        	<div class="table-responsive table-hover">
	        	<table class="table">
	        		<tbody>
	        			<tr>
	        				<th>Client Balance Before: </th>
	        				<td>$ <?php echo e($transaction->bal_before); ?> FJD</td>
	        			</tr>

            			
            			<tr>
	        				<th>Invoice Balance Before: </th>
	        				<td>$ <?php echo e($transaction->invoice_bal_before); ?> FJD</td>
	        			</tr>

            			<tr>
	        				<th>Payment Amount: </th>
	        				<td>$ <?php echo e($transaction->amount); ?> FJD</td>
	        			</tr>

	        			<tr>
	        				<th>Client Balance After: </th>
	        				<td>$ <?php echo e($transaction->bal_after); ?> FJD</td>
	        			</tr>

            			
            			<tr>
	        				<th>Invoice Balance After: </th>
	        				<td>$ <?php echo e($transaction->invoice_bal_after); ?> FJD</td>
	        			</tr>
        			</tbody>
    			</table>

        	</div>
      	</div>
      </div>
    </div>

<!-- Payments -->
	<div class="col-xl-4 col-md-4 col-sm-12 col-xs-12 mb-4">
      <div class="card border-left-danger shadow h-100 py-2">
        <div class="card-body">
        	<label  class="col-md-12 control-label control-label-sm font-weight-bold text-primary text-uppercase mb-1">Payments</label>
        	<div class="table-hover table-responsive">
        		<table class="table">
        			<tbody>
        				<tr>
        				
	        				<th>Payment Type:</th>
	        				<td><?php echo e($transaction->payment_type); ?></td>
        				
	        			</tr>      		
			            <?php if($transaction->payment_count <> ''): ?>

				            <?php 
							    $i = 0; 
							?> 
							<?php while(++$i <= $transaction->payment_count): ?> 

							
					        	<tr>
					        	
					            	<th>Payment Type <?php echo e($i); ?>:</th>
					            
					            	<td><?php echo e($transaction['payment_type'.$i]); ?></td>
					            </tr>

					        	<tr>
					        	
					            	<th>Payment Amount <?php echo e($i); ?>:</th>
					            
					            	<td><?php echo e($transaction['payment_amount'.$i]); ?></td>
					            </tr>
				            <?php endwhile; ?>
			            <?php endif; ?>
            		</tbody>
            	</table>
            </div>

        </div>
      </div>
    </div>





	<!-- emails -->
		<div class="col-xl-6 col-md-6  col-sm-12 col-xs-12 mb-4">
	      <div class="card border-left-danger shadow h-100 py-2">
	        <div class="card-body">
	        	<label  class="col-md-12 control-label control-label-sm font-weight-bold text-primary text-uppercase mb-1">Emails</label>
	        	<?php if(count($emails)<> 0): ?>
	        	<div class="table-hover table-bordered table-responsive">
	        	<table class="table">
	        		<thead class="bg-secondary text-white">
	        			<th>Created At</th>
	        			<th>Sent</th>
	        		</thead>
	        		<tbody>
	        			
	        			<?php $__currentLoopData = $emails; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $email): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
	        			<tr>
		        			<td><?php echo e($email->created_at); ?></td>
		        			<td><?php echo e($email->sent); ?></td>		        			
		        		</tr>
	        			<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
	        		</tbody>
	        	</table>
	        	</div>
	        	<hr>
	        	<?php else: ?>
	        	<div class="alert alert-info">No emails sent</div>

	        	<?php endif; ?>
	        </div>
	      </div>
	    </div>
<!-- emails end -->

</div>
<?php else: ?>
<div class="col-md-8 offset-md-2">
	<div class="alert alert-info">Sorry, there is no data for this transaction.</div>
</div>
<?php endif; ?>
          

<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\clouddev\local\resources\views/transactions/view.blade.php ENDPATH**/ ?>