 <?php use App\Http\Controllers\ConfigController; ?>
  <!-- The Modal -->
  <div class="modal fade" id="modal-add">
    <div class="modal-dialog">
      <div class="modal-content">
      
        <!-- Modal Header -->
        <div class="modal-header">
          <h4 class="modal-title">Add Subscription</h4>
          <button type="button" class="close" data-dismiss="modal">&times;</button>
        </div>

        <!-- Modal body -->
        <div class="modal-body">
          <div id="alert" class="alert" style="display: none;"></div>
                <form id="addClientSubscription" method="POST" action="<?php echo e(url('subscription.add')); ?>">
                    <?php echo csrf_field(); ?>
                    <div class="form-group">
                        <div>
                            <input type="hidden" name="client_id" id="client_id" value="<?php echo e($id); ?>">
                            <select class="form-control" name="product_id" id="product_id">
                              <option value=""><---Select Product ---></option>
                              <?php $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php if($product->type == 'f'): ?>
                                  <option value="<?php echo e($product->id); ?>" data-amount="<?php echo e($product->amount); ?>" data-type="<?php echo e($product->type); ?>"><?php echo e($product->name .' - FJD $ '.$product->amount); ?></option>
                                <?php endif; ?>

                                <?php if($product->type == 'x'): ?>
                                  <option value="<?php echo e($product->id); ?>" data-amount="<?php echo e($product->amount); ?>" data-type="<?php echo e($product->type); ?>"><?php echo e($product->name); ?></option>
                                <?php endif; ?>
                              <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>
                    </div>


                    <div class="form-group">
                        <div>
                            <select class="form-control" name="type" id="type">
                              <option value="one">One Time Payment</option>
                              <option value="monthly">Monthly Payment</option>
                              <option value="quarterly">Quarterly Payment</option>
                              <option value="bi">Bi Annually Payment</option>
                              <option value="annually">Annually Payment</option>
                            </select>
                        </div>
                    </div>

                    <div class="form-group" id="div-amount" style="display: none;">
                        <div>
                          <input type="number" name="amount" id="amount" class="form-control">
                        </div>
                    </div>
                    
                </form>
        </div>
        
        <!-- Modal footer -->
        <div class="modal-footer">
          <button type="submit" class="btn btn-primary" id="submit-add">Add</button>
          <button type="button" class="btn btn-danger" data-dismiss="modal">Close</button>
        </div>
        
      </div>
    </div>
  </div>
  
</div>

<script type="text/javascript">
  $(document).ready(function(){
    $('#submit-add').on('click',function(){
      var dataForm = $('#addClientSubscription').serialize();
      
      $.ajax({
        type:"post",
        url:"<?php echo e(url('subscription.add')); ?>",
        data: dataForm,
        beforeSend:function(data){
            $('#alert').removeClass('alert-success');
            $('#alert').removeClass('alert-danger');
            $('#alert').fadeOut('slow');

            //Error remove classes
            $('#product_id').removeClass('is-invalid');
            $('#type').removeClass('is-invalid');
            $('#amount').removeClass('is-invalid');

        },
        success:function(data){
          if(data.success)
          {
            $('#alert').addClass('alert-success');
            $('#alert').fadeIn('slow');
            $('#alert').html(data.success);
            setTimeout(function() {

              $('#modal-add').modal('hide');
              load_subscription();
            }, 2000);

          }

          if(data.error)
          {
            $('#alert').addClass('alert-danger');
            $('#alert').fadeIn('slow');
            $('#alert').html(data.error);
          }
        },
        error:function(data){

          var obj = jQuery.parseJSON(data.responseText) ;
          var errors = obj.errors;

          if(obj.message)
          {
            $('#alert').addClass('alert-danger');
            $('#alert').fadeIn('slow');
            $('#alert').html(obj.message);
          }

          if(errors.product_id)
          {
            $('#product_id').addClass('is-invalid');
          }

          if(errors.type)
          {
            $('#type').addClass('is-invalid');
          }

          if(errors.amount)
          {
            $('#amount').addClass('is-invalid');
          }
        }
      });
    });



    $('#product_id').on('change',function(){
      var type = $(this).find(':selected').data('type');

      if(type === 'f')
      {

        var amount = $(this).find(':selected').data('amount');
        document.getElementById("amount").value = amount;
        $('#amount').attr('readonly','readonly');
        $('#div-amount').fadeIn('slow');
      }

      if(type === 'x')
      {
        $('#div-amount').fadeIn('slow');
        $('#amount').removeAttr('readonly');
        document.getElementById("amount").value = null;
        document.getElementById("amount").placeholder = 'Please enter amount';
      }

    });




  });
</script><?php /**PATH C:\xampp\htdocs\clouddev\local\resources\views/clients/sub_add.blade.php ENDPATH**/ ?>