<?php

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::get('/', function () {
    return view('welcome');
});

Auth::routes();
//Session Check
Route::post('/session.test','SessionTestController@index');

Route::post('/notifications.get', 'NotificationController@get');
Route::post('/notifications.read', 'NotificationController@read');
Route::get('/notifications.invoice.{uuid}.{id}', 'NotificationController@getInvoice');


Route::get('/home', 'HomeController@index')->name('home');
Route::get('/user.add','UserController@add_user');
Route::post('/user.add.save','UserController@add_user_db');

Route::get('/user.list', 'UserController@display_users');
Route::post('/user.reset','UserController@reset_password');
Route::post('/user.password.change','UserController@change_password');
Route::get('/user.edit.{id}','UserController@edit_user_view');
Route::post('/user.edit.save','UserController@edit_user');
Route::post('/user.delete','UserController@delete_user');
Route::post('/user.restore','UserController@restore_user');
Route::get('/user.search','UserController@search_user');


//Configs Route
Route::get('/role.list','ConfigController@view_roles');
Route::get('/role.add','ConfigController@add_role');
Route::post('/role.add.save','ConfigController@save_role');
Route::get('/role.search','ConfigController@search_role');

//Mapping View
Route::get('role.add.privileges.{id}','ConfigController@addPrivilegeToRole');
Route::post('sync.privileges','ConfigController@addPrivilegeToRole_mapping');


//privileges
Route::get('privilege.list','ConfigController@view_privileges');
Route::get('/privilege.add','ConfigController@add_privilege');
Route::post('/privilege.add.save','ConfigController@save_privilege');
Route::get('/privilege.search','ConfigController@search_privilege');


//Licence
Route::get('/licence.list','ConfigController@view_licence');
Route::post('/licence.add','ConfigController@add_licence');
Route::post('/licence.edit','ConfigController@edit_licence');
Route::post('/licence.delete','ConfigController@delete_licence');



//Clients

Route::get('/client.list','ClientController@view_client');
Route::post('/client.add','ClientController@add_client');
Route::post('/client.edit','ClientController@edit_client');
Route::post('/client.delete','ClientController@delete_client');
Route::post('/client.restore','ClientController@restore_client');
Route::get('/client.detail.{id}','SubscriptionController@view_client_details');
Route::post('/client.subscription.{id}','SubscriptionController@view_client_subscription');
Route::post('/subscription.client.load','SubscriptionController@load_client_subscription');

//Subcriptions

Route::get('/subscription.list','SubscriptionController@view_subscription');
Route::post('/subscription.add','SubscriptionController@add_subscription');
Route::post('/subscription.edit','SubscriptionController@edit_subscription');
Route::post('/subscription.delete','SubscriptionController@delete_subscription');
Route::post('/subscription.restore','SubscriptionController@restore_subscription');


//Note product using Price Model
Route::get('/product.add','ProductController@add_products');
Route::post('/product.add.save','ProductController@save_products');
Route::get('/product.list','ProductController@list_products');
Route::get('/product.edit.{id}','ProductController@edit_products');
Route::post('/product.edit.save','ProductController@update_products');
Route::post('/product.delete','ProductController@delete_products');
Route::get('/product.restore','ProductController@restore_products_list');
Route::get('/product.search','ProductController@products_search');
Route::post('/product.restore','ProductController@restore_product');

Route::get('/invoice.sample','InvoiceController@sample');
Route::get('/invoice.pdf','InvoiceController@pdf');
Route::get('/invoice.email','InvoiceController@email');
Route::get('/invoice.list','InvoiceController@list_invoice');
Route::get('/invoice.view.{uuid}','InvoiceController@invoice_view');
Route::get('/invoice.list.{status}','InvoiceController@invoice_by_status');
Route::get('/invoice.training.list','InvoiceController@list_training_invoices');
Route::get('/invoice.proforma.list','InvoiceController@list_proforma_invoices');
Route::get('/invoice.copy.list','InvoiceController@list_copy_invoices');



Route::post('/client.invoice.{id}','InvoiceController@view_client_invoices');

//FRCS routes
Route::get('invoice.frcs.new.{uuid}','InvoiceController@generate_frcs_invoice');//id is uuid 1st step
Route::get('pac.auth.{status}.{uuid}','InvoiceController@view_authenticate_pac');// Authentication
Route::post('pac.auth','InvoiceController@authenticate_pac');// Authentication
Route::post('frcs.request','InvoiceController@prepare_request');// Preparing Request
Route::post('invoice.frcs.process','InvoiceController@change_frcs_status_to_process');//Once Request sent change status to x
Route::post('invoice.frcs.close','InvoiceController@close_frcs_invoice');//Store all the response sent by FRCS
Route::get('invoice.pdf.view.{uuid}','InvoiceController@invoice_pdf_view');//Display Reciept
// frcs routes end


//COPY INVOICE
Route::get('invoice.frcs.copy.{uuid}','InvoiceController@generate_copy_frcs_invoice');//id is uuid 1st step

Route::get('invoice.frcs.refund.{uuid}','InvoiceController@generate_refund_frcs_invoice');//id is uuid 1st step

Route::post('invoice.send.email','EmailController@send_email_by_uuid');//send email via uuid


Route::get('invoice.create','InvoiceController@create_invoice');
Route::post('invoice.create','InvoiceController@raise_invoice');
Route::post('invoice.payment_type.add','InvoiceController@add_payment_type');


Route::post('invoice.payment','InvoiceController@process_payment_type');
Route::post('invoice.payment.{uuid}','InvoiceController@update_payment_type');

Route::post('invoice.duedate.change.{uuid}','InvoiceController@change_duedate');

Route::post('invoice.frcs.unlock','InvoiceController@unlock_invoice');

Route::post('charges.products.checks','InvoiceController@checkProducts');
Route::post('charges.products.search','InvoiceController@seachProducts');
Route::post('charges.products.add','InvoiceController@addProductsToCharges');
Route::post('charges.product.one.remove','InvoiceController@removeOneProductsToCharges');
Route::post('charges.product.remove','InvoiceController@removeProductsToCharges');

//Note Brand using Price Model
Route::get('/brand.add','BrandController@add_brands');
Route::post('/brand.add.save','BrandController@save_brands');
Route::get('/brand.list','BrandController@list_brands');
Route::get('/brand.edit.{id}','BrandController@edit_brands');
Route::post('/brand.edit.save','BrandController@update_brands');
Route::post('/brand.delete','BrandController@delete_brands');
Route::get('/brand.restore','BrandController@restore_brands_list');
Route::get('/brand.search','BrandController@brands_search');
Route::post('/brand.restore','BrandController@restore_brand');


// Transaction

Route::get('/transaction.add.{uuid}','TransactionController@add_transaction');
Route::post('/transaction.add.{uuid}','TransactionController@add_transaction_post');
Route::get('/transaction.view.{id}','TransactionController@view_transaction');

Route::get('/invoice.search','InvoiceController@set_search_view');
Route::post('/invoice.search','InvoiceController@search_invoice');

Route::get('/tax.search','InvoiceController@tax_view');
Route::post('/tax.search','InvoiceController@tax_calculate');

// Tally
Route::get('/tally.today','InvoiceController@tally_today');
Route::get('/tally.custom','InvoiceController@custom_tally_view');
Route::post('/tally.custom','InvoiceController@custom_tally');


//Proforma 
Route::get('/invoice.raise.new.training.{uuid}','InvoiceController@raise_training_pf_invoice');
Route::get('/invoice.raise.new.normal.{uuid}','InvoiceController@raise_normal_pf_invoice');

Route::get('xml.upload','InvoiceController@xml_upload_view');
Route::post('xml.upload','InvoiceController@xml_upload');

Route::get('demo','HomeController@demo');
Route::get('api_clients','HomeController@api_clients');