@extends('layouts.app')
@section('pageTitle', 'Users')
@section('content')
<?php use App\Http\Controllers\ConfigController; ?>
<div class="container-fluid">

@if(ConfigController::check_privilege('ACCESS_SEARCH_USER'))
	<div class="offset-2 col-md-8 col-xs-12">
		<div class="card">
			<div class="card-header">Search User</div>
			<div class="card card-body">
				
				    <div class="col-lg-12">
				    <form id="searchForm" action="{{url('/user.search')}}" method="get">
				        <div class="input-group my-group"> 
				        {{ csrf_field() }}
				            <input type="text" class="form-control" id="myInput" name="search_term" placeholder="Search Term... " value="">
			            		<select name="search_type" class="selectpicker form-control" data-live-search="true" id="search_type">
			                        <option value="name">Name</option>
			                        <option value="email">Email Address</option>
			                        <option value="id">User ID</option>
			                    </select> 
			                    <span class="input-group-btn">
			    					<button class="btn btn-success" type="submit"><span class="fa fa-search"></span><span id="search_button"> Search</span></button>
			 					</span>
				        </div>
				    </form>
				        <!-- /input-group -->
				    </div>
				
			</div>
		</div>
	</div>
@endif

	<div class="col-md-12">
		<hr>
	</div>

</div>
<div>	
	<div class="card container">
	<div class="card-header">Users <span class="float-right"><a href="{{url('user.add')}}" class="btn btn-sm btn-primary">Add User</a></span></div>
	<div class="card-body">
	@if(count($data)>'0')
		<div class="table-responsive">
			<table class="table table-striped table-hover">
				<thead class="thead-dark">
					<th>ID</th>
					<th>Name</th>
					<th>Email</th>
					<th>Role</th>
					<th>Last Login</th>
					<th>IP</th>
					<th>Created By</th>				
					<th>Updated By</th>
					<th>Deleted At</th>
					<th></th>
					<th></th>
					<th></th>
				</thead>

				<tbody>
					@foreach($data as $value)
						<tr class="item{{$value->id}} @if($value->deleted_at <> null) danger @endif" >
							<td>{{$value->id}}</td>
							<td>{{$value->name}}</td>
							<td>{{$value->email}}</td>
							<td>{{ConfigController::get_role($value->role_id)}}</td>
							<td>{{$value->last_login}}</td>
							<td>{{$value->ip}}</td>
							<td>@foreach($users as $user) @if($user->id == $value->created_by){{$user->name}} @endif @endforeach</td>
							<td>@foreach($users as $user) @if($user->id == $value->updated_by){{$user->name}} @endif @endforeach</td>
							<td>{{$value->deleted_at}}</td>
							@if($value->deleted_at == null)
								<td class="edit{{$value->id}}">
									@if(ConfigController::check_privilege('ACCESS_USER_EDIT_PROFILE'))
										@if(Auth::user()->id <> $value->id)
											<a class="btn btn-primary" href="{{url('user.edit')}}.{{$value->id}}"><span class="fa fa-edit"></span></a>
										@endif
									@endif
								</td>			
								<td class="reset{{$value->id}}">
									@if(ConfigController::check_privilege('ACCESS_USER_RESET_PASSWORD'))
										@if(Auth::user()->id <> $value->id)	
											<a class="btn btn-warning reset-modal" data-id="{{$value->id}}" data-name="{{$value->name}}" data-email="{{$value->email}}"><span class="fa fa-unlock"></span></a>
										@endif	
									@endif
								</td>

								<td class="delete{{$value->id}}">
									@if(ConfigController::check_privilege('ACCESS_USER_DELETE_PROFILE'))
										@if(Auth::user()->id <> $value->id)		
											<a class="btn btn-danger delete-modal" data-id="{{$value->id}}" data-name="{{$value->name}}" data-email="{{$value->email}}"><span class="fa fa-trash"></span></a>
										@endif	
									@endif
								</td>
							@else
								<td class="edit{{$value->id}}">@if(ConfigController::check_privilege('ACCESS_RESTORE_USER'))<a class="btn btn-success restore-modal" data-id="{{$value->id}}" data-name="{{$value->name}}" data-email="{{$value->email}}"><span class="fa fa-refresh"></span></a>@endif</td>
								<td class="reset{{$value->id}}"></td>
								<td class="delete{{$value->id}}"></td>
							@endif
						</tr>
					@endforeach
				</tbody>
			</table>
			</div>
			</div>
		@else
			<div class="alert alert-warning">
				<div>Sorry, no result found.</div>
			</div>
		@endif
	</div>

<!--reset password modal-->
	<div id="myModal" class="modal fade" role="dialog">
		<div class="modal-dialog">
			<!-- Modal content-->
			<div class="modal-content">
				<div class="modal-header" id="modal-heading">
					<button type="button" class="close" data-dismiss="modal">&times;</button>
					<h4 class="modal-title"></h4>
				</div>
				<div class="modal-body">
					<div class="form-reset">
						<form class="form-horizontal resetForm" role="form" >
							<div class="alert" id="alert" style="display: none;">
								<span id="alert_message"></span>
							</div>
							<input type="hidden" name="reset_user_id" class="form-control" id="reset_user_id">
							<input type="hidden" name="reset_user_email" class="form-control" id="reset_user_email">
							<div class="form-group">
								<label class="control-label col-sm-2" for="name">Name:</label>
								<div class="col-sm-10">
									<input type="text" class="form-control" id="reset_user_name" disabled>
								</div>
							</div>

							<div class="form-group" id="div-password">
								<label class="control-label col-sm-2" for="name">Password:</label>
								<div class="col-sm-10">
									<input type="text" class="form-control" id="password">

									<span class="help-block">
		                                <strong id="error_password"></strong>
		                             </span>
								</div>
							</div>

						</form>
					</div>
						

					<div class="deleteContent">
						Are you Sure you want to remove username <span class="dname"></span> ? <span
							class="hidden did"></span><span class="hidden demail"></span>
					</div>

					<div class="restoreContent">
						Are you Sure you want to restore username <span class="uname"></span> ? <span
							class="hidden uid"></span><span class="hidden uemail"></span>
					</div>
					<div class="modal-footer">
						<button type="button" class="btn actionBtn" id="actionBtn">
							<span id="footer_action_button" class='fa'> </span>
						</button>
						<button type="button" class="btn btn-warning" data-dismiss="modal">
							<span class='fa fa-remove'></span> Close
						</button>
					</div>
				</div>
			</div>
		</div>
		

<!--reset password modal end -->

<script type="text/javascript">
//trigger RESET modal to Pop up
	$(document).on('click', '.reset-modal', function() {
		$('#modal-heading').addClass('modal-reset');
        $('#footer_action_button').text(" Reset");
        $('#footer_action_button').addClass('fa-unlock');
        $('#footer_action_button').removeClass('fa-refresh');
        $('#footer_action_button').removeClass('fa-trash');
        $('.actionBtn').addClass('btn-success');
        $('.actionBtn').removeClass('btn-danger');
        $('.actionBtn').addClass('reset');
        $('.modal-title').text('Reset Password');
        $('.deleteContent').hide();
        $('.restoreContent').hide();
        $('.resetForm').show();
        $('#reset_user_id').val($(this).data('id'));
        $('#reset_user_name').val($(this).data('name'));
        $('#reset_user_email').val($(this).data('email'));
        $('#myModal').modal('show');

        //remove all the errors from the modal
	    $('#actionBtn').removeClass('loading');

		$('#div-password').removeClass('has-error');
		$('#error_password').html('');

		$('#alert').fadeOut('slow');
		$('#alert').removeClass('alert-success');
		$('#alert_message').html('');    
    });


//for Reset AJAX Request
    $(document).on('click','.reset', function() {

    	$.ajax({
            type: 'post',
            url: "{{url('/user.reset')}}",
            data: {
                '_token': $('input[name=_token]').val(),
                'id': $("#reset_user_id").val(),
                'password': $('#password').val(),
                'name': $('#reset_user_name').val(),
                'email': $('#reset_user_email').val()
            },
            beforeSend:function(){
            	$('#actionBtn').addClass('loading');

            	$('#div-password').removeClass('has-error');
            	$('#error_password').html('');

            	$('#alert').fadeOut('slow');
            	$('#alert').removeClass('alert-success');
            	$('#alert_message').html('');            
            },
            success:function(data){
            	@if(ConfigController::check_privilege('ACCESS_JAVASCRIPT_LOGS'))
                	console.log(data);
                @endif      
            	$('#actionBtn').removeClass('loading');

            	$('#alert').addClass('alert-success');
            	$('#alert_message').html(data.message);
            	$('#alert').fadeIn('slow');
            },
            error:function(data){
            	$('#actionBtn').removeClass('loading');

            	@if(ConfigController::check_privilege('ACCESS_JAVASCRIPT_LOGS'))
                	console.log(data.responseText);
                @endif      

            	var obj = jQuery.parseJSON(data.responseText);

            	if(obj.password){
            		$('#div-password').addClass('has-error');
            		$('#error_password').html(obj.password);
            	}
            }

        });//AJAX Finishes 
    });

//trigger DELETE modal to Pop up
	$(document).on('click', '.delete-modal', function() {
        $('#footer_action_button').text(" Delete");
        $('#footer_action_button').removeClass('fa-check');
        $('#footer_action_button').removeClass('fa-refresh');
        $('#footer_action_button').addClass('fa-trash');
        $('.actionBtn').removeClass('btn-success');
        $('.actionBtn').addClass('btn-danger');
        $('.actionBtn').addClass('delete-user');
        $('.modal-title').text('Delete');
        $('.did').text($(this).data('id'));
        $('.resetForm').hide();
        $('.restoreContent').hide();
        $('.deleteContent').show();
        $('.dname').html($(this).data('name'));
        $('.demail').html($(this).data('email'));
        $('#myModal').modal('show');

    });

 $(document).on('click','.delete-user', function() {

 	$.ajax({
 		type:'post',
 		url:"{{url('/user.delete')}}",
 		data:{
 			'_token': $('input[name=_token]').val(),
            'id': $('.did').text()
 		},
 		beforeSend:function(){
            $('.delete-user').addClass('loading');
 		},
 		success:function(data){
        	$('.delete-user').removeClass('loading');
        	$('#footer_action_button').text(" Done");
        	$('#footer_action_button').removeClass('fa-trash');
        	$('#footer_action_button').addClass('fa-check');
        	$('.actionBtn').removeClass('btn-danger');
        	$('.actionBtn').addClass('btn-success');

        	@if(ConfigController::check_privilege('ACCESS_JAVASCRIPT_LOGS'))
            	console.log(data);
            @endif      

 			$('.item' + $('.did').text()).addClass('danger');

 			$('.edit' + $('.did').text()).html("@if(ConfigController::check_privilege('ACCESS_RESTORE_USER'))<a class='btn btn-success restore-modal' data-id='"+ $('.did').text() +"' data-name='"+ $('.dname').text()+"' data-email='"+ $('.demail').text()+"'><span class='fa fa-refresh'></span></a>@endif");
 			$('.reset' + $('.did').text()).html('');
 			$('.delete' + $('.did').text()).html('');

            setTimeout(function(){
            	$('#myModal').modal('hide');
            },2000);
 		},
 		error:function(data){
        	@if(ConfigController::check_privilege('ACCESS_JAVASCRIPT_LOGS'))
            	console.log(data.responseText);
            @endif      
 		}
 	});

 });



//trigger DELETE modal to Pop up
	$(document).on('click', '.restore-modal', function() {
        $('#footer_action_button').text(" Restore");
        $('#footer_action_button').removeClass('fa-check');
        $('#footer_action_button').removeClass('fa-trash');
        $('#footer_action_button').addClass('fa-refresh');
        $('.actionBtn').removeClass('btn-danger');
        $('.actionBtn').addClass('btn-success');
        $('.actionBtn').addClass('restore-user');
        $('.modal-title').text('Restore');
        $('.uid').text($(this).data('id'));
        $('.resetForm').hide();
        $('.deleteContent').hide();
        $('.restoreContent').show();
        $('.uname').html($(this).data('name'));
        $('.uemail').html($(this).data('email'));
        $('#myModal').modal('show');

    }); 	


 $(document).on('click','.restore-user', function() {

 	$.ajax({
 		type:'post',
 		url:"{{url('/user.restore')}}",
 		data:{
 			'_token': $('input[name=_token]').val(),
            'id': $('.uid').text()
 		},
 		beforeSend:function(){
            $('.restore-user').addClass('loading');
 		},
 		success:function(data){
			if(data.success)
			{
				$('.restore-user').removeClass('loading');
				$('#footer_action_button').text(" Done");
				$('#footer_action_button').removeClass('fa-refresh');
				$('#footer_action_button').addClass('fa-check');
				$('.actionBtn').removeClass('btn-danger');
				$('.actionBtn').addClass('btn-success');

				@if(ConfigController::check_privilege('ACCESS_JAVASCRIPT_LOGS'))
					console.log(data);
				@endif      

				$('.item' + $('.uid').text()).removeClass('danger');

				$('.edit' + $('.uid').text()).html("");

				$('.edit' + $('.uid').text()).html("@if(ConfigController::check_privilege('ACCESS_USER_RESET_PASSWORD')) <a class='btn btn-primary' href='{{url('user.edit')}}."+$('.uid').text()+"'><span class='fa fa-edit'></span></a> @endif");

				$('.reset' + $('.uid').text()).html("@if(ConfigController::check_privilege('ACCESS_USER_RESET_PASSWORD')) <a class='btn btn-warning reset-modal' data-id='"+$('.uid').text()+"' data-name='"+$('.uname').text()+"' data-email='"+$('.uid').text()+"'><span class='fa fa-unlock'></span></a> @endif");

				$('.delete' + $('.uid').text()).html("@if(ConfigController::check_privilege('ACCESS_USER_DELETE_PROFILE')) <a class='btn btn-danger delete-modal' data-id='"+$('.uid').text()+"' data-name='"+$('.name').text()+"' data-email='"+$('.uemail').text()+"'><span class='fa fa-trash'></span></a> @endif");
			}

			if(data.error)
			{
				swal({
					type:'error',
					title:'Error',
					text: data.error,
					animation: true
				});
			}
            setTimeout(function(){
            	$('.restore-user').removeClass('loading');
            	$('#myModal').modal('hide');
            },2000);
 		},
 		error:function(data){
        	@if(ConfigController::check_privilege('ACCESS_JAVASCRIPT_LOGS'))
            	console.log(data.responseText);
            @endif      
 		}
 	});

 });
</script>


@endsection 