@extends('layouts.app')

@section('content')
<?php use App\Http\Controllers\ConfigController; ?>
<div class="container">
    <div class="row">
        <div class="col-md-8 col-md-offset-2">
		<div class="panel" id="form_style">
			<div id="header">
		<h3>Edit User</h3>
	</div>
                <div class="panel-body">
                
                <div class="alert alert-success col-md-offset-2 col-md-8" id="alert" style="display: none;">
					<div id="alert_message"></div>
				</div>

                    <form class="form-horizontal" method="POST" action="{{url('/user.edit.save')}}" id="userEdit">
                        {{ csrf_field() }}

                        @foreach($users as $user)
                        <input type="hidden" name="id" value="{{$user->id}}">
                        <div class="form-group" id="div-email">
                            <label for="email" class="col-md-4 control-label">E-Mail Address</label>

                            <div class="col-md-6">
                                <input id="email" type="email" class="form-control" name="email" value="{{$user->email}}"  >

                                
                                    <span class="help-block">
                                        <strong id="error_email"></strong>
                                    </span>
                                
                            </div>
                        </div>

                        <div class="form-group" id="div-name">
                            <label for="name" class="col-md-4 control-label">Full Name</label>

                            <div class="col-md-6">
                                <input id="name" type="text" class="form-control" name="name" value="{{$user->name}}" >

                                
                                    <span class="help-block">
                                        <strong id="error_name"></strong>
                                    </span>
                                
                            </div>
                        </div>


                        <div class="form-group" id="div-tin_number">
                            <label for="tin_number" class="col-md-4 control-label">TIN Number</label>

                            <div class="col-md-6">
                                <input id="tin_number" type="text" class="form-control" name="tin_number" value="{{$user->tin_number}}" >

                                
                                    <span class="help-block">
                                        <strong id="error_tin_number"></strong>
                                    </span>
                                
                            </div>
                        </div>


                        <div class="form-group" id="div-role">
                            <label for="role" class="col-md-4 control-label">Role</label>

                            <div class="col-md-6">
                                <select id="role"  type="text" class="form-control" name="role" >
                                	<option value=""></option>
                                	@foreach($roles as $role)
                                		<option value="{{$role->id}}" @if($role->id == $user->role_id) selected="selected" @endif>{{$role->name}}</option>
                                	@endforeach
                                </select> 

                                
                                    <span class="help-block">
                                        <strong id="error_role"></strong>
                                    </span>
                                
                            </div>
                        </div>


                        <div class="form-group" id="div-pac">
                            <label for="pac" class="col-md-4 control-label">PAC</label>

                            <div class="col-md-6">
                                <input id="pac" type="text" class="form-control" name="pac" value="{{$user->pac}}">

                                
                                    <span class="help-block">
                                        <strong id="error_pac"></strong>
                                    </span>
                                
                            </div>
                        </div>



                        <div class="form-group">
                            <div class="col-md-6 col-md-offset-4">
                                <button type="submit" class="btn btn-primary col-md-5" id="submit">
                                    Edit User
                                </button>
                                <a href="{{url('user.agreement.payroll')}}.{{$user->id}}" class="btn btn-danger col-md-offset-2 col-md-5" >
                                    Payroll Agreement 
                                </a>
                            </div>
                        </div>

                        @endforeach
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
<script type="text/javascript">
	$(document).ready(function(){
		$('#userEdit').submit(function(e){
			e.preventDefault();
			var formData, url;

			url = $(this).attr('action');
			formData = $('#userEdit').serialize();

			$.ajax({
				data:formData,
				url:url,
				type:'post',
				beforeSend:function(){
					$('#submit').addClass('loading');

					$('#div-email').removeClass('has-error');
					$('#error_email').html('');

					$('#div-name').removeClass('has-error');
					$('#error_name').html('');

					$('#div-role').removeClass('has-error');
					$('#error_role').html('');

					$('#div-tin_number').removeClass('has-error');
					$('#error_tin_number').html('');


					$('#div-pac').removeClass('has-error');
					$('#error_pac').html('');

				},
				success:function(data){
	            	@if(ConfigController::check_privilege('ACCESS_JAVASCRIPT_LOGS'))
	                	console.log(data);
	                @endif      

					$('#submit').removeClass('loading');

					if(data.message){
						$('#alert').fadeIn('slow');
						$('#alert_message').html(data.message);
					}
				},
				error:function(data){
					
	            	@if(ConfigController::check_privilege('ACCESS_JAVASCRIPT_LOGS'))
	                	console.log(data.responseText);
	                @endif      

					var obj = jQuery.parseJSON(data.responseText);

					$('#submit').removeClass('loading');

					if(obj.email){
						$('#div-email').addClass('has-error');
						$('#error_email').html(obj.email);
					}

					if(obj.name){
						$('#div-name').addClass('has-error');
						$('#error_name').html(obj.name);
					}

					if(obj.role){
						$('#div-role').addClass('has-error');
						$('#error_role').html(obj.role);
					}

					if(obj.tin_number){
						$('#div-tin_number').addClass('has-error');
						$('#error_tin_number').html(obj.tin_number);
					}

					if(obj.pac){
						$('#div-pac').addClass('has-error');
						$('#error_pac').html(obj.pac);
					}
					
				}
			});
		});
	});
</script>
@endsection