@extends('layouts.app')
@section('pageTitle', 'Add User')
@section('content')
<?php use App\Http\Controllers\ConfigController; ?>
<div class="container">
    <div class="row">
        <div class="col-md-8 offset-2">
		<div class="card" id="form_style">
			<div class="card-header">Add User</div>
                <div class="card-body">
                
                <div class="alert col-md-12" id="alert" style="display: none;">
					<div id="alert_message"></div>
				</div>

                    <form class="form-horizontal" method="POST" action="{{url('/user.add.save')}}" id="userAdd">
                        {{ csrf_field() }}

                        <div class="form-group row" id="div-email">
                            <label for="email" class="col-md-4 control-label">E-Mail Address</label>

                            <div class="col-md-6">
                                <input id="email" type="email" class="form-control" name="email" value="{{ old('email') }}"  >
                                        <div id="error_email"></div>
                            </div>
                        </div>

                        <div class="form-group row" id="div-name">
                            <label for="name" class="col-md-4 control-label">Full Name</label>

                            <div class="col-md-6">
                                <input id="name" type="text" class="form-control" name="name" >

                                        <div id="error_name"></div>

                            </div>
                        </div>

                        <div class="form-group row" id="div-tin_number">
                            <label for="tin_number" class="col-md-4 control-label">Tin Number</label>

                            <div class="col-md-6">
                                <input id="tin_number" type="text" class="form-control" name="tin_number" >
                                        <div id="error_tin_number"></div>
                            </div>
                        </div>


                        <div class="form-group row" id="div-role">
                            <label for="role" class="col-md-4 control-label">Role</label>

                            <div class="col-md-6">
                                <select id="role"  type="text" class="form-control" name="role" >
                                	<option value=""></option>
                                	@foreach($roles as $role)
                                		<option value="{{$role->id}}">{{$role->name}}</option>
                                	@endforeach
                                </select> 
                                        <div id="error_role"></div>                              
                            </div>
                        </div>


                        <div class="form-group row" id="div-pac">
                            <label for="pac" class="col-md-4 form-control-label">PAC</label>

                            <div class="col-md-6">
                                <input id="pac" type="text" class="form-control" name="pac" >   
                                <div id="error_pac"></div>
                               
                            </div>
                        </div>




                        <div class="form-group">
                            <div class="col-md-8 offset-4">
                                <button type="submit" class="btn btn-primary" id="submit">
                                    Add User
                                </button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
<script type="text/javascript">
	$(document).ready(function(){
		$('#userAdd').submit(function(e){
			
			e.preventDefault();
			var formData, url;

			url = $(this).attr('action');
			formData = $('#userAdd').serialize();

			$.ajax({
				data:formData,
				url:url,
				type:'post',
				beforeSend:function(){
					$('#submit').addClass('loading');

					$('#email').removeClass('is-invalid');
					$('#error_email').removeClass('invalid-feedback');
					$('#error_email').html('');

					$('#div-name').removeClass('has-danger');
					$('#error_name').removeClass('invalid-feedback');
					$('#error_name').html('');

					$('#div-role').removeClass('has-danger');
					$('#error_role').removeClass('invalid-feedback');
					$('#error_role').html('');


					$('#div-tin_number').removeClass('has-danger');
					$('#error_tin_number').removeClass('invalid-feedback');
					$('#error_tin_number').html('');

					$('#div-pac').removeClass('has-error');
					$('#error_pac').removeClass('invalid-feedback');
					$('#error_pac').html('');

					$('#alert').fadeOut('slow');
					$('#alert').removeClass('alert-success');
					$('#alert').removeClass('alert-danger');
					$('#alert_message').html('');

				},
				success:function(data){
	            	@if(ConfigController::check_privilege('ACCESS_JAVASCRIPT_LOGS'))
	                	console.log(data);
	                @endif      

					$('#submit').removeClass('loading');

					if(data.message)
					{
						$('#alert').fadeIn('slow');
						$('#alert').addClass('alert-success');
						$('#alert_message').html(data.message);
					}

					if(data.error)
					{
						$('#alert').fadeIn('slow');
						$('#alert').addClass('alert-danger');
						$('#alert_message').html(data.error);
					}

				},
				error:function(data){
					
	            	@if(ConfigController::check_privilege('ACCESS_JAVASCRIPT_LOGS'))
	                	console.log(data.responseText);
	                @endif      


					$('#submit').removeClass('loading');
					var obj = jQuery.parseJSON(data.responseText);
					//show alert
					$('#alert').fadeIn('slow');
					$('#alert').addClass('alert-danger');
					$('#alert_message').html(obj.message);

					// error elements
					var elements = obj.errors;

					if(elements.email){
						$('#email').addClass('is-invalid');
						$('#error_email').addClass('invalid-feedback');
						$('#error_email').html(elements.email);
					}

					if(elements.name){
						$('#name').addClass('is-invalid');
						$('#error_name').addClass('invalid-feedback');
						$('#error_name').html(elements.name);
					}

					if(elements.role){
						$('#role').addClass('is-invalid');
						$('#error_role').addClass('invalid-feedback');
						$('#error_role').html(elements.role);
					}

					if(elements.tin_number){
						$('#tin_number').addClass('is-invalid');
						$('#error_tin_number').addClass('invalid-feedback');
						$('#error_tin_number').html(elements.tin_number);
					}


					if(elements.pac){
						$('#pac').addClass('is-invalid');
						$('#error_pac').addClass('invalid-feedback');
						$('#error_pac').html(elements.pac);
					}
				}
			});
		});
	});
</script>
@endsection