@extends('layouts.app')
@section('pageTitle', 'Transaction Details')
@section('content')
<?php use App\Http\Controllers\ConfigController; ?>  
@if($transaction <> '')
<div class="row" style="font-size: 12px;">		
	<!-- Transaction	 -->
	
	<div class="col-xl-4 col-md-4  col-sm-12 col-xs-12 mb-4">
      <div class="card border-left-primary shadow h-100 py-2">
        <div class="card-body">
        	<label  class="col-md-12 control-label control-label-sm font-weight-bold text-primary text-uppercase mb-1">Transaction Details</label>
        	<div class="table-responsive  table-hover">
	        	<table class="table">
	        		<tbody>
	        			<tr>
	        				<th>Transaction #: </th>
	        				<td>{{$transaction->id}}</td>
	        			</tr>

	        			<tr>
	        				<th>Brand Name: </th>
	        				<td>{{ConfigController::get_brand_name($transaction->brand_id)}}</td>
	        			</tr>

	        			<tr>
	        				<th>Client Name: </th>
	        				<td>{{ConfigController::get_clientname($transaction->client_id)}}</td>
	        			</tr>

	        			<tr>
	        				<th>Status: </th>
	        				<td>@if($transaction->status) {{'POSTED'}} @endif</td>
	        			</tr>
	        			<tr>
	        				<th>Created By</th>
	        				<td>{{ConfigController::get_username($transaction->created_by)}}</td>
	        			</tr>

	        		</tbody>
	        	</table>
        	</div>

        </div>
      </div>
    </div>

<!-- FRCS -->
	<div class="col-xl-4 col-md-4 col-sm-12 col-xs-12 mb-4">
      <div class="card border-left-warning shadow h-100 py-2">
        <div class="card-body">
        	<label  class="col-md-12 control-label control-label-sm font-weight-bold text-primary text-uppercase mb-1">Balances & Payment</label>
        	<div class="table-responsive table-hover">
	        	<table class="table">
	        		<tbody>
	        			<tr>
	        				<th>Client Balance Before: </th>
	        				<td>$ {{$transaction->bal_before}} FJD</td>
	        			</tr>

            			
            			<tr>
	        				<th>Invoice Balance Before: </th>
	        				<td>$ {{$transaction->invoice_bal_before}} FJD</td>
	        			</tr>

            			<tr>
	        				<th>Payment Amount: </th>
	        				<td>$ {{$transaction->amount}} FJD</td>
	        			</tr>

	        			<tr>
	        				<th>Client Balance After: </th>
	        				<td>$ {{$transaction->bal_after}} FJD</td>
	        			</tr>

            			
            			<tr>
	        				<th>Invoice Balance After: </th>
	        				<td>$ {{$transaction->invoice_bal_after}} FJD</td>
	        			</tr>
        			</tbody>
    			</table>

        	</div>
      	</div>
      </div>
    </div>

<!-- Payments -->
	<div class="col-xl-4 col-md-4 col-sm-12 col-xs-12 mb-4">
      <div class="card border-left-danger shadow h-100 py-2">
        <div class="card-body">
        	<label  class="col-md-12 control-label control-label-sm font-weight-bold text-primary text-uppercase mb-1">Payments</label>
        	<div class="table-hover table-responsive">
        		<table class="table">
        			<tbody>
        				<tr>
        				
	        				<th>Payment Type:</th>
	        				<td>{{$transaction->payment_type}}</td>
        				
	        			</tr>      		
			            @if($transaction->payment_count <> '')

				            @php 
							    $i = 0; 
							@endphp 
							@while (++$i <= $transaction->payment_count) 

							
					        	<tr>
					        	
					            	<th>Payment Type {{$i}}:</th>
					            
					            	<td>{{$transaction['payment_type'.$i]}}</td>
					            </tr>

					        	<tr>
					        	
					            	<th>Payment Amount {{$i}}:</th>
					            
					            	<td>{{$transaction['payment_amount'.$i]}}</td>
					            </tr>
				            @endwhile
			            @endif
            		</tbody>
            	</table>
            </div>

        </div>
      </div>
    </div>





	<!-- emails -->
		<div class="col-xl-6 col-md-6  col-sm-12 col-xs-12 mb-4">
	      <div class="card border-left-danger shadow h-100 py-2">
	        <div class="card-body">
	        	<label  class="col-md-12 control-label control-label-sm font-weight-bold text-primary text-uppercase mb-1">Emails</label>
	        	@if(count($emails)<> 0)
	        	<div class="table-hover table-bordered table-responsive">
	        	<table class="table">
	        		<thead class="bg-secondary text-white">
	        			<th>Created At</th>
	        			<th>Sent</th>
	        		</thead>
	        		<tbody>
	        			
	        			@foreach($emails as $email)
	        			<tr>
		        			<td>{{$email->created_at}}</td>
		        			<td>{{$email->sent}}</td>		        			
		        		</tr>
	        			@endforeach
	        		</tbody>
	        	</table>
	        	</div>
	        	<hr>
	        	@else
	        	<div class="alert alert-info">No emails sent</div>

	        	@endif
	        </div>
	      </div>
	    </div>
<!-- emails end -->

</div>
@else
<div class="col-md-8 offset-md-2">
	<div class="alert alert-info">Sorry, there is no data for this transaction.</div>
</div>
@endif
          

@endsection