  
@extends('layouts.app')
@section('pageTitle', 'Add Transaction')
@section('content')
  <div class="container">

    <!-- Outer Row -->
    <div class="row justify-content-center">

      <div class="col-xl-10 col-lg-12 col-md-9">

        <div class="card o-hidden border-0 shadow-lg my-5">
          <div class="card-body p-0">
            <!-- Nested Row within Card Body -->
            <div class="row">
              <div class="offset-lg-2 col-lg-8">
                <div class="p-5">
                  <div class="text-center">
                    <h1 class="h4 text-danger mb-4">Add Transaction</h1>
                  </div>
                  <hr class="offset-3 col-6">
                  	<div class="alert" id="transaction_alert" style="display: none;">
		                <span id="transaction_alert_message"></span>
		            </div>
		            <form class="form-horizontal"  method="post" action="{{url('/transaction.add')}}.{{$uuid}}" id="form-add-transaction">

		            {{ csrf_field() }}

		            	<input type="hidden" name="id" value="{{$id}}">

				        <div class="form-group row" >
				            <label for="amount_due" class="offset-md-2 col-md-3 control-label control-label-sm">Amount Due</label>
				            
				            <div class="col-md-5">
				                <input type="text" name="amount_due" id="amount_due" class="form-control form-control-sm" value="{{abs($amount_left)}}" readonly="readonly">
				                <strong id="error_amount_due"></strong>
				            </div>
				        </div>
		            

				        <div class="form-group row" >
				            <label for="amount_paid" class="offset-md-2 col-md-3 control-label control-label-sm">Amount</label>
				            
				            <div class="col-md-5">
				                <input type="number" name="amount_paid" id="amount_paid" class="form-control form-control-sm" max="{{abs($amount_left)}}">
				                <strong id="error_amount_paid"></strong>
				            </div>
				        </div>


				  <!-- Payment Type -->
				        <div class="form-group row">
				            <label for="payment_type" class="offset-md-2 col-md-3 control-label control-label-sm">Payment Type</label>

				            <div class="col-md-5">
				            	<select id="payment_type" type="text" class="form-control form-control-sm" name="payment_type">
				                      <option value=""></option>
				                      <option value="Cash">Cash</option>
				                      <option value="Other">Other</option>
				                      <option value="Card">Card</option>
				                      <option value="Check">Cheque</option>
				                      <option value="WireTransfer">Wire Transfer</option>
				                      <option value="Voucher">Voucher</option>
				                      <option value="MobileMoney">Mobile Money</option>
				                      <option value="SplitPayment">Split Payment</option>
				                </select>
				                <strong id="error_payment_type"></strong>
				            </div>
				        </div>


				        <div class="form-group row" id="div-count" style="display: none;">
				          <label for="count" class="offset-md-2 col-md-3 control-label control-label-sm">Count</label>
				           <div class="col-md-5">
				            <select name="count" class="form-control form-control-sm" id="count">
				                  <option value=""></option>
				                  <option value="2">2</option>
				                  <option value="3">3</option>
				            </select>
				            <strong id="error_payment_type"></strong>
				          </div>
				        </div>  

				<!-- Payment 1 -->
				        <div class="form-group row" id="div-payment_type1" style=" display: none;">
				          <label for="payment_type1" class="offset-md-2 col-md-3 control-label control-label-sm">Payment Type 1</label>

				          <div class="col-md-3">
				            <select name="payment_type1" class="form-control form-control-sm" id="payment_type1">
				                  <option value=""></option>
				                  <option value="Cash">Cash</option>
				                  <option value="Other" >Other</option>
				                  <option value="Card">Card</option>
				                  <option value="Check">Cheque</option>
				                  <option value="WireTransfer">Wire Transfer</option>
				                  <option value="Voucher">Voucher</option>
				                  <option value="MobileMoney">Mobile Money</option>
				            </select>
				          </div>

				          <div class="col-md-2" id="div-payment_total1">
				              <input type="text" name="payment_total1" id="payment_total1" class="form-control form-control-sm" placeholder="$$">
				          </div>

				        </div>   

				<!-- Payment 2 -->
				        <div class="form-group row" id="div-payment_type2" style="display: none;">
				          <label for="payment_type2" class="offset-md-2 col-md-3 control-label control-label-sm">Payment Type 2</label>

				          <div class="col-md-3">
				            <select name="payment_type2" class="form-control form-control-sm" id="payment_type2">
				                  <option value=""></option>
				                  <option value="Cash">Cash</option>
				                  <option value="Other" >Other</option>
				                  <option value="Card">Card</option>
				                  <option value="Check">Cheque</option>
				                  <option value="WireTransfer">Wire Transfer</option>
				                  <option value="Voucher">Voucher</option>
				                  <option value="MobileMoney">Mobile Money</option>
				            </select>
				          </div>

				          <div class="col-md-2" id="div-payment_total2">
				              <input type="text" name="payment_total2" id="payment_total2" class="form-control form-control-sm" placeholder="$$">
				          </div>

				        </div>   


				          <!-- Payment 3 -->
				        <div class="form-group row" id="div-payment_type3" style="display: none;">
				          <label for="payment_type3" class="offset-md-2 col-md-3 control-label control-label-sm">Payment Type 3</label>

				          <div class="col-md-4">
				            <select name="payment_type3" class="form-control form-control-sm" id="payment_type3">
				                  <option value=""></option>
				                  <option value="Cash">Cash</option>
				                  <option value="Other" >Other</option>
				                  <option value="Card">Card</option>
				                  <option value="Check">Cheque</option>
				                  <option value="WireTransfer">Wire Transfer</option>
				                  <option value="Voucher">Voucher</option>
				                  <option value="MobileMoney">Mobile Money</option>
				            </select>
				          </div>
				          <div class="col-md-2" id="div-payment_total3">
				              <input type="text" name="payment_total3" id="payment_total3" class="form-control" placeholder="$$">
				          </div>

				        </div>   

				        <div class="col-sm-12 offset-md-5 col-md-5">
				            <input type="checkbox" name="sendemail" style="margin-top:15px;" checked /> <label for"sendemail">Send Email</label>
				        
				        </div>



		                <div class="form-group">
		                    <div class="col-sm-12 col-md-8 offset-md-2 ">
		                        <button type="submit" class="btn btn-primary col-12"><i class="fa fa-cog"></i> 
		                            Process
		                        </button>
		                    </div>
		                </div>

		            </form>
                </div>
              </div>
            </div>
          </div>
        </div>

      </div>

    </div>

  </div>

<script type="text/javascript">

	$('#form-add-transaction').submit(function(e){
		e.preventDefault();
		var data,url;

		data = $(this).serialize();
		url = $(this).attr('action');

		$.ajax({
			type:'post',
			data:data,
			url:url,
      		success:function(data)
      		{	
      			if(data.success)
      			{
      				$('#form-add-transaction').html('');
      				$('#transaction_alert').addClass('alert-success');
		            $('#transaction_alert').fadeIn('slow');
		            $('#transaction_alert').html(data.success);

      			}

      			if(data.errors)
      			{
      				swal({
      					type:'error',
      					title:'Error',
      					text:data.errors
      				});
      			}
      		},
      		error:function(data)
      		{
      			var obj, errors;
      			obj = jQuery.parseJSON(data.responseText);
      			errors = obj.errors;

		          if(obj.message)
		          {
		            $('#transaction_alert').addClass('alert-danger');
		            $('#transaction_alert').fadeIn('slow');
		            $('#transaction_alert').html(obj.message);
		          }

      			if(errors.amount_paid)
      			{
      				$('#amount_paid').addClass('is-invalid');
      				$('#error_amount_paid').addClass('invalid-feedback');
      				$('#error_amount_paid').html(errors.amount_paid);
      			}


      			if(errors.payment_type)
      			{
      				$('#payment_type').addClass('is-invalid');
      				$('#error_payment_type').addClass('invalid-feedback');
      				$('#error_payment_type').html(errors.payment_type);
      			}


      			if(errors.payment_count)
      			{
      				$('#payment_count').addClass('is-invalid');
      				$('#payment_count').addClass('invalid-feedback');
      				$('#error_payment_count').html(errors.payment_count);
      			}
      		}
		});//ajax end
	});//Submit ends 


    $('#payment_type').on('change',function(){
      var payment_type = $('#payment_type').val();

      if(payment_type == 'SplitPayment'){
        $('#div-count').fadeIn('slow');

      }
      else
      {
          $('#div-count').fadeOut('slow');
          $('#div-payment_type1').fadeOut('slow');
          $('#div-payment_type2').fadeOut('slow');
          $('#div-payment_type3').fadeOut('slow');
      }


      $('#count').on('change',function(){
        var count = $('#count').val();


        if(count == '2')
        {
          $('#div-payment_type1').fadeIn('slow');
          $('#div-payment_type2').fadeIn('slow');
        }

        if(count == '3')
        {
          $('#div-payment_type1').fadeIn('slow');
          $('#div-payment_type2').fadeIn('slow');
          $('#div-payment_type3').fadeIn('slow');
        }
        if(count == '')
        {
          $('#div-payment_type1').fadeOut('slow');
          $('#div-payment_type2').fadeOut('slow');
          $('#div-payment_type3').fadeOut('slow');
        }

      });

      $('#payment_type1').on('change',function(){

          var value = $(this).val();
          if (value === '') return;

          var option = $("option[value='" + value + "']", '#payment_type2');
          option.attr("disabled","disabled");

          var option = $("option[value='" + value + "']", '#payment_type3');
          option.attr("disabled","disabled");
      });

      $('#payment_type2').on('change',function(){

          var value = $(this).val();
          if (value === '') return;

          var option = $("option[value='" + value + "']", '#payment_type1');
          option.attr("disabled","disabled");

          var option = $("option[value='" + value + "']", '#payment_type3');
          option.attr("disabled","disabled");
      });

      $('#payment_type3').on('change',function(){

          var value = $(this).val();
          if (value === '') return;

          var option = $("option[value='" + value + "']", '#payment_type1');
          option.attr("disabled","disabled");

          var option = $("option[value='" + value + "']", '#payment_type2');
          option.attr("disabled","disabled");
      });

  });

</script>
@endsection