@extends('layouts.app')
@section('pageTitle', 'Calculate Tax')
@section('content')
<?php use App\Http\Controllers\ConfigController; ?>

<div class="col-md-8 offset-md-2 col-sm-12" >


	<div class="card">
		<div class="card-header" id="card">Calculate Tax</div>
		<div class="card-body">
			<form class="form-horizontal" method="POST" action="{{url('tax.search')}}" id="form-submit">
				<!-- Start Date -->
				 @csrf
	            <div class="form-group row">
	                <label for="start_date" class="offset-md-2 col-md-3 control-label control-label-sm">Start Date</label>

	                <div class="col-md-5">
	                	<input id="start_date" type="date" class="form-control form-control-sm" name="start_date" value="{{$start_date}}">
	                    <strong id="error_start_date"></strong>
	                </div>
	            </div>

				<!-- End Date -->
	            <div class="form-group row">
	                <label for="end_date" class="offset-md-2 col-md-3 control-label control-label-sm">End Date</label>

	                <div class="col-md-5">
	                	<input id="end_date" type="date" class="form-control form-control-sm" name="end_date" value="{{$end_date}}">
	                    <strong id="error_end_date"></strong>
	                </div>
	            </div>


	           	<div class="form-group row">
	                <label for="invoice_type" class="offset-md-2 col-md-3 control-label control-label-sm">Invoice Type</label>

	                <div class="col-md-5">
	                	<select class="form-control form-control-sm" name="invoice_type" id="invoice_type">
	                		<option></option>
	                		<option value="Normal">Normal</option>
	                		<option value="Training">Training</option>
	                	</select>
	                </div>
	            </div>

				<!-- Invoice Submit -->
	            <div class="form-group row">
	                <div class="col-md-2 offset-md-8">
	                	<button type="submit" class="btn btn-primary col-12 btn-sm">Calculate</button>
	                </div>
	            </div>
	            
			</form>
		</div>
	</div>

	<div class="progress" style="height: 1px;">
			  <div class="progress-bar progress-bar-striped progress-bar-animated" role="progressbar" id="progress" style="width:0%; " aria-valuemin="0" aria-valuemax="100"></div>
	</div>

	<div id="data"></div>

<script type="text/javascript">
	$('#form-submit').submit(function(e){
		e.preventDefault();
		var formData,url;
		url = $(this).attr('action');
		formData = $(this).serialize();

		$.ajax({
			type: 'POST',
			url:url,
			data:formData,
			beforeSend:function()
			{
				document.getElementById('progress').style.width = '75%';
				$('#start_date').removeClass('is-invalid');
				$('#error_start_date').removeClass('invalid-feedback');
				$('#error_start_date').html('');
				$('#end_date').removeClass('is-invalid');
				$('#error_end_date').removeClass('invalid-feedback');
				$('#error_end_date').html('');				
				$('#invoice_type').removeClass('is-invalid');
				$('#error_invoice_type').removeClass('invalid-feedback');
				$('#error_invoice_type').html('');		
			},
			success:function(data){

				if(data.html)
				{
				
					document.getElementById('progress').style.width = '100%';
					$('#data').html(data.html);
				}

				if(data.error)
				{
					swal({
						  	type: 'error',
						  	title: 'Oops...',
						  	text: data.error,
						  	animation: true
					});
				}

				if(data.unauthorized_access)
				{
					swal({
						  	type: 'error',
						  	title: 'Oops...',
						  	text: data.unauthorized_access,
						  	animation: true
					});
				}
			},
			error:function(data){


				@if(ConfigController::check_privilege('ACCESS_JAVASCRIPT_LOGS'))
                	console.log(data.responseText);
                @endif      

				var obj = jQuery.parseJSON(data.responseText);
				var errors = obj.errors;

				swal({
					  	type: 'error',
					  	title: 'Oops...',
					  	text: obj.message,
					  	animation: true
				});
				
				if(errors.start_date){
					$('#start_date').addClass('is-invalid');
					$('#error_start_date').addClass('invalid-feedback');
					$('#error_start_date').html(errors.start_date);
				}

				if(errors.end_date){
					$('#end_date').addClass('is-invalid');
					$('#error_end_date').addClass('invalid-feedback');
					$('#error_end_date').html(errors.end_date);
				}

				if(errors.invoice_type){
					$('#invoice_type').addClass('is-invalid');
					$('#error_invoice_type').addClass('invalid-feedback');
					$('#error_invoice_type').html(errors.invoice_type);
				}

			}
		});
	});



	
</script>

</div>



@endsection