<?php use App\Http\Controllers\ConfigController; ?>
@if(count($subscriptions) > 0)
	<table class="table table-striped table-inverse table-hover table-bordered">
		<thead class="thead-dark">
			<tr>
				<th>ID</th>
				<th>Licence Type</th>
				<th>Number Authorized</th>
				<th>Created By</th>
				<th>Updated By</th>
				<th></th>
				<th></th>
			</tr>
		</thead>
		<tbody>
			@foreach($subscriptions as $subscription)
			<tr>
				<td>{{$subscription->id}}</td>
				<td>{{ucfirst($subscription->type)}}</td>
				<td>{{$subscription->number_allowed}}</td>
				<td>{{ConfigController::get_username($subscription->created_by)}}</td>
				<td>{{ConfigController::get_username($subscription->updated_by)}}</td>
				<td><button class="btn btn-sm btn-secondary edit-modal"
						data-id="{{$subscription->id}}"
						data-type="{{$subscription->type}}"
						data-number_allowed="{{$subscription->number_allowed}}">
						<span class="fa fa-edit"></span>
					</button>
				</td>
				<td><button class="btn btn-sm btn-danger delete-modal"
						data-id="{{$subscription->id}}">
						<span class="fa fa-trash"></span>
					</button>
				</td>
			</tr>
			@endforeach
		</tbody>
	</table>
@else
	<div class="alert alert-warning text-center">No Records Found</div>
@endif




