<?php use App\Http\Controllers\ConfigController; ?>
@if(count($products) > '0')
	<div class="table-responsive">
		<table class="table table-striped table-bordered  table-hover">
			<thead class="table-heading">
				<th>ID</th>
				<th>Name</th>
				<th>Description</th>
				<th>Created By</th>
				<th>Updated By</th>
				<th>Updated At</th>
				<th></th>
			</thead>
			<tbody>
			
				@foreach($products as $product)
					<tr class="item{{$product->id}}">
						<td>{{$product->id}}</td>
						<td>{{$product->name}}</td>
						<td>{!! nl2br($product->description) !!}</td>
						<td>{{ConfigController::get_username($product->created_by)}}</td>
						<td>{{ConfigController::get_username($product->updated_by)}}</td>
						<td>{{$product->updated_at}}</td>
						<td><a  class="btn btn-primary restore-modal" data-id="{{$product->id}}" data-name="{{$product->name}}" title="Restore Branch"><span class="fa fa-refresh"></span></a></td>	
					</tr>
				@endforeach
			
			</tbody>
		</table>
	</div>
@else
	<div class="alert alert-warning">
		<div>Sorry, no result found.</div>
	</div>
@endif

