<?php use App\Http\Controllers\ConfigController; ?>
@if(count($products)>'0')
	<div class="table-responsive">
		<table class="table table-striped table-bordered  table-hover table-sm">
			<thead class="table-heading bg-secondary text-white">
				<th>ID</th>
				<th>Name</th>
				<th>Type</th>
				<th>Ledger Type</th>
				<th>Labels</th>
				<th>Created By</th>
				<th>Updated By</th>
				<th>Updated At</th>
				<th>Amount</th>
				@if(ConfigController::check_privilege('ACCESS_EDIT_PRODUCT'))
					<th></th>
				@endif

				@if(ConfigController::check_privilege('ACCESS_DELETE_PRODUCT'))
					<th></th>
				@endif
			</thead>
			<tbody>
			
				@foreach($products as $product)
					<tr class="item{{$product->id}}">
						<td>{{$product->id}}</td>
						<td>{{$product->name}}</td>
						<td>
							<?php 				
								switch ($product->type) {
									case 'f':
										echo "Fixed";
										break;
									case 'x':
										echo "Flexible";
										break;
								}
							?>
						</td>
						<td>
							<?php 				
								switch ($product->ledger_type) {
									case 'r':
										echo "Revenue";
										break;
									case 'e':
										echo "Expense";
										break;
								}
							?>
						</td>
						<td style="font-size: 10px;">
						<?php
						$labels = json_decode($product->labels);
						foreach ($labels as $label => $value) {
							# code...
						
							switch($value){
							    case('A'):
							        echo "<li>Value Added Tax</li>";
							        break;

							    case('B'):
							        echo "<li>Value Added Tax Export</li>";
							        break;							    

							    case('C'):
							        echo "<li>Value AddedTax Excluded</li>";
							        break;

							    case('N'):
							        echo "<li>Non-Tax</li>";
							        break;

							    case('E'):
							        echo "<li>Service Turnover Tax</li>";
							        break;

							    case('F'):
							        echo "<li>Environment Climate Adaptation Levy</li>";
							        break;

							    case('P'):
							        echo "<li>lastic Bag Levy</li>";
							        break;


							    default:
							        echo "<span style='color:red; font-size:10px;'>Please Update Labels</span>";
							        break;
							}
						}
						?>
						</td>
						<td>{{ConfigController::get_username($product->created_by)}}</td>
						<td>{{ConfigController::get_username($product->updated_by)}}</td>
						<td>{{$product->updated_at}}</td>
						<td>${{$product->amount}}</td>
						@if(ConfigController::check_privilege('ACCESS_EDIT_PRODUCT'))
							<td><a href="{{url('/product.edit')}}.{{$product->id}}" class="btn btn-primary" title="Edit Product"><span class="fa fa-edit"></span></a></td>		
						@endif		

						@if(ConfigController::check_privilege('ACCESS_DELETE_PRODUCT'))
							<td><a  class="btn btn-danger delete-modal" data-id="{{$product->id}}" data-name="{{$product->name}}" title="Delete Product"><span class="fa fa-trash"></span></a></td>		
						@endif		
					</tr>
				@endforeach
			
			</tbody>
		</table>
	</div>
@else
	<div class="alert alert-warning">
		<div>Sorry, no result found.</div>
	</div>
@endif

