@extends('layouts.app')
@section('pageTitle', 'Edit Products')
@section('content')
<?php use App\Http\Controllers\ConfigController; ?>
@foreach($products as $product)
<div class="container">
    <div class="row">
        <div class="col-md-8 offset-2">
        <div class="card" id="form_style">
            <div class="card-header"><a class="btn btn-sm btn-link btn-spacer" title="Back" href="{{url('product.list')}}"><i class="fa fa-chevron-left"></i></a> Edit Product</div>
                <div class="card-body">
                
                <div class="alert alert-success offset-2 col-md-8" id="alert" style="display: none;">
                    <div id="alert_message"></div>
                </div>
<!-- name
type
ledger_type
amount
labels -->
                    <form class="form-horizontal" method="POST" action="{{url('/product.edit.save')}}" id="productEdit">
                        {{ csrf_field() }}


                        <div class="form-group row" id="div-name">
                            <label for="name" class="offset-2 control-label col-md-2 control-label-sm">Name</label>

                            <div class="col-md-6">
                                <input id="name" type="text" class="form-control form-control-sm" name="name" value="{{$product->name}}">
                                        <strong id="error_name"></strong> 
                            </div>
                        </div>

                        <div class="form-group row" id="div-type">
                            <label for="type" class="offset-2 col-md-2 control-label control-label-sm">Type</label>

                            <div class="col-md-6">
                                <select name="type" id="type" class="form-control form-control-sm">
                                    <option value="" ></option>
                                    <option value="f" @if($product->type == 'f') selected="selected" @endif>Fixed</option>
                                    <option value="x" @if($product->type == 'x') selected="selected" @endif>Flexiable</option>
                                </select>
                                        <strong id="error_type"></strong>                          
                            </div>
                        </div>


                        <div class="form-group row" id="div-ledger_type">
                            <label for="ledger_type" class="offset-2 col-md-2 control-label control-label-sm">Ledger Type</label>

                            <div class="col-md-6">
                                <select name="ledger_type" id="ledger_type" class="form-control form-control-sm">
                                    <option value="" ></option>
                                    <option value="r" @if($product->ledger_type == 'r') selected="selected" @endif>Revenue</option>
                                    <option value="e" @if($product->ledger_type == 'e') selected="selected" @endif>Expense</option>
                                </select>
                                        <strong id="error_ledger_type"></strong>                         
                            </div>
                        </div>

                        <div class="form-group row" id="div-labels">
                            <label for="labels" class="offset-2 col-md-2 control-label control-label-sm">Tax Labels</label>

                            <div class="col-md-6">
                                <?php 

                                    $labels = json_decode($product->labels);

                                ?>
                                <select name="labels[]" id="labels" class="form-control form-control-sm" multiple>
                                        <option value="A"@foreach($labels as $label => $value) @if($value == 'A') selected="selected" @endif @endforeach>Value Added Tax</option>
                                        <option value="B"@foreach($labels as $label => $value) @if($value == 'B') selected="selected" @endif @endforeach >Value Added Tax Export</option>
                                        <option value="C"@foreach($labels as $label => $value) @if($value == 'C') selected="selected" @endif @endforeach>Value AddedTax Excluded</option>                                   
                                        <option value="" ></option>
                                        <option value="E"@foreach($labels as $label => $value) @if($value == 'E') selected="selected" @endif @endforeach>Service Turnover Tax</option>
                                        <option value="F"@foreach($labels as $label => $value) @if($value == 'F') selected="selected" @endif @endforeach>Environment Climate Adaptation Levy</option>
                                        <option value="P"@foreach($labels as $label => $value) @if($value == 'P') selected="selected" @endif @endforeach>Plastic Bag Levy</option>
                                        <option value="N" @foreach($labels as $label => $value) @if($value == 'N') selected="selected" @endif @endforeach>Non-Tax</option>
                                    
                                </select>
                            
                                        <strong id="error_labels"></strong>
                                
                            </div>
                        </div>


                        <div class="form-group row" id="div-amount">
                            <label for="amount" class="offset-2 col-md-2 control-label control-label-sm">Amount</label>

                            <div class="col-md-6">
                                <input id="amount" type="number" step=".01" class="form-control form-control-sm" name="amount" value="{{$product->amount}}">
                                        <strong id="error_amount"></strong>
                                
                            </div>
                        </div>

                        <div class="form-group row" id="div-description">
                            <label for="description" class="offset-2 col-md-2 control-label control-label-sm">Desc</label>

                            <div class="col-md-6">
                                <textarea id="description" type="number" rows="4" class="form-control form-control-sm" name="description">{!! $product->description !!}</textarea>
                                        <strong id="error_description"></strong>
                                
                            </div>
                        </div>

                        <input type="hidden" name="id" value="{{$id}}">
                        <div class="form-group">
                            <div class="col-md-2 offset-9">
                                <button type="submit" class="btn btn-primary" id="submit">
                                    <i class="fa fa-pencil"></i>
                                </button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
<script type="text/javascript">
    $(document).ready(function(){
        $('#productEdit').submit(function(e){
            e.preventDefault();

            var url,formData;

            url = $(this).attr('action');
            formData = $('#productEdit').serialize();

            $.ajax({
                type:'post',
                data:formData,
                url:url,
                beforeSend:function(){
                    $('#submit').addClass('loading');

                    $('#alert').fadeOut('slow');
                    $('#alert_message').html('');
                    
                    $('#name').removeClass('is-invalid');
                    $('#type').removeClass('is-invalid');
                    $('#ledger_type').removeClass('is-invalid');
                    $('#labels').removeClass('is-invalid');
                    $('#amount').removeClass('is-invalid');

                },
                success:function(data){
                    @if(ConfigController::check_privilege('ACCESS_JAVASCRIPT_LOGS'))
                        console.log(data);
                    @endif

                    $('#submit').removeClass('loading');
                    
                    if(data.message){
                        $('#alert').fadeIn('slow');
                        $('#alert_message').html(data.message);
                    }
                },
                error:function(data){
                    @if(ConfigController::check_privilege('ACCESS_JAVASCRIPT_LOGS'))
                        console.log(data.responseText);
                    @endif

                    $('#submit').removeClass('loading');                    
                    
                    var obj = jQuery.parseJSON(data.responseText);
                    var errors = obj.errors;

                    
                    if(errors.name){
                        $('#name').addClass('is-invalid');
                        $('#error_name').addClass('invalid-feedback');
                        $('#error_name').html(errors.name);
                    }

                    
                    if(errors.type){
                        $('#type').addClass('is-invalid');
                        $('#error_type').addClass('invalid-feedback');
                        $('#error_type').html(errors.type);
                    }

                    
                    if(errors.ledger_type){
                        $('#ledger_type').addClass('is-invalid');
                        $('#error_ledger_type').addClass('invalid-feedback');
                        $('#error_ledger_type').html(errors.ledger_type);
                    }


                    if(errors.labels){
                        $('#labels').addClass('is-invalid');
                        $('#error_labels').addClass('invalid-feedback');
                        $('#error_labels').html(errors.labels);
                    }

                    if(errors.amount){
                        $('#amount').addClass('is-invalid');
                        $('#error_amount').addClass('invalid-feedback');
                        $('#error_amount').html(errors.amount);
                    }

                }
            });
        });

    });
</script>
@endforeach
@endsection