
<!doctype html>
<html>
  <head>

  <?php use App\Http\Controllers\ConfigController; ?>    
    <meta charset="utf-8">
    <title>Invoice</title>

<style type="text/css">

  	@import url("{{url('/startbootstrap/css/sb-admin-2.css')}}");
  	 @media print {

        .print-page {
          display: none;
        }        
        .back-page {
          display: none;
        }
        .card {
		    position: relative;
		    display: -webkit-box;
		    display: -ms-flexbox;
		    display: flex;
		    -webkit-box-orient: vertical;
		    -webkit-box-direction: normal;
		    -ms-flex-direction: column;
		    flex-direction: column;
		    min-width: 0;
		    word-wrap: break-word;
		    background-color: #fff;
		    background-clip: border-box;
		   	border: 0px solid #fff;
		   	
		}

          html, body {
            margin: 0;
            padding: 0;
            background: #FFF; 
          }

	    footer{
	    	display: none;
	    }

	}

	body{
		font-size: 12px;
		/*background-color: #efefef;*/
	}

	footer{
		padding-bottom: 50px;
	}
    .card {
	    position: relative;
	    display: -webkit-box;
	    display: -ms-flexbox;
	    display: flex;
	    -webkit-box-orient: vertical;
	    -webkit-box-direction: normal;
	    -ms-flex-direction: column;
	    flex-direction: column;
	    min-width: 0;
	    word-wrap: break-word;
	    background-color: #fff;
	    background-clip: border-box;
	   	border: 0px;
	   	margin-top: 30px;
	   	/*border: 1px solid #e3e6f0;*/
	}


	
      .print-page {
          position: fixed;
          right: 1rem;
          top: 1rem;
          width: 3.75rem;
          height: 2.75rem;
          text-align: center;
          color: #fff;
          background: rgba(90,92,105,.5);
          line-height: 46px;
          text-decoration: none;
          border-radius: 6px;
      }

      .back-page {
          position: fixed;
          left: 1rem;
          top: 1rem;
          width: 3.75rem;
          height: 2.75rem;
          text-align: center;
          color: #fff;
          background: rgba(90,92,105,.5);
          line-height: 46px;
          text-decoration: none;
          border-radius: 6px;
      }
  </style>

</head>

<body>
		<div class="">		
			<div class="container card my-12">
				<div class="card-body">
					<div class="text-center">
						<div style="text-align: center;padding-bottom: 10px;"><img alt="" src="{{url('img/Cloud-Dev-Logo.png')}}" height="40px" width="150px" align="center"></div>
		      			<div style="text-align: center;padding-bottom: 10px; color: #c4c5c2; font-size: 12px;"><i >Specialized in Web and Android Applications</i></div>
	      			</div>

	      			<div class="col-12"><hr></div>

	      			<div class="col-12">
	      				<div class="text-center">{{ConfigController::get_fiscal_status($data['invoice']->id)}}</div>
	      			</div>
	      			<br>
	      			<div class="row">  <!--QR Code-->
	      				<div class="col-6">
		      				<div class="float-left" style="font-size: 14px;">
		      					<br>        
		      				  	TIN: {{config('app.tin_number')}}<br>       
					          	Company: {{config('app.name')}}<br>
					          	Store: {{config('app.store')}}<br>
					          	Address: {{config('app.address')}}<br>
					          	District: {{config('app.district')}}<br>
					          	Cashier TIN: {{ConfigController::get_userTIN($data['invoice']->updated_by)}}<br>
					          	Email: {{config('app.email')}}<br>
					           	Mobile: {{config('app.mobile')}}<br>
		      				</div>
		      			</div>
		      			<div class="col-6">
		      				<div class="float-right">
		  		      			@if($data['url'] <> '')
						          <img src="data:image/png;base64,{{DNS2D::getBarcodePNG($data['url'], 'QRCODE')}}" alt="qrcode" id="qrcode" width="{{config('app.qr_size')}}" height="{{config('app.qr_size')}}">
						        @else
						          <img src="{{url('img/qr_code_na.png')}}" alt="qrcode" id="qrcode" width="{{config('app.qr_size')}}" height="{{config('app.qr_size')}}">
						        @endif
					         
		      				</div>
		      			</div>

	      			</div> <!--QR Code-->

	      			<br><br>
					<div class="row">
						<div class="col-6">
		      				<div class="float-left"  style="font-size: 14px;">
 								<u>Buyer Details</u><br>
					          {{$data['client']->business_name}}<br>
					          {{$data['client']->address}}<br>
					          Contact: {{$data['client']->phone_contact}}<br>
					          @if($data['client']->tin_number <> '')
					            Buyer TIN: {{$data['client']->tin_number}}<br>
					          @endif
		      				</div>
		      			</div>
						
						<div class="col-6">
							<div class="float-right">
								<div class="table table-responsive table-sm">
							        <table>
							          <tr>
							            <th><span >Invoice #</span></th>
							            <td><span >{{$data['invoice']->uuid}}</span></td>
							          </tr>
							          <tr>
							            <th><span >Date</span></th>
							            <td><span >{{$data['pos_time']}}</span></td>
							          </tr>
							          <tr>
							            <th><span >Total Amount</span></th>
							            <td><span id="prefix" >$ </span><span>{{ConfigController::two_decimal($data['total_amount'])}}</span></td>
							          </tr>
							          <tr>
							            <th><span >Balance</span></th>
							            <td><span id="prefix" >$ </span><span>{{ConfigController::two_decimal($data['transaction_bal'])}}</span></td>
							          </tr>

							          <tr>
							            <th><span >Status</span></th>
							            <td><span>{{ConfigController::print_invoice_status($data['status'])}}</span></td>
							          </tr>
							          </tr>
							          <tr>
							            <th><span >Payment Type</span></th>
							            <td><span>{{$data['payment_type']}}</span></td>
							          </tr>

							          @if($data['invoice']->payee_reference <> '')
							          <tr>
							            <th><span >Invoice Ref No.</span></th>
							            <td><span>{{ConfigController::get_uuid($data['invoice']->payee_reference)}}</span></td>
							          </tr>

							          <tr>
							            <th><span >SDC Ref No.</span></th>
							            <td><span>{{ConfigController::get_sdc_ref($data['invoice']->payee_reference)}}</span></td>
							          </tr>
							          @endif
							        </table>			
								</div>
							</div>
						</div>
					</div>
					<br>
					<div class="col-12 text-center"><span>{{ConfigController::get_invoice_status($data['invoice']->id)}}</span></div>
					<br>
					<div class="row">

						<div class="table table-responsive table-sm col-5">
							<table class="col-12  table-bordered">
					          <thead class="thead-dark">
					          	<tr><th colspan="5" style="text-align: center;">Items</th></tr>
					          </thead>
					            <tr class="thead-light">
					              <th><span >Item</span></th>
					              <th><span >Description</span></th>
					              <th><span >Rate</span></th>
					              <th><span >Quantity</span></th>
					              <th><span >Price</span></th>
					            </tr>
					          
					          <tbody>
					          @foreach($data['charges'] as $charge)
					            <tr>
					              <td><span >{{ConfigController::get_productName($charge->product_id)}} - {{ConfigController::get_product_labels($charge->product_id)}}</span></td>
					              <td><span >{{$charge->description}}</span></td>
					              <td><span data-prefix>$</span><span >{{ConfigController::two_decimal($charge->amount)}}</span></td>
					              <td><span >{{$charge->quantity}}</span></td>
					              @if($data['invoice']->transaction_type == 'Refund')
					              	<td><span data-prefix>$</span><span>{{'-'.ConfigController::two_decimal($charge->amount * $charge->quantity)}}</span></td>
					              @else
					              	<td><span data-prefix>$</span><span>{{ConfigController::two_decimal($charge->amount * $charge->quantity)}}</span></td>
					              @endif

					            </tr>
					          @endforeach
					          </tbody>
					        </table>
					    </div>
						<div class="table table-responsive table-sm col-5 offset-2">
							<table class="col-12 table-bordered">
								<thead class="thead-dark">
						        	<tr><th colspan="2" style="text-align: center;">Totals</th></tr>
						    	</thead>
						          <tr>
						            <th><span >Sub Total</span></th>
						            <td><span data-prefix>$</span><span><?php echo ConfigController::two_decimal($data['total_amount']-$data['total_tax']); ?></span></td>
						          </tr>
						          <tr>
						            <th><span >Total Tax</span></th>
						            <td><span data-prefix>$</span><span >{{ConfigController::two_decimal($data['total_tax'])}}</span></td>
						          </tr>
						          <tr>
						            <th><span >Total Amount</span></th>
						            <td><span data-prefix>$</span><span>{{ConfigController::two_decimal($data['total_amount'])}}</span></td>
						          </tr>
						    </table>
						</div>

					</div>

					<br>
					<div class="row">
						<div class="table table-responsive table-sm col-5">
							   	<table class="col-12  table-bordered">
						          <thead class="thead-dark">
						          	<tr><th colspan="4" style="text-align: center;">Tax Details</th></tr>
						          </thead>
						            <tr class="thead-light">
						              <th><span >Label</span></th>
						              <th><span >Name</span></th>
						              <th><span >Rate</span></th>
						              <th><span >Tax</span></th>
						            </tr>
						          
						          <tbody>
						          <?php $total_tax = 0; ?>
						          @foreach($data['taxs'] as $tax)
						          	@if($tax->label == 'P')
						            <tr>
						              <td><span >{{$tax->label}}</span></td>
						              <td><span >{{$tax->name}}</span></td>
						              <td><span data-prefix>$</span><span >{{ConfigController::two_decimal($tax->rate)}}</span></td>
						              <td><span >{{ConfigController::two_decimal($tax->tax)}}</span></td>
						              <?php $total_tax = $total_tax + $tax->tax; ?>
						            </tr>						          		
						          	@else
						            <tr>
						              <td><span >{{$tax->label}}</span></td>
						              <td><span >{{$tax->name}}</span></td>
						              <td><span >{{$tax->rate.'%'}}</span></td>
						              <td><span >{{ConfigController::two_decimal($tax->tax)}}</span></td>
						              <?php $total_tax = $total_tax + $tax->tax; ?>
						            </tr>
						            @endif
						          @endforeach
						          </tbody>
						        </table>
						    </div>
						

						<div class="table table-responsive table-sm col-5 offset-2">
							<table class="col-12 table-bordered">
						        <tr class="thead-dark"><th colspan="2" style="text-align: center;">SDC Details</th></tr>
						          <tr>
						            <th><span >SDC Invoice Number</span></th>
						            <td><span>{{$data['sdc_invoice_no']}}</span></td>
						          </tr>
						          <tr>
						            <th><span >Invoice Counter:</span></th>
						            <td><span>{{$data['invoice_counter']}}</span></td>
						          </tr>
						          <tr>
						            <th><span >SDC Time</span></th>
						            <td><span>{{ConfigController::convert_date($data['sdc_time'])}}</span></td>
						          </tr>
						    </table>
						</div>
					</div>
					<br><br>
					<div class="col-12">
	      				<div class="text-center">{{ConfigController::get_fiscal_status_end($data['invoice']->id)}}</div>
	      			</div>

	      			<br>

      				<div class="table table-sm  offset-1 col-10">
				        <!-- transactions -->
				        @if(count($data['transactions']) <> 0)
				        <table class="col-12 table-bordered">
				          <thead class="thead-dark ">
				          <tr><th colspan="6" style="text-align: center;">Transactions</th></tr>
				          </thead>
				            <tr class="thead-light">
				              <th colspan="2"><span >Date</span></th>
				              <th colspan="2"><span >Brand</span></th>
				              <th colspan="2"><span >Amount</span></th>
				            </tr>
				          
				          <tbody>
				          <?php $transaction_total = 0; ?>

				          @foreach($data['transactions'] as $transaction)
				            <tr>
				              <td colspan="2"><span >{{$transaction->created_at}}</span></td>
				              <td colspan="2"><span >{{ConfigController::get_brand_name($transaction->brand_id)}}</span></td>
				              <td colspan="2"><span data-prefix>$</span><span >{{ConfigController::two_decimal($transaction->amount)}}</span></td>
				              <?php $transaction_total = $transaction_total + $transaction->amount; ?>
				            </tr>
				          @endforeach
				            <tr>
				              <th colspan="4">Balance</th>
				              <th colspan="2"><span data-prefix>$</span> {{ConfigController::two_decimal($transaction_total)}}</th>
				            </tr>
				          </tbody>
				        </table>
				        @else
				          <table class="col-12">
				          <thead>
				            <tr><th colspan="6" style="text-align: center;">Transactions</th></tr>
				          </thead>
				          <tbody>
				            <tr><td colspan="6" style="text-align: center;">No Transaction found for this Invoice</td></tr>
				          </tbody>
				        </table>
				        @endif
					</div>


	      		</div> <!--Card Body end-->
			</div><!--Card end-->
		</div>

</body>


</html>