<!doctype html>
<html>
  <head>
	<?php use App\Http\Controllers\ConfigController; ?>    
	<style type="text/css">
	@import url("{{url('/startbootstrap/css/style.css')}}");
	@media url("{{url('/startbootstrap/ccss/print.css')}}");
</style>
<!-- 	<link rel='stylesheet' type='text/css' href='css/style.css' />
	<link rel='stylesheet' type='text/css' href='css/print.css' media="print" /> -->


</head>

<body>

	<div id="page-wrap">

		<textarea id="header">INVOICE</textarea>
		<div class="text-center">{{ConfigController::get_fiscal_status($data['invoice']->id)}}</div>
		<div id="identity">
			
            <textarea id="address">TIN: {{config('app.tin_number')}}      
Company: {{config('app.name')}}
Store: {{config('app.store')}}
Address: {{config('app.address')}}
District: {{config('app.district')}}
Cashier TIN: {{ConfigController::get_userTIN($data['invoice']->updated_by)}}
Email: {{config('app.email')}}
	Mobile: {{config('app.mobile')}}</textarea>

            <div id="logo">
              <div id="logohelp">
                <input id="imageloc" type="text" size="50" value="" /><br />
                (max width: 540px, max height: 100px)
              </div>
              <img id="image" src="{{url('img/client_logo.png')}}" alt="logo" height="40px" width="150px" />
            </div>
		
		</div>
		
		<div style="clear:both"></div>
		
		<div id="customer">

            <textarea id="customer-title" rows="7">

{{$data['client']->business_name}}
{{$data['client']->address}}
Contact: {{$data['client']->phone_contact}}
@if($data['client']->tin_number <> '')Buyer TIN: {{$data['client']->tin_number}}@endif</textarea>

            <table id="meta">
                <tr>
                    <td class="meta-head">Invoice #</td>
                    <td><textarea>{{$data['invoice']->uuid}}</textarea></td>
                </tr>
                <tr>

                    <td class="meta-head">Pos Date</td>
                    <td><textarea id="date">{{$data['pos_time']}}</textarea></td>
                </tr>
                <tr>
                    <td class="meta-head">Total Amount</td>
                    <td><div class="due">$ {{ConfigController::two_decimal($data['total_amount'])}}</div></td>
                </tr>
                <tr>
                    <td class="meta-head">Balance</td>
                    <td><div class="due">$ {{ConfigController::two_decimal($data['transaction_bal'])}}</div></td>
                </tr>                

                <tr>
                    <td class="meta-head">Status</td>
                    <td><div class="due">{{ConfigController::print_invoice_status($data['status'])}}</div></td>
                </tr>
                <tr>
                    <td class="meta-head">Payment Type</td>
                    <td><div class="due">{{$data['payment_type']}}</div></td>
                </tr>
                @if($data['invoice']->payee_reference <> '')
                <tr>
                    <td class="meta-head">Invoice Ref No.</td>
                    <td><div class="due">{{ConfigController::get_uuid($data['invoice']->payee_reference)}}</div></td>
                </tr>
                <tr>
                    <td class="meta-head">SDC Ref No.</td>
                    <td><div class="due">{{ConfigController::get_sdc_ref($data['invoice']->payee_reference)}}</div></td>
                </tr>
                @endif
            </table>
		
		</div>
		<br>
		<div class="text-center">{{ConfigController::get_invoice_status($data['invoice']->id)}}</div>
		<table id="items">
		
		  <tr>
		      <th>Item</th>
		      <th>Description</th>
		      <th>Unit Cost</th>
		      <th>Quantity</th>
		      <th>Price</th>
		  </tr>
		  @foreach($data['charges'] as $charge)
		  <tr class="item-row">
		      <td class="item-name"><div class="delete-wpr"><textarea>{{ConfigController::get_productName($charge->product_id)}} - {{ConfigController::get_product_labels($charge->product_id)}}</textarea></div></td>
		      <td class="description"><textarea>{{$charge->description}}</textarea></td>
		      <td><textarea class="cost">$ {{ConfigController::two_decimal($charge->amount)}}</textarea></td>
		      <td><textarea class="qty">{{$charge->quantity}}</textarea></td>
		      @if($data['invoice']->transaction_type == 'Refund')
		      <td><span class="price">$ {{'-'.ConfigController::two_decimal($charge->amount * $charge->quantity)}}</span></td>
		      @else
		      <td><span class="price">${{ConfigController::two_decimal($charge->amount * $charge->quantity)}}</span></td>
		      @endif
		  </tr>
		  @endforeach		  		  
		  <tr>
		      <td colspan="2" rowspan="3"style="border-top: 0;border-right: 0;">
		      	<table id="items">
		      		<tr><th colspan="4"style="text-align: center;">Tax Details</th></tr>
		      		<tr>
		              <th><span >Label</span></th>
		              <th><span >Name</span></th>
		              <th><span >Rate</span></th>
		              <th><span >Tax</span></th>
	              	</tr>

  					<?php $total_tax = 0; ?>
		        	@foreach($data['taxs'] as $tax)
		          		@if($tax->label == 'P')
		          		<tr>
			              <td><span >{{$tax->label}}</span></td>
			              <td><span >{{$tax->name}}</span></td>
			              <td><span data-prefix>$</span><span >{{ConfigController::two_decimal($tax->rate)}}</span></td>
			              <td><span >{{ConfigController::two_decimal($tax->tax)}}</span></td>
			              <?php $total_tax = $total_tax + $tax->tax; ?>
			            </tr>						          		
			          	@else
			            <tr>
			              <td><span >{{$tax->label}}</span></td>
			              <td><span >{{$tax->name}}</span></td>
			              <td><span >{{$tax->rate.'%'}}</span></td>
			              <td><span >{{ConfigController::two_decimal($tax->tax)}}</span></td>
			              <?php $total_tax = $total_tax + $tax->tax; ?>
			            </tr>
			            @endif
			        @endforeach
		      	</table>
		      </td>
		      <td colspan="1" class="blank"> </td>
		      <td colspan="1" class="total-line">Subtotal</td>
		      <td class="total-value"><div id="subtotal">$ <?php echo ConfigController::two_decimal($data['total_amount']-$data['total_tax']); ?></div></td>
		  </tr>
		  <tr>
		      <td colspan="1" class="blank"> </td>
		      <td colspan="1" class="total-line">Total Tax</td>

		      <td class="total-value"><textarea id="paid">$ {{ConfigController::two_decimal($data['total_tax'])}}</textarea></td>
		  </tr>
		  <tr>
		      <td colspan="1" class="blank"> </td>
		      <td colspan="1" class="total-line balance">Total Amount</td>
		      <td class="total-value balance"><div class="due">$ {{ConfigController::two_decimal($data['total_amount'])}}</div></td>
		  </tr>
		
		</table>
		<table id="items">			
			<tr class="thead-dark">
				<th><span >SDC Invoice Number</span></th>
	            <td><span>{{$data['sdc_invoice_no']}}</span></td>
				<td style="text-align: center;" rowspan="3">		  	
					@if($data['url'] <> '')
			          <img src="data:image/png;base64,{{DNS2D::getBarcodePNG($data['url'], 'QRCODE')}}" alt="qrcode" id="qrcode" width="{{config('app.qr_size')}}" height="{{config('app.qr_size')}}">
			        @else
			          <img src="{{url('img/qr_code_na.png')}}" alt="qrcode" id="qrcode" width="{{config('app.qr_size')}}" height="{{config('app.qr_size')}}">
			        @endif
				</td>
			</tr>

	          <tr>
	            <th><span >Invoice Counter:</span></th>
	            <td><span>{{$data['invoice_counter']}}</span></td>
	          </tr>
	          <tr>
	            <th><span >SDC Time</span></th>
	            <td><span>{{ConfigController::convert_date($data['sdc_time'])}}</span></td>
	          </tr>
				

			</tr>
		</table>
		<div id="terms">
		  
		  <div class="text-center">{{ConfigController::get_fiscal_status_end($data['invoice']->id)}}</div>
		</div>
	
	</div>
	
</body>

</html>