  <!-- The Modal -->
  <div class="modal fade" id="modal-edit">
    <div class="modal-dialog">
      <div class="modal-content">
      
        <!-- Modal Header -->
        <div class="modal-header">
          <h4 class="modal-title">Edit Licence</h4>
          <button type="button" class="close" data-dismiss="modal">&times;</button>
        </div>
        
        <!-- Modal body -->
        <div class="modal-body">
          <div id="edit_alert" class="alert" style="display: none;"></div>
                <form role="editLicence" method="POST" action="">
                    @csrf
                    <input id="edit_id" type="hidden"> 
                    <div class="form-group">
                        <div>
                            <select id="edit_licence_type" name="edit_licence_type" class="form-control">
                                <option value="">Licence Type</option>
                                <option value="user">User</option>
                                <option value="password">Password</option>
                            </select>
                        </div>
                    </div>
                    <div class="form-group">
                        <div>
                            <input type="number" class="form-control" name="edit_number_authorized" id="edit_number_authorized" placeholder="Number Authorized">
                        </div>
                    </div>
                </form>
        </div>
        
        <!-- Modal footer -->
        <div class="modal-footer">
          <button type="submit" class="btn btn-primary" id="submit-edit">Edit</button>
          <button type="button" class="btn btn-danger" data-dismiss="modal">Close</button>
        </div>
        
      </div>
    </div>
  </div>
  
</div>

<script type="text/javascript">
  $(document).ready(function(){
    $('#submit-edit').on('click',function(){
      $.ajax({
        type:"post",
        url:"{{url('licence.edit')}}",
        data:{
            '_token': $('input[name=_token]').val(),
            'licence_type': $("#edit_licence_type").val(),
            'number_authorized': $('#edit_number_authorized').val(),
            'id': $('#edit_id').val() 
        },
        beforeSend:function(data){
            $('#edit_alert').removeClass('alert-success');
            $('#edit_alert').removeClass('alert-danger');
            $('#edit_alert').fadeOut('slow');

            //Error remove classes
            $('#edit_licence_type').removeClass('is-invalid');
            $('#edit_number_authorized').removeClass('is-invalid');
        },
        success:function(data){
          if(data.success)
          {
            $('#edit_alert').addClass('alert-success');
            $('#edit_alert').fadeIn('slow');
            $('#edit_alert').html(data.success);

            licence_list_refresh();

            setTimeout(function() {
              $('#modal-edit').modal('hide');
            }, 4000);
          }

          if(data.error)
          {
            $('#edit_alert').addClass('alert-danger');
            $('#edit_alert').fadeIn('slow');
            $('#edit_alert').html(data.error);
          }
        },
        error:function(data){

          var obj = jQuery.parseJSON(data.responseText) ;
          var errors = obj.errors;

          if(obj.message)
          {
            $('#edit_alert').addClass('alert-danger');
            $('#edit_alert').fadeIn('slow');
            $('#edit_alert').html(obj.message);
          }

          if(errors.licence_type)
          {
            $('#edit_licence_type').addClass('is-invalid');
          }

          if(errors.number_authorized)
          {
            $('#edit_number_authorized').addClass('is-invalid');
          }
        }
      });
    });//end AJAX edit 

  });//end ready doc


  $(document).on('click', '.edit-modal', function() {
      $('#edit_id').val($(this).data('id'));
      $('#edit_number_authorized').val($(this).data('number_allowed'));
      $('#edit_licence_type').val($(this).data('type'));
      $('#modal-edit').modal('show');
  });
</script>