<?php use App\Http\Controllers\ConfigController; ?>
@if(count($licences) > 0)
	<table class="table table-striped table-inverse table-hover table-bordered">
		<thead class="thead-dark">
			<tr>
				<th>ID</th>
				<th>Licence Type</th>
				<th>Number Authorized</th>
				<th>Created By</th>
				<th>Updated By</th>
				<th></th>
				<th></th>
			</tr>
		</thead>
		<tbody>
			@foreach($licences as $licence)
			<tr>
				<td>{{$licence->id}}</td>
				<td>{{ucfirst($licence->type)}}</td>
				<td>{{$licence->number_allowed}}</td>
				<td>{{ConfigController::get_username($licence->created_by)}}</td>
				<td>{{ConfigController::get_username($licence->updated_by)}}</td>
				<td><button class="btn btn-sm btn-secondary edit-modal"
						data-id="{{$licence->id}}"
						data-type="{{$licence->type}}"
						data-number_allowed="{{$licence->number_allowed}}">
						<span class="fa fa-edit"></span>
					</button>
				</td>
				<td><button class="btn btn-sm btn-danger delete-modal"
						data-id="{{$licence->id}}">
						<span class="fa fa-trash"></span>
					</button>
				</td>
			</tr>
			@endforeach
		</tbody>
	</table>
@else
	<div class="alert alert-warning text-center">No Records Found</div>
@endif




