  <!-- The Modal -->
  <div class="modal fade" id="modal-add">
    <div class="modal-dialog">
      <div class="modal-content">
      
        <!-- Modal Header -->
        <div class="modal-header">
          <h4 class="modal-title">Add Licence</h4>
          <button type="button" class="close" data-dismiss="modal">&times;</button>
        </div>
        
        <!-- Modal body -->
        <div class="modal-body">
          <div id="alert" class="alert" style="display: none;"></div>
                <form role="addLicence" method="POST" action="">
                    @csrf
                    <div class="form-group">
                        <div>
                            <select id="licence_type" name="licence_type" class="form-control">
                                <option value="">Licence Type</option>
                                <option value="user">User</option>
                                <option value="password">Password</option>
                            </select>
                        </div>
                    </div>
                    <div class="form-group">
                        <div>
                            <input type="number" class="form-control" name="number_authorized" id="number_authorized" placeholder="Number Authorized">
                        </div>
                    </div>
                </form>
        </div>
        
        <!-- Modal footer -->
        <div class="modal-footer">
          <button type="submit" class="btn btn-primary" id="submit-add">Add</button>
          <button type="button" class="btn btn-danger" data-dismiss="modal">Close</button>
        </div>
        
      </div>
    </div>
  </div>
  
</div>

<script type="text/javascript">
  $(document).ready(function(){
    $('#submit-add').on('click',function(){
      $.ajax({
        type:"post",
        url:"{{url('licence.add')}}",
        data:{
            '_token': $('input[name=_token]').val(),
            'licence_type': $("#licence_type").val(),
            'number_authorized': $('#number_authorized').val() 
        },
        beforeSend:function(data){
            $('#alert').removeClass('alert-success');
            $('#alert').removeClass('alert-danger');
            $('#alert').fadeOut('slow');

            //Error remove classes
            $('#licence_type').removeClass('is-invalid');
            $('#number_authorized').removeClass('is-invalid');
        },
        success:function(data){
          if(data.success)
          {
            $('#alert').addClass('alert-success');
            $('#alert').fadeIn('slow');
            $('#alert').html(data.success);

            licence_list_refresh();
            
            setTimeout(function() {
              $('#modal-add').modal('hide');
            }, 4000);
          }

          if(data.error)
          {
            $('#alert').addClass('alert-danger');
            $('#alert').fadeIn('slow');
            $('#alert').html(data.error);
          }
        },
        error:function(data){

          var obj = jQuery.parseJSON(data.responseText) ;
          var errors = obj.errors;

          if(obj.message)
          {
            $('#alert').addClass('alert-danger');
            $('#alert').fadeIn('slow');
            $('#alert').html(obj.message);
          }

          if(errors.licence_type)
          {
            $('#licence_type').addClass('is-invalid');
          }

          if(errors.number_authorized)
          {
            $('#number_authorized').addClass('is-invalid');
          }
        }
      });
    });
  });
</script>