@if (Auth::guest())
  
  @else
 <!--Session password Change -->
  <div class="modal fade" id="change_password_modal" role="dialog" tabindex="-1" >
    <div class="modal-dialog">
    
      <!-- Modal content-->
      <div class="modal-content">
        <div class="modal-header danger" id="modal-header">
          
          <h4 class="modal-title"><i class="fa fa-refresh"></i> Change Password</h4>
        </div>
        <div class="modal-body">
            <form class="form-horizontal" action="{{url('/user.password.change')}}" method="post" id="formChangePassword">
            <div class="alert" id="new_password_alert" style="display: none;">
                <span id="new_password_alert_message"></span>
            </div>

            {{ csrf_field() }}
                <p>Please change password to continue using the services.</p>
            
                <div class="form-group" id="div-new_password">
                    <label for="new_password" class="col-md-4 control-label">New Password</label>

                    <div class="col-md-6">
                        <input id="new_password" type="password" class="form-control" name="new_password" autocomplete="off" required>

                            <span class="help-block">
                                <strong id="error_new_password"></strong>
                            </span>
                        
                    </div>
                </div>

                <div class="form-group" id="div-confirm_new_password">
                    <label for="new_password-confirm" class="col-md-4 control-label">Confirmed New Password</label>
                    <div class="col-md-6">
                        <input id="confirm_new_password" type="password" class="form-control" name="confirm_new_password" autocomplete="off" required>

                            <span class="help-block">
                                <strong id="error_confirm_new_password"></strong>
                            </span>
                        
                    </div>
                </div>

                <div class="form-group">
                    <div class="col-md-6 col-md-offset-4">
                        <button type="submit" class="btn btn-primary" id="submitChangePassword"><i id="btn-changeIcon" class="fa fa-refresh"></i> 
                            Change Password
                        </button>
                    </div>
                </div>

            </form>
        </div>
      </div>
    </div>
  </div> 

      @if(Auth::user()->reset == 'on')
        <script type="text/javascript">
            $(document).ready(function(){
                $('#change_password_modal').modal({
                      backdrop: 'static',
                      keyboard: false
                });


                $('#formChangePassword').submit(function(e){
                    e.preventDefault();

                    var url, formData;

                    url = $(this).attr('action');
                    formData = $('#formChangePassword').serialize();

                    $.ajax({
                        type:'post',
                        data:formData,
                        url:url,
                        beforeSend:function(){
                            $('#btn-changeIcon').addClass('fa-spin');  
                            $('#submitChangePassword').addClass('loading');

                            $('#div-new_password').removeClass('has-error');
                            $('#error_new_password').html('');
                            $('#div-confirm_new_password').removeClass('has-error');
                            $('#error_confirm_new_password').html('');  

                            $('#new_password_alert').removeClass('alert-success');
                            $('#new_password_alert_message').html('');

                            $('#new_password_alert').fadeOut('slow');
                        },
                        success:function(data){
                        
                            @if(ConfigController::check_privilege('ACCESS_JAVASCRIPT_LOGS'))
                                console.log(data.responseText);
                            @endif
                                      

                            $('#btn-changeIcon').removeClass('fa-spin');  
                            $('#submitChangePassword').removeClass('loading');

                            if(data.success){
                                $('#new_password_alert').addClass('alert-success');
                                $('#new_password_alert_message').html(data.success);

                                $('#new_password_alert').fadeIn('slow');

                                setTimeout(function(){
                                    $('#new_password_alert').removeClass('alert-success');
                                    $('#new_password_alert_message').html('');

                                    $('#new_password_alert').fadeOut('slow');

                                    $('#change_password_modal').modal('hide');

                                    @if(Auth::user()->role_id == '4')
                                        @if(Auth::user()->branch_id == '')
                                            $('#choose_branch').modal({
                                                  backdrop: 'static',
                                                  keyboard: false
                                            });
                                        @endif
                                    @endif

                                },5000);
                            }
                        },
                        error:function(data){

                            @if(ConfigController::check_privilege('ACCESS_JAVASCRIPT_LOGS'))
                                console.log(data.responseText);
                            @endif

                            $('#btn-changeIcon').removeClass('fa-spin');  
                            $('#submitChangePassword').removeClass('loading');

                            var obj = jQuery.parseJSON(data.responseText);

                            if(obj.new_password){
                                $('#div-new_password').addClass('has-error');
                                $('#error_new_password').html(obj.new_password);
                            }

                            if(obj.confirm_new_password){
                                $('#div-confirm_new_password').addClass('has-error');
                                $('#error_confirm_new_password').html(obj.confirm_new_password);                    
                            }
                        }
                    });//formChangePassword


                });//end document

            });
        </script>
    @endif
@endif