<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <!-- CSRF Token -->
    <meta name="csrf-token" content="{{ csrf_token() }}">

    <title>@yield('pageTitle') - {{config('app.name')}}</title> 


    <!-- Scripts -->
    <script src="{{ asset('js/app.js') }}" defer></script>

    <!-- Fonts -->
    <link rel="dns-prefetch" href="//fonts.gstatic.com">
    <link href="https://fonts.googleapis.com/css?family=Nunito" rel="stylesheet" type="text/css">

    <!-- Styles -->
    <link href="{{ asset('css/app.css') }}" rel="stylesheet"> 
    <link href="{{ asset('css/loader.css') }}" rel="stylesheet">
    <link href="{{ asset('css/custom.css') }}" rel="stylesheet">



<!-- <link rel="stylesheet" href="/resources/demos/style.css"> -->
    <link rel="stylesheet" type="text/css" href="{{ url('css/railway-font.css') }}">

    
    <!--Font Awesome library-->
    <link rel="stylesheet" href="{{url('css/font-awesome.min.css')}}">

    <!-- AJAX Library -->
    <script src="{{url('js/jquery_3_2_1.min.js')}}"></script>
    <!-- <script src="{{ url('js/bootstrap.min.js--') }}"></script> --><!-- Minified version will not allow dropmenu -->

    <link rel="stylesheet" href="{{url('css/sweetalert.css')}}">
    <link rel="stylesheet" href="{{url('css/animate.css')}}">
    <script src="{{ url('js/sweetalert.min.js') }}"></script>

<!-- File Upload Feature -->
    <link rel="stylesheet" type="text/css" href="{{ url('css/fileinput.css') }}">
    <script src="{{url('/js/fileinput.js')}}"></script>


</head>
<body>


<?php use App\Http\Controllers\ConfigController; ?>
    <div id="app">
        <nav class="navbar navbar-expand-md navbar-dark shadow-sm bg-dark sticky-top">
            <div class="container">
                <a class="navbar-brand" href="{{ url('/') }}">
                    {{ config('app.name', 'Laravel') }}
                </a>
                <button class="navbar-toggler" type="button" data-toggle="collapse" data-target="#navbarSupportedContent" aria-controls="navbarSupportedContent" aria-expanded="false" aria-label="{{ __('Toggle navigation') }}">
                    <span class="navbar-toggler-icon"></span>
                </button>

                <div class="collapse navbar-collapse" id="navbarSupportedContent">
                    <!-- Left Side Of Navbar -->
                    <ul class="navbar-nav mr-auto">

                    </ul>

                    <!-- Right Side Of Navbar -->
                    <ul class="navbar-nav ml-auto">
                        <!-- Authentication Links -->
                        @guest
                        <!--                             
                            <li class="nav-item">
                                <a class="nav-link" href="{{ route('login') }}">{{ __('Login') }}</a>
                            </li> 
                        -->
                        @else
                            <li class="nav-item dropdown">
                                <a id="navbarDropdown" class="nav-link dropdown-toggle" href="#" role="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false" v-pre>
                                    {{ Auth::user()->name }} <span class="caret"></span>
                                </a>

                                <div class="dropdown-menu dropdown-menu-right" aria-labelledby="navbarDropdown">
                                    @if(ConfigController::check_privilege('ACCESS_LIST_USER'))
                                        <a class="dropdown-item" href="{{url('user.list')}}"><span class="fa fa-users"></span>{{ __(' Users') }}</a>
                                    @endif

                                    @if(ConfigController::check_privilege('ACCESS_CONFIG_MENU'))
                                        <a class="dropdown-item" href="{{url('role.list')}}"><span class="fa fa-cogs"></span>{{ __(' Config Menu') }}</a>
                                    @endif

                                    @if(ConfigController::check_privilege('ACCESS_LICENCE_MENU'))
                                        <a class="dropdown-item" href="{{url('licence.list')}}"><span class="fa fa-credit-card"></span>{{ __(' Licence') }}</a>
                                    @endif

                                    @if(ConfigController::check_privilege('ACCESS_CLIENT_VIEW'))
                                        <a class="dropdown-item" href="{{url('client.list')}}"><span class="fa fa-group"></span>{{ __(' Clients') }}</a>
                                    @endif


                                    @if(ConfigController::check_privilege('ACCESS_LIST_PRODUCT'))
                                        <a class="dropdown-item" href="{{url('product.list')}}"><span class="fa fa-server"></span>{{ __(' Products') }}</a>
                                    @endif

                                    @if(ConfigController::check_privilege('ACCESS_LIST_BRAND'))
                                        <a class="dropdown-item" href="{{url('brand.list')}}"><span class="fa fa-cog"></span>{{ __(' Brands') }}</a>
                                    @endif

                                    <a class="dropdown-item" href="{{ route('logout') }}"
                                       onclick="event.preventDefault();
                                                     document.getElementById('logout-form').submit();"><i class="fa fa-sign-out"></i>
                                        {{ __(' Logout') }}
                                    </a>

                                    <form id="logout-form" action="{{ route('logout') }}" method="POST" style="display: none;">
                                        @csrf
                                    </form>
                                </div>
                            </li>
                        @endguest
                    </ul>
                </div>
            </div>
        </nav>

        <main class="py-4">
            @yield('content')
        </main>
    </div>
<!-- Password change -->

@if (Auth::guest())
  
  @else
 <!--Session password Change -->
  <div class="modal fade" id="change_password_modal" role="dialog" tabindex="-1" >
    <div class="modal-dialog">
    
      <!-- Modal content-->
      <div class="modal-content">
        <div class="modal-header danger" id="modal-header">
          
          <h4 class="modal-title"><i class="fa fa-refresh"></i> Change Password</h4>
        </div>
        <div class="modal-body">
            <form class="form-horizontal" action="{{url('/user.password.change')}}" method="post" id="formChangePassword">
            <div class="alert" id="new_password_alert" style="display: none;">
                <span id="new_password_alert_message"></span>
            </div>

            {{ csrf_field() }}
                <p>Please change password to continue using the services.</p>
            
                <div class="form-group row" id="div-new_password">
                    <label for="new_password" class="col-4 control-label">New Password</label>

                    <div class="col-6">
                        <input id="new_password" type="password" class="form-control" name="new_password" autocomplete="off" required>

                                <strong id="error_new_password"></strong>
                        
                    </div>
                </div>

                <div class="form-group row" id="div-confirm_new_password">
                    <label for="new_password-confirm" class="col-4 control-label">Confirmed New Password</label>
                    <div class="col-6">
                        <input id="confirm_new_password" type="password" class="form-control" name="confirm_new_password" autocomplete="off" required>
                                <strong id="error_confirm_new_password"></strong>
                        
                    </div>
                </div>

                <div class="form-group row">
                    <div class="col-6 offset-4">
                        <button type="submit" class="btn btn-primary" id="submitChangePassword"><i id="btn-changeIcon" class="fa fa-refresh"></i> 
                            Change Password
                        </button>
                    </div>
                </div>

            </form>
        </div>
      </div>
    </div>
  </div> 

      @if(Auth::user()->reset == 'on')
        <script type="text/javascript">
            $(document).ready(function(){
                $('#change_password_modal').modal({
                      backdrop: 'static',
                      keyboard: false
                });


                $('#formChangePassword').submit(function(e){
                    e.preventDefault();

                    var url, formData;

                    url = $(this).attr('action');
                    formData = $('#formChangePassword').serialize();

                    $.ajax({
                        type:'post',
                        data:formData,
                        url:url,
                        beforeSend:function(){
                            $('#btn-changeIcon').addClass('fa-spin');  
                            $('#submitChangePassword').addClass('loading');

                            $('#new_password').removeClass('is-invalid');
                            $('#error_new_password').html('');
                            $('#confirm_new_password').removeClass('is-invalid');
                            $('#error_confirm_new_password').html('');  

                            $('#new_password_alert').removeClass('alert-success');
                            $('#new_password_alert_message').html('');

                            $('#new_password_alert').fadeOut('slow');
                        },
                        success:function(data){
                        
                            @if(ConfigController::check_privilege('ACCESS_JAVASCRIPT_LOGS'))
                                console.log(data.responseText);
                            @endif
                                      

                            $('#btn-changeIcon').removeClass('fa-spin');  
                            $('#submitChangePassword').removeClass('loading');

                            if(data.success){
                                $('#new_password_alert').addClass('alert-success');
                                $('#new_password_alert_message').html(data.success);

                                $('#new_password_alert').fadeIn('slow');

                                setTimeout(function(){
                                    $('#new_password_alert').removeClass('alert-success');
                                    $('#new_password_alert_message').html('');

                                    $('#new_password_alert').fadeOut('slow');

                                    $('#change_password_modal').modal('hide');

                                    @if(Auth::user()->role_id == '4')
                                        @if(Auth::user()->branch_id == '')
                                            $('#choose_branch').modal({
                                                  backdrop: 'static',
                                                  keyboard: false
                                            });
                                        @endif
                                    @endif

                                },5000);
                            }
                        },
                        error:function(data){

                            @if(ConfigController::check_privilege('ACCESS_JAVASCRIPT_LOGS'))
                                console.log(data.responseText);
                            @endif

                            var obj = jQuery.parseJSON(data.responseText);

                            $('#btn-changeIcon').removeClass('fa-spin');  
                            $('#submitChangePassword').removeClass('loading');

                            $('#new_password_alert').fadeIn('slow');
                            $('#new_password_alert').addClass('alert-danger');
                            $('#new_password_alert_message').html(obj.message);

                            // error elements
                            var elements = obj.errors;


                            if(elements.new_password){
                                $('#new_password').addClass('is-invalid');
                                $('#error_new_password').html(obj.new_password);
                            }

                            if(elements.confirm_new_password){
                                $('#confirm_new_password').addClass('is-invalid');
                                $('#error_confirm_new_password').html(obj.confirm_new_password);                    
                            }
                        }
                    });//formChangePassword


                });//end document

            });
        </script>
    @endif
@endif



<!-- Password Change end -->




@if(Auth::guest())

@else
<script type="text/javascript">

    error = false; 


        setInterval(function(){ 
            if(error === false)
            {
                check_token(); 
            }
        }, 
        20000);





    function check_token(){
        var data = {'_token': $('input[name=_token]').val()};

        $.ajax({
            type:'post',
            data:data,
            url:"{{url('/session.test')}}",
            success:function(data)
            {
                if(data.token_error)
                {
                    error = true;
                    $('#change_password_modal').modal('hide');
                    $('#token_error').modal({
                      backdrop: 'static',
                      keyboard: false
                    });
                }
            },
            error:function(data){
                error = true;
               swal({
                    type:'error',
                    Animation: true,
                    title: 'Session Expired',
                    text: 'Another user logged in using same username or Session expired.'
               });
            }
        });
    }
</script>
@endif

</body>
</html>
