<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <!-- CSRF Token -->
    <meta name="csrf-token" content="{{ csrf_token() }}">

    <title>@yield('pageTitle') - {{config('app.name')}}</title> 


  <!-- Custom fonts for this template-->
  <link href="{{url('startbootstrap/vendor/fontawesome-free/css/all.min.css')}}" rel="stylesheet" type="text/css">
  <link href="https://fonts.googleapis.com/css?family=Nunito:200,200i,300,300i,400,400i,600,600i,700,700i,800,800i,900,900i" rel="stylesheet">

  <!-- Custom styles for this template-->
  <link href="{{url('startbootstrap/css/sb-admin-2.min.css')}}" rel="stylesheet">

    <!-- Styles -->
    <!-- <link href="{{ asset('css/app.css') }}" rel="stylesheet">  -->
    <link href="{{ asset('css/loader.css') }}" rel="stylesheet">
    <link href="{{ asset('css/custom.css') }}" rel="stylesheet">


    <!-- AJAX Library -->
    <script src="{{url('js/jquery_3_2_1.min.js')}}"></script>

    <link rel="stylesheet" href="{{url('css/sweetalert.css')}}">
    <link rel="stylesheet" href="{{url('css/animate.css')}}">
    <script src="{{ url('js/sweetalert.min.js') }}"></script>
    <script src="{{ url('js/sweetalert.min.js') }}"></script>

<!-- File Upload Feature -->
    <link rel="stylesheet" type="text/css" href="{{ url('css/fileinput.css') }}">
    <script src="{{url('/js/fileinput.js')}}"></script>


</head>
<body id="page-top">


<?php use App\Http\Controllers\ConfigController; ?>
  <!-- Page Wrapper -->
<div id="wrapper">
    @guest

    @else

    <script type="text/javascript">
      function notification_read(id){
        loader();
        var data = {'_token': $('input[name=_token]').val(),'id':id};
        var url = $('#'+id).data('url');

        $.ajax({
          type:'post',
          data:data,
          url:'{{url("notifications.read")}}',
          success:function(data)
          {
            if(data.response == 'success')
            {
              
              window.location.href = url;
              stop_loader();
            }
          }
        });

      }

      function load_notifications(){
        var data = {'_token': $('input[name=_token]').val()};
        $.ajax({
          type:'post',
          data:data,
          url:'{{url("notifications.get")}}',
          success:function(data)
          {
            $('#notifications').html(data.data);
          }
        });
      }

      $(window).on('load',function(){
        load_notifications();
        setInterval(function(){load_notifications();},'30000');
      });

    </script>


    <!-- Sidebar -->
    <ul class="navbar-nav bg-gradient-primary sidebar sidebar-dark toggled accordion" id="accordionSidebar">

      <!-- Sidebar - Brand -->
      <a class="sidebar-brand d-flex align-items-center justify-content-center" href="index.html">
        <div class="sidebar-brand-icon rotate-n-15">
          <i class="fas fa-compress-arrows-alt"></i>
        </div>
        <div class="sidebar-brand-text mx-3"><img src="{{url('img/Cloud-Dev-Logo.png')}}" width="100px" height="25px"></div>
      </a>

      <!-- Divider -->
      <hr class="sidebar-divider my-0">

      <!-- Nav Item - Dashboard -->
      <li class="nav-item">
        <a class="nav-link" href="{{route('home')}}">
          <i class="fas fa-fw fa-tachometer-alt"></i>
          <span>Dashboard</span></a>
      </li>

      <!-- Divider -->
      <hr class="sidebar-divider">

      <!-- Heading -->
      <div class="sidebar-heading">
        Interface
      </div>

      <!-- Nav Item - Pages Collapse Menu -->
      <li class="nav-item">
        <a class="nav-link collapsed" href="#" data-toggle="collapse" data-target="#collapseTwo" aria-expanded="true" aria-controls="collapseTwo">
          <i class="fas fa-fw fa-cog"></i>
          <span>Components</span>
        </a>
        <div id="collapseTwo" class="collapse" aria-labelledby="headingTwo" data-parent="#accordionSidebar">
          <div class="bg-white py-2 collapse-inner rounded">
            
                <h6 class="collapse-header">APP Components:</h6>
                @if(ConfigController::check_privilege('ACCESS_CONFIG_MENU'))
                    <a class="collapse-item" href="{{url('role.list')}}"><span class="fa fa-cogs"></span>{{ __(' Configs') }}</a>
                @endif

                @if(ConfigController::check_privilege('ACCESS_LICENCE_MENU'))
                    <a class="collapse-item" href="{{url('licence.list')}}"><span class="fas fa-credit-card"></span>{{ __(' Licence') }}</a>
                @endif

                @if(ConfigController::check_privilege('ACCESS_LIST_PRODUCT'))
                    <a class="collapse-item" href="{{url('product.list')}}"><span class="fas fa-server"></span>{{ __(' Products') }}</a>
                @endif

                @if(ConfigController::check_privilege('ACCESS_LIST_BRAND'))
                    <a class="collapse-item" href="{{url('brand.list')}}"><span class="fas fa-cog"></span>{{ __(' Brands') }}</a>
                @endif
          </div>
        </div>
      </li>

      <!-- Nav Item - Utilities Collapse Menu -->
      <li class="nav-item">
        <a class="nav-link collapsed" href="#" data-toggle="collapse" data-target="#collapseUtilities" aria-expanded="true" aria-controls="collapseUtilities">
          <i class="fas fa-fw fa-wrench"></i>
          <span>Utilities</span>
        </a>
        <div id="collapseUtilities" class="collapse" aria-labelledby="headingUtilities" data-parent="#accordionSidebar">
          <div class="bg-white py-2 collapse-inner rounded">
            <h6 class="collapse-header">Custom Utilities:</h6>
                @if(ConfigController::check_privilege('ACCESS_LIST_USER'))
                    <a class="collapse-item" href="{{url('user.list')}}"><span class="fa fa-users"></span>{{ __(' Users') }}</a>
                @endif

                @if(ConfigController::check_privilege('ACCESS_CLIENT_VIEW'))
                    <a class="collapse-item" href="{{url('client.list')}}"><i class="far fa-address-card"></i>{{ __(' Clients') }}</a>
                @endif
                
                @if(ConfigController::check_privilege('ACCESS_TELESCOPE'))
                    <a class="collapse-item" href="{{url('telescope')}}"><i class="fab fa-wpexplorer"></i>{{ __(' Telescope') }}</a>
                @endif

                @if(ConfigController::check_privilege('ACCESS_DOCUMENTATION'))
                    <a class="collapse-item" href="{{url('docs')}}"><i class="fas fa-book"></i>{{ __(' Documentation') }}</a>
                @endif
          </div>
        </div>
      </li>

      <!-- Divider -->
      <hr class="sidebar-divider">

      <!-- Heading -->
      <div class="sidebar-heading">
        Addons
      </div>

      <!-- Nav Item - Pages Collapse Menu -->
      <li class="nav-item">
        <a class="nav-link" href="#" data-toggle="collapse" data-target="#collapsePages" aria-expanded="true" aria-controls="collapsePages">
          <i class="fas fa-file-invoice"></i>
          <span> Invoices</span>
        </a>
        <div id="collapsePages" class="collapse" aria-labelledby="headingPages" data-parent="#accordionSidebar">
          <div class="bg-white py-2 collapse-inner rounded">
            <a class="collapse-item" href="{{url('invoice.create')}}"><i class="fas fa-plus-square"></i> Raise</a>
            
            <h6 class="collapse-header">Normal</h6>
            <a class="collapse-item" href="{{url('invoice.list')}}"><i class="fas fa-list"></i> List</a>
            <a class="collapse-item" href="{{url('invoice.list.unpaid')}}"><i class="far fa-file-alt"></i> Unpaid</a>
            <a class="collapse-item" href="{{url('invoice.list.overdue')}}"><i class="fas fa-remove-format"></i> Overdue</a>
            <a class="collapse-item" href="{{url('invoice.list.partial')}}"><i class="fas fa-receipt"></i> Partial Paid</a>
            <a class="collapse-item" href="{{url('invoice.list.paid')}}"><i class="fas fa-file-invoice-dollar"></i> Paid</a>
            <a class="collapse-item" href="{{url('invoice.list.refund')}}"><i class="fas fa-file-invoice-dollar"></i> Refund</a>
            <a class="collapse-item" href="{{url('invoice.copy.list')}}"><i class="fas fa-file-invoice-dollar"></i> Copy</a>
            <div class="collapse-divider"></div>
            <h6 class="collapse-header">Training</h6>
            <a class="collapse-item" href="{{url('invoice.training.list')}}"><i class="fas fa-list"></i> List</a>
            <h6 class="collapse-header">ProForma</h6>
            <a class="collapse-item" href="{{url('invoice.proforma.list')}}"><i class="fas fa-file-invoice-dollar"></i> Proforma</a>
            <h6 class="collapse-header">Custom</h6>
            <a class="collapse-item" href="{{url('invoice.search')}}"><i class="fas fa-search"></i> Search</a>
            <a class="collapse-item" href="{{url('tax.search')}}"><i class="fas fa-search-dollar"></i> Tax Search</a>
            <div class="collapse-divider"></div>
            <h6 class="collapse-header">Tally</h6>
            <a class="collapse-item" href="{{url('tally.today')}}"><i class="fas fa-funnel-dollar"></i> Today</a>
            <a class="collapse-item" href="{{url('tally.custom')}}"><i class="fas fa-hand-holding-usd"></i> Custom Tally</a>
          </div>
        </div>
      </li>


      <!-- Divider -->
      <hr class="sidebar-divider d-none d-md-block">
      
      <!-- Sidebar Toggler (Sidebar) -->
      <div class="text-center d-none d-md-inline">
        <button class="rounded-circle border-0" id="sidebarToggle"></button>
      </div>

    </ul>
    <!-- End of Sidebar -->

    <!-- Content Wrapper -->
    <div id="content-wrapper" class="d-flex flex-column">

      <!-- Main Content -->
      <div id="content">

        <!-- Topbar -->
        <nav class="navbar navbar-expand navbar-light bg-white topbar mb-4 static-top shadow">

          <!-- Sidebar Toggle (Topbar) -->
          <button id="sidebarToggleTop" class="btn btn-link  rounded-circle mr-3">
            <i class="fa fa-bars"></i>
          </button>

          <!-- Topbar Search -->
          <form class="d-none d-sm-inline-block form-inline mr-auto ml-md-3 my-2 my-md-0 mw-100 navbar-search">
            <div class="input-group">
              <input type="text" class="form-control bg-light border-0 small" placeholder="Search Pages..." aria-label="Search" aria-describedby="basic-addon2">
              <div class="input-group-append">
                <button class="btn btn-primary" type="button">
                  <i class="fas fa-search fa-sm"></i>
                </button>
              </div>
            </div>
          </form>

          <!-- Topbar Navbar -->
          <ul class="navbar-nav ml-auto">

            <!-- Nav Item - Search Dropdown (Visible Only XS) -->
            <li class="nav-item dropdown no-arrow d-sm-none">
              <a class="nav-link dropdown-toggle" href="#" id="searchDropdown" role="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                <i class="fas fa-search fa-fw"></i>
              </a>
              <!-- Dropdown - Messages -->
              <div class="dropdown-menu dropdown-menu-right p-3 shadow animated--grow-in" aria-labelledby="searchDropdown">
                <form class="form-inline mr-auto w-100 navbar-search">
                  <div class="input-group">
                    <input type="text" class="form-control bg-light border-0 small" placeholder="Search for..." aria-label="Search" aria-describedby="basic-addon2">
                    <div class="input-group-append">
                      <button class="btn btn-primary" type="button">
                        <i class="fas fa-search fa-sm"></i>
                      </button>
                    </div>
                  </div>
                </form>
              </div>
            </li>

            <!-- Nav Item - Alerts -->
            <li class="nav-item dropdown no-arrow mx-1" id="notifications">
              <!-- Notifications -->
            </li>

            <!-- Nav Item - Messages -->
            <li class="nav-item dropdown no-arrow mx-1">
              <a class="nav-link dropdown-toggle" href="#" id="messagesDropdown" role="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                <i class="fas fa-envelope fa-fw"></i>
                <!-- Counter - Messages -->
                <span class="badge badge-danger badge-counter">7</span>
              </a>
              <!-- Dropdown - Messages -->
              <div class="dropdown-list dropdown-menu dropdown-menu-right shadow animated--grow-in" aria-labelledby="messagesDropdown">
                <h6 class="dropdown-header">
                  Message Center
                </h6>
                <a class="dropdown-item d-flex align-items-center" href="#">
                  <div class="dropdown-list-image mr-3">
                    <img class="rounded-circle" src="https://source.unsplash.com/fn_BT9fwg_E/60x60" alt="">
                    <div class="status-indicator bg-success"></div>
                  </div>
                  <div class="font-weight-bold">
                    <div class="text-truncate">Hi there! I am wondering if you can help me with a problem I've been having.</div>
                    <div class="small text-gray-500">Emily Fowler · 58m</div>
                  </div>
                </a>
                <a class="dropdown-item d-flex align-items-center" href="#">
                  <div class="dropdown-list-image mr-3">
                    <img class="rounded-circle" src="https://source.unsplash.com/AU4VPcFN4LE/60x60" alt="">
                    <div class="status-indicator"></div>
                  </div>
                  <div>
                    <div class="text-truncate">I have the photos that you ordered last month, how would you like them sent to you?</div>
                    <div class="small text-gray-500">Jae Chun · 1d</div>
                  </div>
                </a>
                <a class="dropdown-item d-flex align-items-center" href="#">
                  <div class="dropdown-list-image mr-3">
                    <img class="rounded-circle" src="https://source.unsplash.com/CS2uCrpNzJY/60x60" alt="">
                    <div class="status-indicator bg-warning"></div>
                  </div>
                  <div>
                    <div class="text-truncate">Last month's report looks great, I am very happy with the progress so far, keep up the good work!</div>
                    <div class="small text-gray-500">Morgan Alvarez · 2d</div>
                  </div>
                </a>
                <a class="dropdown-item d-flex align-items-center" href="#">
                  <div class="dropdown-list-image mr-3">
                    <img class="rounded-circle" src="https://source.unsplash.com/Mv9hjnEUHR4/60x60" alt="">
                    <div class="status-indicator bg-success"></div>
                  </div>
                  <div>
                    <div class="text-truncate">Am I a good boy? The reason I ask is because someone told me that people say this to all dogs, even if they aren't good...</div>
                    <div class="small text-gray-500">Chicken the Dog · 2w</div>
                  </div>
                </a>
                <a class="dropdown-item text-center small text-gray-500" href="#">Read More Messages</a>
              </div>
            </li>

            <div class="topbar-divider d-none d-sm-block"></div>

            <!-- Nav Item - User Information -->
            <li class="nav-item dropdown no-arrow">
              <a class="nav-link dropdown-toggle" href="#" id="userDropdown" role="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                <span class="mr-2 d-none d-lg-inline text-gray-600 small">{{Auth::user()->name}}</span>
                <span  class="fas fa-user-circle"></span>
              </a>
              <!-- Dropdown - User Information -->
              <div class="dropdown-menu dropdown-menu-right shadow animated--grow-in" aria-labelledby="userDropdown">
                <a class="dropdown-item" href="#">
                  <i class="fas fa-user fa-sm fa-fw mr-2 text-gray-400"></i>
                  Profile
                </a>
                <a class="dropdown-item" href="#">
                  <i class="fas fa-cogs fa-sm fa-fw mr-2 text-gray-400"></i>
                  Settings
                </a>
                <a class="dropdown-item" href="#">
                  <i class="fas fa-list fa-sm fa-fw mr-2 text-gray-400"></i>
                  Activity Log
                </a>
                <div class="dropdown-divider"></div>
                <a class="dropdown-item" href="#" data-toggle="modal" data-target="#logoutModal">
                  <i class="fas fa-sign-out-alt fa-sm fa-fw mr-2 text-gray-400"></i>
                  Logout
                </a>
              </div>
            </li>

          </ul>

        </nav>
        <!-- End of Topbar -->
    @endguest
        <!-- Begin Page Content -->
        <div class="container-fluid">


        <main class="py-4">
            @yield('content')
        </main>

        </div>
        <!-- /.container-fluid -->

      </div>
      <!-- End of Main Content -->

      <!-- Footer -->
      <footer class="sticky-footer bg-white">
        <div class="container my-auto">
          <div class="copyright text-center my-auto">
            <span>Copyright &copy; Cloud Development 2019. All Rights Reserved. Version {{config('app.version')}}</span>
          </div>
        </div>
      </footer>
      <!-- End of Footer -->

    </div>
    <!-- End of Content Wrapper -->

  </div>
  <!-- End of Page Wrapper -->

  <!-- Scroll to Top Button-->
  <a class="scroll-to-top rounded" href="#page-top">
    <i class="fas fa-angle-up"></i>
  </a>


@guest

@else
  <!-- Logout Modal-->
  <div class="modal fade" id="logoutModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
      <div class="modal-content">
        <div class="modal-header">
          <h5 class="modal-title" id="LogoutModalLabel">Ready to Exit?</h5>
          <button class="close" type="button" data-dismiss="modal" aria-label="Close">
            <span aria-hidden="true">×</span>
          </button>
        </div>
        <div class="modal-body">Select "Logout" below if you are ready to end your current session.</div>
        <div class="modal-footer">
          <button class="btn btn-secondary" type="button" data-dismiss="modal">Cancel</button>
          <a class="btn btn-primary" href="{{ route('logout') }}"
                onclick="event.preventDefault();
                document.getElementById('logout-form').submit();">{{ __(' Logout') }}</a>
                <form id="logout-form" action="{{ route('logout') }}" method="POST" style="display: none;">
                    @csrf
                </form>
        </div>
      </div>
    </div>
  </div>

@endguest

    
<!-- Password change -->

@if (Auth::guest())
  
  @else
 <!--Session password Change -->
  <div class="modal fade" id="change_password_modal" role="dialog" tabindex="-1" >
    <div class="modal-dialog">
    
      <!-- Modal content-->
      <div class="modal-content">
        <div class="modal-header danger" id="modal-header">
          
          <h4 class="modal-title"><i class="fa fa-refresh"></i> Change Password</h4>
        </div>
        <div class="modal-body">
            <form class="form-horizontal" action="{{url('/user.password.change')}}" method="post" id="formChangePassword">
            <div class="alert" id="new_password_alert" style="display: none;">
                <span id="new_password_alert_message"></span>
            </div>

            {{ csrf_field() }}
                <p>Please change password to continue using the services.</p>
            
                <div class="form-group row" id="div-new_password">
                    <label for="new_password" class="col-4 control-label">New Password</label>

                    <div class="col-6">
                        <input id="new_password" type="password" class="form-control" name="new_password" autocomplete="off" required>

                                <strong id="error_new_password"></strong>
                        
                    </div>
                </div>

                <div class="form-group row" id="div-confirm_new_password">
                    <label for="new_password-confirm" class="col-4 control-label">Confirmed New Password</label>
                    <div class="col-6">
                        <input id="confirm_new_password" type="password" class="form-control" name="confirm_new_password" autocomplete="off" required>
                                <strong id="error_confirm_new_password"></strong>
                        
                    </div>
                </div>

                <div class="form-group row">
                    <div class="col-6 offset-4">
                        <button type="submit" class="btn btn-primary" id="submitChangePassword"><i id="btn-changeIcon" class="fa fa-refresh"></i> 
                            Change Password
                        </button>
                    </div>
                </div>

            </form>
        </div>
      </div>
    </div>
  </div> 

      @if(Auth::user()->reset == 'on')
        <script type="text/javascript">
            $(document).ready(function(){
                $('#change_password_modal').modal({
                      backdrop: 'static',
                      keyboard: false
                });


                $('#formChangePassword').submit(function(e){
                    e.preventDefault();

                    var url, formData;

                    url = $(this).attr('action');
                    formData = $('#formChangePassword').serialize();

                    $.ajax({
                        type:'post',
                        data:formData,
                        url:url,
                        beforeSend:function(){
                            $('#btn-changeIcon').addClass('fa-spin');  
                            $('#submitChangePassword').addClass('loading');

                            $('#new_password').removeClass('is-invalid');
                            $('#error_new_password').html('');
                            $('#confirm_new_password').removeClass('is-invalid');
                            $('#error_confirm_new_password').html('');  

                            $('#new_password_alert').removeClass('alert-success');
                            $('#new_password_alert_message').html('');

                            $('#new_password_alert').fadeOut('slow');
                        },
                        success:function(data){
                        
                            @if(ConfigController::check_privilege('ACCESS_JAVASCRIPT_LOGS'))
                                console.log(data.responseText);
                            @endif
                                      

                            $('#btn-changeIcon').removeClass('fa-spin');  
                            $('#submitChangePassword').removeClass('loading');

                            if(data.success){
                                $('#new_password_alert').addClass('alert-success');
                                $('#new_password_alert_message').html(data.success);

                                $('#new_password_alert').fadeIn('slow');

                                setTimeout(function(){
                                    $('#new_password_alert').removeClass('alert-success');
                                    $('#new_password_alert_message').html('');

                                    $('#new_password_alert').fadeOut('slow');

                                    $('#change_password_modal').modal('hide');

                                    @if(Auth::user()->role_id == '4')
                                        @if(Auth::user()->branch_id == '')
                                            $('#choose_branch').modal({
                                                  backdrop: 'static',
                                                  keyboard: false
                                            });
                                        @endif
                                    @endif

                                },5000);
                            }
                        },
                        error:function(data){

                            @if(ConfigController::check_privilege('ACCESS_JAVASCRIPT_LOGS'))
                                console.log(data.responseText);
                            @endif

                            var obj = jQuery.parseJSON(data.responseText);

                            $('#btn-changeIcon').removeClass('fa-spin');  
                            $('#submitChangePassword').removeClass('loading');

                            $('#new_password_alert').fadeIn('slow');
                            $('#new_password_alert').addClass('alert-danger');
                            $('#new_password_alert_message').html(obj.message);

                            // error elements
                            var elements = obj.errors;


                            if(elements.new_password){
                                $('#new_password').addClass('is-invalid');
                                $('#error_new_password').html(obj.new_password);
                            }

                            if(elements.confirm_new_password){
                                $('#confirm_new_password').addClass('is-invalid');
                                $('#error_confirm_new_password').html(obj.confirm_new_password);                    
                            }
                        }
                    });//formChangePassword


                });//end document

            });
        </script>
    @endif
@endif



<!-- Password Change end -->




@if(Auth::guest())

@else
<script type="text/javascript">

    error = false; 


        setInterval(function(){ 
            if(error === false)
            {
                check_token(); 
            }
        }, 
        20000);





    function check_token(){
        var data = {'_token': $('input[name=_token]').val()};

        $.ajax({
            type:'post',
            data:data,
            url:"{{url('/session.test')}}",
            success:function(data)
            {
                if(data.token_error)
                {
                    error = true;
                    $('#change_password_modal').modal('hide');
                    $('#token_error').modal({
                      backdrop: 'static',
                      keyboard: false
                    });
                }
            },
            error:function(data){
                error = true;
               swal({
                    type:'error',
                    Animation: true,
                    title: 'Session Expired',
                    text: 'Another user logged in using same username or Session expired.'
               });
            }
        });
    }
  function loader(){
  Swal({
    title: 'Loading',
    allowEscapeKey:false,
    allowOutsideClick: false,
  });
  Swal.showLoading()
}

function stop_loader(){
  Swal.close();
}
</script>


@endif


  <!-- Bootstrap core JavaScript-->
  <script src="{{url('startbootstrap/vendor/jquery/jquery.min.js')}}"></script>
  <script src="{{url('startbootstrap/vendor/bootstrap/js/bootstrap.bundle.min.js')}}"></script>

  <!-- Core plugin JavaScript-->
  <script src="{{url('startbootstrap/vendor/jquery-easing/jquery.easing.min.js')}}"></script>

  <!-- Custom scripts for all pages-->
  <script src="{{url('startbootstrap/js/sb-admin-2.min.js')}}"></script>
</body>
</html>
