@extends('layouts.app')
@section('pageTitle', 'XML Upload')
@section('content')
<?php use App\Http\Controllers\ConfigController; ?>
<div class="offset-md-2 col-md-8">
    <div class="card">
    
        <div class="card-header">Upload FRCS XML File</div>
    
        <div class="card-body">
            <div  style="display: none;" id="message"></div>
        <hr>
        <form class="form-horizontal" method="POST" id="form" action="{{url('/xml.upload')}}" enctype="multipart/form-data">
            <!--Name DIV-->
            {{ csrf_field() }}

            <!-- Loader start -->
              <div id="loader-wrapper">
                <div id="loader"></div>
              </div>
            <!-- Loader End -->

                
                

                <div class="form-group {{ $errors->has('file') ? ' has-error' : '' }}" id="div-file">
                    <div class="col-md-8 offset-md-3">
                      <div class="fileupload fileupload-new" data-provides="fileupload">
                          <input id='file' type="file" data-toggle="tooltip" name="file" title="Please upload *.xml file ONLY" data-placement="right" accept=".xml" id="fileupload" />
                      </div>

                    </div>
                    <span class="help-block col-md-8 offset-md-3">
                        <strong id="form-errors-file"></strong>
                    </span>
                </div>

                <div class="form-group">
                    <div class="col-md-8 offset-md-3">
                        <button type="submit" class="btn btn-success outline col-md-9" id="submit">
                            <i class="fa fa-upload" aria-hidden="true" ></i>
                            Upload XML File
                        </button>
                    </div> 
                </div>  

        </form>

        </div>
    </div>

</div>

<script type="text/javascript">
    $(window).on('load',function(){
        $('#loader-wrapper').fadeOut('slow');

        //when form is submited
      $('#form').submit(function(e){
        //below line prevents page to submit
        e.preventDefault();

        var form = $('#form')[0];
        var formData = new FormData(form);
        var url;
        url = $(this).attr('action');

            $.ajax({
                type:'POST',
                data: formData,
                cache:false,
                contentType: false,
                processData: false,
                url:url,

                beforeSend:function()
                {
                    $('#alert_success').fadeOut('slow');
                    $('#alert_error').fadeOut('slow');

                    $('#div-file').removeClass('has-error');
                    $('#form-errors-file').html('');

                    $('#submit').addClass('loading');
                },
                success:function(data)
                {
                    console.log(data);

                    if(data.html)
                    {
                        $('#submit').removeClass('loading');

                        $('#message').html(data.html);

                        $('#message').fadeIn('slow');
                    }

                    if(data.error)
                    {
                        $('#submit').removeClass('loading');

                        $('#alert_error').html(data.error);

                        $('#alert_error').fadeIn('slow');                        
                    }

                },
                error:function(data)
                {
                    $('#submit').removeClass('loading');

                    console.log(data.responseText);
                    var obj = jQuery.parseJSON(data.responseText);

                    if(obj.file){
                      $('#div-file').addClass('has-error');
                      $('#form-errors-file').html(obj.file);
                    }
                }

            });//AJAX end

        });

    });
</script>
@endsection