@extends('layouts.app')
@section('pageTitle', 'Invoice Details')
@section('content')
<?php use App\Http\Controllers\ConfigController; ?>  
<div class="row" style="font-size: 12px;">		
	<!-- Invoice	 -->
	<div class="col-xl-4 col-md-4  col-sm-12 col-xs-12 mb-4">
      <div class="card border-left-primary shadow h-100 py-2">
        <div class="card-body">
        	<label  class="col-md-12 control-label control-label-sm font-weight-bold text-primary text-uppercase mb-1">Invoice Details</label>
        	<div class="table-responsive  table-hover">
	        	<table class="table">
	        		<tbody>
	        			<tr>
	        				<th>Invoice #: </th>
	        				<td>{{$invoice->uuid}}</td>
	        			</tr>

	        			<tr>
	        				<th>Client: </th>
	        				<td>{{ConfigController::get_clientname($invoice->client_id)}}</td>
	        			</tr>

	        			<tr>
	        				<th>Status: </th>
	        				<td>{{ConfigController::print_invoice_status($invoice->status)}}</td>
	        			</tr>
	        			<tr>
	        				<th>Total Amount: </th>
	        				<td>{{'$ '.$invoice->total_amount.' FJD'}}</td>
	        			</tr>

	        			<tr>
	        				<th>Invoice Type: </th>
	        				<td>{{$invoice->invoice_type}}</td>
	        			</tr>

	        			<tr>
	        				<th>Transaction Type: </th>
	        				<td>{{$invoice->transaction_type}}</td>
	        			</tr>
	        			@if($invoice->invoice_type <> 'ProForma')
		        			@if($invoice->status <> 'p')
		        			<tr>
		        				<th>Due Date: </th>
		        				@if($invoice->due_date == '')
		        					<td><a id="due_date" style="margin-left: 5px;" href="#" data-toggle="modal" data-target="#duedatechange_modal"  class="btn btn-sm btn-outline-success">Set Due Date</a></td>
		        				@else
		        					<td id="due_date">{{$invoice->due_date}} <a style="margin-left: 5px;" href="#" data-toggle="modal" data-target="#duedatechange_modal" class="btn btn-sm btn-outline-success"><i class="fa fa-edit"></i></a></td>
		        				@endif
		        			</tr>
		        			@endif
		        		@endif

	        			<tr>
	        				<th>Invoice Time: </th>
	        				<td>{{$invoice->updated_at}}</td>
	        			</tr>
	        			@if($invoice->payee_reference <> '')
	        			<tr>
	        				<th>Reference Invoice ID</th>
	        				<td><a class="btn btn-sm btn-outline-info" href="{{url('invoice.view')}}.{{ConfigController::get_uuid($invoice->payee_reference)}}">{{ConfigController::get_uuid($invoice->payee_reference)}}</a></td>
	        			</tr>
	        			@endif

	        			@if($invoice->rollback_id <> '')
	        			<tr>
	        				<th>Reversal Invoice ID</th>
	        				<td><a class="btn btn-sm btn-outline-info" href="{{url('invoice.view')}}.{{ConfigController::get_uuid($invoice->rollback_id)}}">{{ConfigController::get_uuid($invoice->rollback_id)}}</a></td>
	        			</tr>
	        			@endif
	        		</tbody>
	        	</table>
        	</div>

        </div>
      </div>
    </div>

<!-- FRCS -->
	<div class="col-xl-4 col-md-4 col-sm-12 col-xs-12 mb-4">
      <div class="card border-left-warning shadow h-100 py-2">
        <div class="card-body">
        	<label  class="col-md-12 control-label control-label-sm font-weight-bold text-primary text-uppercase mb-1">FRCS Details</label>
        	<div class="table-responsive">
	        	<table class="table">
	        		<tbody>
	        			<tr>
	        				<th>FRCS Status: </th>
	        				<td>{!!ConfigController::get_frcs_status($invoice->frcs_verified)!!}</td>
	        			</tr>

            			@if($invoice->frcs_verified == '1')
            			<tr>
	        				<th>SDC Invoice #: </th>
	        				<td>{{$invoice->sdc_invoice_no}}</td>
	        			</tr>

            			<tr>
	        				<th>SDC Time #: </th>
	        				<td>{{$invoice->sdc_time}}</td>
	        			</tr>

            			<tr>
	        				<th>Invoice Counter: </th>
	        				<td>{{$invoice->invoice_counter}}</td>
	        			</tr>

            			<tr>
	        				<th>FRCS QR: </th>
	        				<td>@if($invoice->url <> '') {{'Y'}} @else 'N' @endif</td>
	        			</tr>

            			<tr>
	        				
	        				<td colspan="2">            	
	        					<div class="col-md-12">
	        						@if($invoice->invoice_type <> 'ProForma')
		        						@if($invoice->invoice_type <> 'Copy')
					            			<a class="btn btn-sm btn-outline-primary mb-1 col-12" href="{{url('invoice.frcs.copy')}}.{{$invoice->uuid}}">Copy</a>
					            		@endif

					            		@if($invoice->transaction_type <> 'Refund')
					            			@if($invoice->invoice_type <> 'Copy')
						            			@if($invoice->rollback_id == '')
						            				<a class="btn btn-sm btn-outline-danger mb-1 col-12" href="{{url('invoice.frcs.refund')}}.{{$invoice->uuid}}">Refund</a>
						            			@endif
						            		@endif
					            		@endif
					            	
					            		

					            		<a class="btn btn-sm btn-outline-warning mb-1 col-12" href="{{url('invoice.pdf.view')}}.{{$invoice->uuid}}">PDF</a>
					            		<a class="btn btn-sm btn-outline-info mb-1 col-12" onclick="send_email();">Send Email</a>

					            		@if(ConfigController::check_privilege('ACCESS_ADD_TRANSACTION'))
					            			@if($invoice->status <> 'p')
					            				@if($invoice->rollback_id == '')
					            				<a class="btn btn-sm btn-outline-success mb-1 col-12" href="{{url('transaction.add')}}.{{$invoice->uuid}}">Add Transaction</a>
					            				@endif
					            			@endif
					            		@endif
					            	@else
					            		@if($invoice->status <> 'e')
						            		@if(ConfigController::check_proforma_invoice('Training',$invoice->id));
						            			<a class="btn btn-sm btn-outline-info mb-1 col-12" href="{{url('invoice.raise.new.training')}}.{{$invoice->uuid}}">Raise Training Ticket</a>
						            		@endif

						            		@if(ConfigController::check_proforma_invoice('Normal',$invoice->id));
						            			<a class="btn btn-sm btn-outline-primary mb-1 col-12" href="{{url('invoice.raise.new.normal')}}.{{$invoice->uuid}}">Raise Normal Ticket</a>
						            		@endif
						            	@endif

					            	@endif
				            	</div>		
            				</td>
	        			</tr>

<script type="text/javascript">
	function send_email()
	{
		$.ajax({
			type:'post',
			url: "{{url('invoice.send.email')}}",
			data:{
				'uuid':'{{$invoice->uuid}}',
				'_token': $('input[name=_token]').val(),
			},
			beforeSend:function()
			{
				loader();
			},
			success:function(data)
			{
				stop_loader();

                if(data.success)
                {
                  swal({
                    type: 'success',
                    title: 'Success',
                    text: data.success,
                    animation: true
                  });
                }   

                if(data.error)
                {
                  swal({
                    type: 'error',
                    title: 'Error',
                    text: data.error,
                    animation: true
                  });
                }   
			},
			error:function(data)
			{
				stop_loader();
				swal({
                    type: 'error',
                    title: 'Error',
                    text: 'Oops, Something went wrong.',
                    animation: true
                  });

			}



		});
	}
</script>
      

            			@endif

			            @if($invoice->frcs_verified == 'x')
							<script type="text/javascript">
								function unlock_invoice()
								{
									$.ajax({
										type:'post',
										url: "{{url('invoice.frcs.unlock')}}",
										data:{
											'uuid':'{{$invoice->uuid}}',
											'_token': $('input[name=_token]').val(),
										},
										beforeSend:function()
										{
											loader();
										},
										success:function(data)
										{
											stop_loader();

							                if(data.success)
							                {
							                  swal({
							                    type: 'success',
							                    title: 'Success',
							                    text: data.success,
							                    animation: true
							                  });

							                  setTimeout(function() {location.reload(true);}, 3000);

							                }   

							                if(data.error)
							                {
							                  swal({
							                    type: 'error',
							                    title: 'Error',
							                    text: data.error,
							                    animation: true
							                  });
							                }   
										},
										error:function(data)
										{
											stop_loader();
											swal({
							                    type: 'error',
							                    title: 'Error',
							                    text: 'Oops, Something went wrong.',
							                    animation: true
							                  });

										}



									});
								}
							</script>
				           <tr>
				            	<td colspan="2">
				            		<a href="{{url('xml.upload')}}" class="btn btn-sm btn-outline-primary col-md-12 mb-1"><i class="fas fa-upload"></i> Upload XML File</a>
				                </td>
				           </tr>   

				            <tr>
				            	<td colspan="2">
				            		<button class="btn btn-sm btn-outline-danger col-md-12 mb-1"  onclick="unlock_invoice();"><i class="fas fa-unlock"></i> Unlock Invoice</button>
				            	</td>
				            </tr>

			            @endif

			            @if($invoice->frcs_verified == '0')
				            
			            	@if(count($charges)<> 0)
			            		@if($invoice->payment_type <> '')
							        <tr>   
						            	<td colspan="2">
						            		<a class="btn btn-sm btn-outline-primary col-md-12" href="{{url('invoice.frcs.new')}}.{{$invoice->uuid}}"><i class="fas fa-upload"></i> FRCS Verify</a>
						                </td>
									</tr>
								@else
									<tr>   
						            	<td colspan="2">
											<a onclick="event.preventDefault();
									                document.getElementById('payment-type-add').submit();" class="btn btn-sm btn-outline-primary col-md-12 mb-1">Add Payment Type</a>

									                <form id="payment-type-add" action="{{url('invoice.payment_type.add')}}" method="POST" style="display: none;">
									                	<input type="hidden" name="id" value="{{$invoice->id}}">
									                	<input type="hidden" name="total_amount" value="{{$invoice->id}}">
									                    @csrf
									                </form>
										</td>
									</tr>
								@endif	
							@else
					        <tr>   
				            	<td colspan="2">
									<a href="#" onclick="event.preventDefault();
									                document.getElementById('invoice-charge-add').submit();" class="btn btn-sm btn-outline-primary col-md-12 mb-1">Add Charges / Items</a>

									<form id="invoice-charge-add" action="{{url('invoice.create')}}" method="POST" style="display: none;">
					                	<input type="hidden" name="id" value="{{$invoice->id}}">
					                	<input type="hidden" name="transaction_type" value="{{$invoice->transaction_type}}">
					                	<input type="hidden" name="invoice_type" value="{{$invoice->invoice_type}}">
					                	<input type="hidden" name="client_id" value="{{$invoice->client_id}}">
					                    @csrf
					                </form>
								</td>
							</tr>
							@endif
			         
			            @endif

        			</tbody>
    			</table>

        	</div>
      	</div>
      </div>
    </div>

<!-- Payments -->
	<div class="col-xl-4 col-md-4 col-sm-12 col-xs-12 mb-4">
      <div class="card border-left-danger shadow h-100 py-2">
        <div class="card-body">
        	<label  class="col-md-12 control-label control-label-sm font-weight-bold text-primary text-uppercase mb-1">Payments</label>
        	<div class="table-hover table-responsive">
        		<table class="table">
        			<tbody>
        				<tr>
        				
	        				<th>Payment Type:</th>
	        				<td>{{$invoice->payment_type}}</td>
        				
	        			</tr>      		
			            @if($invoice->payment_count <> '')

				            @php 
							    $i = 0; 
							@endphp 
							@while (++$i <= $invoice->payment_count) 

							
					        	<tr>
					        	
					            	<th>Payment Type {{$i}}:</th>
					            
					            	<td>{{$invoice['payment_type'.$i]}}</td>
					            </tr>

					        	<tr>
					        	
					            	<th>Payment Amount {{$i}}:</th>
					            
					            	<td>{{$invoice['payment_amount'.$i]}}</td>
					            </tr>
				            @endwhile
			            @endif
            		</tbody>
            	</table>
            </div>

        </div>
      </div>
    </div>


@if($invoice->invoice_type <> 'ProForma')
	<!-- Transactions -->
		<div class="col-xl-6 col-md-6  col-sm-12 col-xs-12 mb-4">
	      <div class="card border-left-primary shadow h-100 py-2">
	        <div class="card-body">
	        	<label  class="col-md-12 control-label control-label-sm font-weight-bold text-primary text-uppercase mb-1">Transactions</label>
	        	@if(count($transactions)<> 0)
	        	<div class="table-hover table-bordered table-responsive">
	        	<table class="table">
	        		<thead class="bg-secondary text-white">
	        			<th>ID</th>
	        			<th>Brand</th>
	        			<th>Updated At</th>
	        			<th>Amount</th>
	        			<th></th>
	        		</thead>
	        		<tbody>
	        			@php $transaction_total = 0; @endphp
	        			@foreach($transactions as $transaction)
	        			<tr>
		        			<td>{{$transaction->id}}</td>
		        			<td>{{ConfigController::get_brand_name($transaction->brand_id)}}</td>
		        			<td>{{$transaction->updated_at}}</td>
		        			<td>$ {{$transaction->amount}} FJD</td>
		        			<td><a href="{{url('transaction.view')}}.{{$transaction->id}}" class="btn btn-sm btn-outline-info"><span class="fa fa-eye"></span></a></td>
		        			@php $transaction_total = $transaction_total + $transaction->amount; @endphp
		        		</tr>
	        			@endforeach
	        			<tr @if($transaction_total == 0) class="bg-success text-white" @else class="bg-success text-white" @endif>
	        				<td colspan="3"><b>Balance</b></td>
	        				<td><b>$ {{$transaction_total}} FJD</b></td>
	        				<td></td>
	        			</tr>
	        		</tbody>
	        	</table>
	        	</div>
	        	<hr>
	        	@else
	        	<div class="alert alert-info">No transactions found for this invoice</div>

	        	@endif
	        </div>
	      </div>
	    </div>
@else
	<!-- Invoices linked -->
		<div class="col-xl-6 col-md-6  col-sm-12 col-xs-12 mb-4">
	      <div class="card border-left-primary shadow h-100 py-2">
	        <div class="card-body">
	        	<label  class="col-md-12 control-label control-label-sm font-weight-bold text-primary text-uppercase mb-1">Invoices Linked</label>
	        	@if(count($invoice_linked)<> 0)
	        	<div class="table-hover table-bordered table-responsive">
	        	<table class="table">
	        		<thead class="bg-secondary text-white">
	        			<th>ID</th>
	        			<th>Invoice Type</th>
	        			<th>Transaction Type</th>
	        			<th>Updated At</th>
	        			<th>Amount</th>
	        			<th></th>
	        		</thead>
	        		<tbody>
	        			@php $transaction_total = 0; @endphp
	        			@foreach($invoice_linked as $transaction)
	        			<tr>
		        			<td>{{$transaction->uuid}}</td>
		        			<td>{{$transaction->invoice_type}}</td>
		        			<td>{{$transaction->transaction_type}}</td>
		        			<td>{{$transaction->updated_at}}</td>
		        			<td>$ {{$transaction->total_amount}} FJD</td>
		        			<td><a href="{{url('invoice.view')}}.{{$transaction->uuid}}" class="btn btn-sm btn-outline-info"><span class="fa fa-eye"></span></a></td>
		        			
		        		</tr>
	        			@endforeach

	        		</tbody>
	        	</table>
	        	</div>
	        	<hr>
	        	@else
	        	<div class="alert alert-info">No invoice found for this Proforma</div>

	        	@endif
	        </div>
	      </div>
	    </div>
@endif

	<!-- Taxs -->
		<div class="col-xl-6 col-md-6  col-sm-12 col-xs-12 mb-4">
	      <div class="card border-left-danger shadow h-100 py-2">
	        <div class="card-body">
	        	<label  class="col-md-12 control-label control-label-sm font-weight-bold text-primary text-uppercase mb-1">Taxs</label>
	        	@if(count($taxs)<> 0)
	        	<div class="table-hover table-bordered table-responsive">
	        	<table class="table">
	        		<thead class="bg-secondary text-white">
	        			<th>Label</th>
	        			<th>Name</th>
	        			<th>Updated At</th>
	        			<th>Rate</th>
	        			<th>Tax</th>
	        		</thead>
	        		<tbody>
	        			@php $tax_total = 0; @endphp
	        			@foreach($taxs as $tax)
	        			<tr>
		        			<td>{{$tax->label}}</td>
		        			<td>{{$tax->name}}</td>
		        			<td>{{$tax->updated_at}}</td>
		        			<td>{{$tax->rate}}</td>
		        			<td>$ {{$tax->tax}} FJD</td>
		        			@php $tax_total = $tax_total + $tax->tax; @endphp
		        		</tr>
	        			@endforeach
	        			<tr  class="bg-info text-white">
	        				<td colspan="4"><b>Total Tax</b></td>
	        				<td><b>$ {{$tax_total}} FJD</b></td>
	        			</tr>
	        		</tbody>
	        	</table>
	        	</div>
	        	<hr>
	        	@else
	        	<div class="alert alert-info">No tax found for this invoice</div>

	        	@endif
	        </div>
	      </div>
	    </div>
<!-- tax end -->



	<!-- Charges -->
		<div class="col-xl-6 col-md-6  col-sm-12 col-xs-12 mb-4">
	      <div class="card border-left-primary shadow h-100 py-2">
	        <div class="card-body">
	        	<label  class="col-md-12 control-label control-label-sm font-weight-bold text-primary text-uppercase mb-1">Charges / Items</label>
	        	@if(count($charges)<> 0)
	        	<div class="table-hover table-bordered table-responsive">
	        	<table class="table">
	        		<thead class="bg-secondary text-white">
	        			<th>Item</th>
	        			<th>Description</th>
	        			<th>Rate</th>
	        			<th>Quantity</th>
	        			<th>Price</th>
	        		</thead>
	        		<tbody>
	        			@php $total_charges= 0; @endphp
	        			@foreach($charges as $charge)
	        			<tr>
		        			<td>{{ConfigController::get_productName($charge->product_id)}} - {{ConfigController::get_product_labels($charge->product_id)}}</td>
		        			<td>{{$charge->description}}</td>
		        			<td>{{$charge->amount}} FJD</td>
		        			<td>{{$charge->quantity}}</td>
		        			<td>$ {{$charge->amount * $charge->quantity}} FJD</td>
		        			@php $total_charges= $total_charges+ $charge->amount; @endphp
		        		</tr>
	        			@endforeach
	        			<tr  class="bg-info text-white">
	        				<td colspan="4"><b>Total</b></td>
	        				<td><b>$ {{$total_charges}} FJD</b></td>
	        			</tr>
	        		</tbody>
	        	</table>
	        	</div>
	        	<hr>
	        	@else
	        	<div class="alert alert-info">No tax found for this invoice</div>

	        	@endif
	        </div>
	      </div>
	    </div>
<!-- Charges end -->

	<!-- Charges -->
		<div class="col-xl-6 col-md-6  col-sm-12 col-xs-12 mb-4">
	      <div class="card border-left-danger shadow h-100 py-2">
	        <div class="card-body">
	        	<label  class="col-md-12 control-label control-label-sm font-weight-bold text-primary text-uppercase mb-1">Emails</label>
	        	@if(count($emails)<> 0)
	        	<div class="table-hover table-bordered table-responsive">
	        	<table class="table">
	        		<thead class="bg-secondary text-white">
	        			<th>Created At</th>
	        			<th>Sent</th>
	        		</thead>
	        		<tbody>
	        			
	        			@foreach($emails as $email)
	        			<tr>
		        			<td>{{$email->created_at}}</td>
		        			<td>{{$email->sent}}</td>		        			
		        		</tr>
	        			@endforeach
	        		</tbody>
	        	</table>
	        	</div>
	        	<hr>
	        	@else
	        	<div class="alert alert-info">No emails sent</div>

	        	@endif
	        </div>
	      </div>
	    </div>
<!-- Charges end -->

</div>

 <!--DueDate Change -->
  <div class="modal fade" id="duedatechange_modal" role="dialog" tabindex="-1" >
    <div class="modal-dialog">
    
      <!-- Modal content-->
      <div class="modal-content">
        <div class="modal-header bg-danger text-white" id="modal-header">
          
          <h4 class="modal-title"><i class="fa fa-refresh"></i> Set Due Date</h4>
        </div>
        <div class="modal-body">
            <form class="form-horizontal" action="{{url('/invoice.duedate.change')}}.{{$invoice->uuid}}" method="post" id="duedate_form">
            <div class="alert" id="duedate_alert" style="display: none;">
                <span id="duedate_alert_message"></span>
            </div>

            {{ csrf_field() }}
                            
                <div class="form-group row" id="div-duedate">
                    <label for="duedate" class="offset-1 col-4 control-label">New Due Date</label>

                    <div class="col-6">
                        <input id="duedate" type="date" class="form-control" name="duedate" autocomplete="off" required value="{{$invoice->due_date}}" min="{{date('Y-m-d')}}">

                        <strong id="error_duedate"></strong>
                        
                    </div>
                </div>

                <div class="form-group row">
                    <div class="col-6 offset-4">
                        <button type="submit" class="btn btn-primary" id="submitChangePassword"><i id="btn-changeIcon" class="fa fa-refresh"></i> 
                            Set Due Date
                        </button>
                    </div>
                </div>

            </form>
        </div>
      </div>
    </div>
  </div> 


<script type="text/javascript">

$('#duedate_form').submit(function(e){
	e.preventDefault();
	var url, data;
	url = $(this).attr('action');
	data = $(this).serialize();
	$.ajax({
		type:'post',
		url:url,
		data:data,
		success:function(data)
		{
			if(data.success)
			{
				$('#due_date').html(data.due_date+ "<a style='margin-left:5px;' href='#' data-toggle='modal' data-target='#duedatechange_modal' class='btn btn-sm btn-outline-success'><i class='fa fa-edit'></i></a>");
				swal({
					type:'success',
					animation:true,
					text:'Due Date Changed'
				});

				$('#duedatechange_modal').modal('hide');
			}

			if(data.error)
			{
				swal({
					type:'error',
					animation:true,
					text:data.error
				});				
			}
		},
		error:function(data)
		{
		    var obj, errors;
  			obj = jQuery.parseJSON(data.responseText);
  			errors = obj.errors;

  			if(errors.duedate)
  			{
  				$('#duedate').addClass('is-invalid');
  				$('#error_duedate').addClass('invalid-feedback');
  				$('#error_duedate').html(errors.duedate);
  			}
		}
	});
})

	function loader(){
	Swal({
		title: 'Loading',
		allowEscapeKey:false,
		allowOutsideClick: false,
	});
	Swal.showLoading()
}

function stop_loader(){
	Swal.close();
}
</script>	            

@endsection