@extends('layouts.app')
@section('pageTitle', 'Search Invoice')
@section('content')
<?php use App\Http\Controllers\ConfigController; ?>

<div class="col-md-8 offset-md-2 col-sm-12" >


	<div class="card">
		<div class="card-header" id="card">Search Invoice</div>
		<div class="card-body">
			<form class="form-horizontal" method="POST" action="{{url('invoice.search')}}" id="form-submit">
				<div class="form-group row">
	                <label for="invoice_uuid" class="offset-md-2 col-md-3 control-label control-label-sm">Invoice ID</label>

	                <div class="col-md-5">
	                    <input id="invoice_id" type="text" class="form-control form-control-sm" name="invoice_id" placeholder="TR-SALE-9273 (Optional)">
	                    <strong id="error_invoice_uuid"></strong>
	                </div>
	            </div>

				<!-- Client ID -->
				@csrf
	            <div class="form-group row">
	                <label for="client_id" class="offset-md-2 col-md-3 control-label control-label-sm">Client</label>

	                <div class="col-md-5">
	                    <select id="client_id" type="text" class="form-control form-control-sm" name="client_id">
	                    		<option value="all">All</option>
	                    	@foreach($clients as $client)
	                    		<option value="{{$client->id}}">{{$client->business_name}}</option>
	                    	@endforeach
	                    </select>
	                    <strong id="error_client_id"></strong>
	                </div>
	            </div>

				<!-- Transaction Type -->
	            <div class="form-group row">
	                <label for="transaction_type" class="offset-md-2 col-md-3 control-label control-label-sm">Transaction Type</label>

	                <div class="col-md-5">
	                	<select id="transaction_type" type="text" class="form-control form-control-sm" name="transaction_type">
	                			<option value=""></option>
	                    		<option value="Sale">Sale</option>
	                    		<option value="Refund">Refund</option>
	                    </select>
	                    <strong id="error_transaction_type"></strong>
	                </div>
	            </div>


				<!-- Invoice Type -->
	            <div class="form-group row">
	                <label for="invoice_type" class="offset-md-2 col-md-3 control-label control-label-sm">Invoice Type</label>

	                <div class="col-md-5">
	                	<select id="invoice_type" type="text" class="form-control form-control-sm" name="invoice_type">
	                			<option value=""></option>
	                    		<option value="Normal">Normal</option>
	                    		<option value="Training">Training</option>
	                    		<option value="ProForma">ProForma</option>
	                    		<option value="Copy">Copy</option>
	                    </select>
	                    <strong id="error_invoice_type"></strong>
	                </div>
	            </div>


				<!-- Start Date -->
	            <div class="form-group row">
	                <label for="start_date" class="offset-md-2 col-md-3 control-label control-label-sm">Start Date</label>

	                <div class="col-md-5">
	                	<input id="start_date" type="date" class="form-control form-control-sm" name="start_date" value="{{$start_date}}">
	                    <strong id="error_start_date"></strong>
	                </div>
	            </div>

				<!-- End Date -->
	            <div class="form-group row">
	                <label for="end_date" class="offset-md-2 col-md-3 control-label control-label-sm">End Date</label>

	                <div class="col-md-5">
	                	<input id="end_date" type="date" class="form-control form-control-sm" name="end_date" value="{{$end_date}}">
	                    <strong id="error_end_date"></strong>
	                </div>
	            </div>

				<!-- Invoice Type -->
	            <div class="form-group row">
	                <label for="frcs_status" class="offset-md-2 col-md-3 control-label control-label-sm">FRCS Status</label>

	                <div class="col-md-5">
	                	<select id="frcs_verified" type="text" class="form-control form-control-sm" name="frcs_verified">
	                    		<option value="all">All</option>
	                    		<option value="0">Not Verified</option>
	                    		<option value="x">Hold</option>
	                    		<option value="1">Verified</option>
	                    </select>
	                    <strong id="error_frcs_verified"></strong>
	                </div>
	            </div>

				<!-- Invoice Submit -->
	            <div class="form-group row">
	                <div class="col-md-2 offset-md-8">
	                	<button type="submit" class="btn btn-primary col-12 btn-sm">Search</button>
	                </div>
	            </div>
	            
			</form>
		</div>
	</div>

	<div class="progress" style="height: 1px;">
			  <div class="progress-bar progress-bar-striped progress-bar-animated" role="progressbar" id="progress" style="width:0%; " aria-valuemin="0" aria-valuemax="100"></div>
	</div>

	<div id="data">
		
	</div>

<script type="text/javascript">
	$('#form-submit').submit(function(e){
		e.preventDefault();
		var formData,url;
		url = $(this).attr('action');
		formData = $(this).serialize();

		$.ajax({
			type: 'POST',
			url:url,
			data:formData,
			beforeSend:function()
			{
				document.getElementById('progress').style.width = '75%';
				$('#client_id').removeClass('is-invalid');
  				$('#error_client_id').removeClass('invalid-feedback');
				$('#error_client_id').html('');
				$('#transaction_type').removeClass('is-invalid');
				$('#error_transaction_type').removeClass('invalid-feedback');
				$('#error_transaction_type').html('');
				$('#invoice_type').removeClass('is-invalid');
				$('#error_invoice_type').removeClass('invalid-feedback');
				$('#error_invoice_type').html('');
				$('#start_date').removeClass('is-invalid');
				$('#error_start_date').removeClass('invalid-feedback');
				$('#error_start_date').html('');
				$('#end_date').removeClass('is-invalid');
				$('#error_end_date').removeClass('invalid-feedback');
				$('#error_end_date').html('');				
			},
			success:function(data){

				if(data.html)
				{
					document.getElementById('progress').style.width = '100%';

					$('#data').html(data.html);
				}

				if(data.error)
				{
					swal({
						  	type: 'error',
						  	title: 'Oops...',
						  	text: data.error,
						  	animation: true
					});
				}

				if(data.unauthorized_access)
				{
					swal({
						  	type: 'error',
						  	title: 'Oops...',
						  	text: data.unauthorized_access,
						  	animation: true
					});
				}
			},
			error:function(data){


				@if(ConfigController::check_privilege('ACCESS_JAVASCRIPT_LOGS'))
                	console.log(data.responseText);
                @endif      

				var obj = jQuery.parseJSON(data.responseText);
				var errors = obj.errors;

				swal({
					  	type: 'error',
					  	title: 'Oops...',
					  	text: obj.message,
					  	animation: true
				});
				
				if(errors.client_id){
					$('#client_id').addClass('is-invalid');
      				$('#error_client_id').addClass('invalid-feedback');
					$('#error_client_id').html(errors.client_id);
				}

				if(errors.transaction_type){
					$('#transaction_type').addClass('is-invalid');;
					$('#error_transaction_type').addClass('invalid-feedback');
					$('#error_transaction_type').html(errors.transaction_type);
				}

				if(errors.invoice_type){
					$('#invoice_type').addClass('is-invalid');
					$('#error_invoice_type').addClass('invalid-feedback');
					$('#error_invoice_type').html(errors.invoice_type);
				}

				if(errors.start_date){
					$('#start_date').addClass('is-invalid');
					$('#error_start_date').addClass('invalid-feedback');
					$('#error_start_date').html(errors.start_date);
				}

				if(errors.end_date){
					$('#end_date').addClass('is-invalid');
					$('#error_end_date').addClass('invalid-feedback');
					$('#error_end_date').html(errors.end_date);
				}

			}
		});
	});



	
</script>

</div>



@endsection