@extends('layouts.app')
@section('pageTitle', 'Raise Invoice')
@section('content')

<div class="col-md-8 offset-md-2 col-sm-12" >
	<div class="progress" style="height: 5px;">
			  <div class="progress-bar progress-bar-striped progress-bar-animated" role="progressbar" id="progress" style="width:{{$progress}}%; " aria-valuemin="0" aria-valuemax="100"></div>
	</div>

	<div class="card" id="invoice-content">
		<div class="card-header" id="card">Raise Invoice</div>
		<div class="card-body">
			<form class="form-horizontal" method="POST" action="{{url('invoice.create')}}" id="form-submit">
				<!-- Client ID -->
				@csrf
	            <div class="form-group row">
	                <label for="client_id" class="offset-md-2 col-md-3 control-label control-label-sm">Client</label>

	                <div class="col-md-5">
	                    <select id="client_id" type="text" class="form-control form-control-sm" name="client_id">
	                    	@foreach($clients as $client)
	                    		<option value="{{$client->id}}">{{$client->business_name}}</option>
	                    	@endforeach
	                    </select>
	                    <strong id="error_client_id"></strong>
	                </div>
	            </div>

				<!-- Transaction Type -->
	            <div class="form-group row">
	                <label for="transaction_type" class="offset-md-2 col-md-3 control-label control-label-sm">Transaction Type</label>

	                <div class="col-md-5">
	                	<select id="transaction_type" type="text" class="form-control form-control-sm" name="transaction_type">
	                			<option value=""></option>
	                    		<option value="Sale">Sale</option>
	                    </select>
	                    <strong id="error_transaction_type"></strong>
	                </div>
	            </div>


				<!-- Invoice Type -->
	            <div class="form-group row">
	                <label for="invoice_type" class="offset-md-2 col-md-3 control-label control-label-sm">Invoice Type</label>

	                <div class="col-md-5">
	                	<select id="invoice_type" type="text" class="form-control form-control-sm" name="invoice_type">
	                			<option value=""></option>
	                    		<option value="Normal">Normal</option>
	                    		<option value="Training">Training</option>
	                    		<option value="ProForma">ProForma</option>
	                    </select>
	                    <strong id="error_invoice_type"></strong>
	                </div>
	            </div>

				<!-- Invoice Type -->
	            <div class="form-group row">
	                <div class="col-md-2 offset-md-8">
	                	<button type="submit" class="btn btn-primary col-12 btn-sm">Next</button>
	                </div>
	            </div>
	            
			</form>
		</div>
	</div>

<script type="text/javascript">
	$('#form-submit').submit(function(e){
		e.preventDefault();

		var formData,url;
		url = $(this).attr('action');
		formData = $(this).serialize();

		$.ajax({
			type: 'POST',
			url:url,
			data:formData,
			success:function(data){

				if(data.html)
				{
					document.getElementById('progress').style.width = data.progress+'%';

					$('#invoice-content').html(data.html);
				}

				if(data.error)
				{
					swal({
						  	type: 'error',
						  	title: 'Oops...',
						  	text: data.error,
						  	animation: true
					});
				}

				if(data.unauthorized_access)
				{
					swal({
						  	type: 'error',
						  	title: 'Oops...',
						  	text: data.unauthorized_access,
						  	animation: true
					});
				}
			},
			error:function(data){

				swal({
					  	type: 'error',
					  	title: 'Oops...',
					  	text: 'Something went wrong. All feilds are required.',
					  	animation: true
				});
			}
		});
	});



	
</script>

</div>



@endsection