<!doctype html>
<html>
  <head>
    <meta charset="utf-8">
    <title>Invoice</title>
<?php use App\Http\Controllers\ConfigController; ?>
<style type="text/css">
      /* reset */

/* CSS-only ribbon styles    */

  .cnrflash
  {
      /*Position correctly within container*/
      position: absolute;
      z-index: 1; /*Set overflow to hidden, to mask inner square*/
      overflow: hidden; /*Set size and add subtle rounding      to soften edges*/
      width: 100px;
      height: 100px;
      padding-top: 100px;
      border-radius: 3px 5px 3px 0;
  }

  #status{
    display: none;
  }

  header h1 {border-radius: 0.25em; color: #FFF; margin: 0 0 1em; padding: 0.5em 0;}
  .unpaid{
    background-color: red;
  }
  .paid{background-color: green;}



.cnrflash-inner-unpaid
{
    /*Set position, make larger then      container and rotate 45 degrees*/
    position: absolute;
    bottom: 0;
    right: 0;
    width: 145px;
    height: 145px;
    -ms-transform: rotate(45deg); /* IE 9 */
    -o-transform: rotate(45deg); /* Opera */
    -moz-transform: rotate(45deg); /* Firefox */
    -webkit-transform: rotate(45deg); /* Safari and Chrome */
    -webkit-transform-origin: 100% 100%; /*Purely decorative effects to add texture and stuff*/ /* Safari and Chrome */
    -ms-transform-origin: 100% 100%;  /* IE 9 */
    -o-transform-origin: 100% 100%; /* Opera */
    -moz-transform-origin: 100% 100%; /* Firefox */
    background-image: linear-gradient(90deg, transparent 50%, rgba(255,255,255,.1) 50%), linear-gradient(0deg, transparent 0%, rgba(1,1,1,.2) 50%);
    background-size: 4px,auto, auto,auto;
    background-color: #aa0101;
    box-shadow: 0 3px 3px 0 rgba(1,1,1,.5), 0 1px 0 0 rgba(1,1,1,.5), inset 0 -1px 8px 0 rgba(255,255,255,.3), inset 0 -1px 0 0 rgba(255,255,255,.2);
}

.cnrflash-inner-paid
{
    /*Set position, make larger then      container and rotate 45 degrees*/
    position: absolute;
    bottom: 0;
    right: 0;
    width: 145px;
    height: 145px;
    -ms-transform: rotate(45deg); /* IE 9 */
    -o-transform: rotate(45deg); /* Opera */
    -moz-transform: rotate(45deg); /* Firefox */
    -webkit-transform: rotate(45deg); /* Safari and Chrome */
    -webkit-transform-origin: 100% 100%; /*Purely decorative effects to add texture and stuff*/ /* Safari and Chrome */
    -ms-transform-origin: 100% 100%;  /* IE 9 */
    -o-transform-origin: 100% 100%; /* Opera */
    -moz-transform-origin: 100% 100%; /* Firefox */
    background-image: linear-gradient(90deg, transparent 50%, rgba(255,255,255,.1) 50%), linear-gradient(0deg, transparent 0%, rgba(1,1,1,.2) 50%);
    background-size: 4px,auto, auto,auto;
    background-color: #01aa25;
    box-shadow: 0 3px 3px 0 rgba(1,1,1,.5), 0 1px 0 0 rgba(1,1,1,.5), inset 0 -1px 8px 0 rgba(255,255,255,.3), inset 0 -1px 0 0 rgba(255,255,255,.2);
}
.cnrflash-inner:before, .cnrflash-inner:after
{
    /*Use the border triangle trick to make         it look like the ribbon wraps round it's        container*/
    content: " ";
    display: block;
    position: absolute;
    bottom: -16px;
    width: 0;
    height: 0;
    border: 8px solid #800000;
}
.cnrflash-inner:before
{
    left: 1px;
    border-bottom-color: transparent;
    border-right-color: transparent;
}
.cnrflash-inner:after
{
    right: 0;
    border-bottom-color: transparent;
    border-left-color: transparent;
}
.cnrflash-label
{
    /*Make the label look nice*/
    position: absolute;
    bottom: 0;
    left: 0;
    display: block;
    width: 100%;
    padding-bottom: 5px;
    color: #fff;
    text-shadow: 0 1px 1px rgba(1,1,1,.8);
    font-size: 0.95em;
    font-weight: bold;
    text-align: center;
}

      /* content editable */

      *[contenteditable] { border-radius: 0.25em; min-width: 1em; outline: 0;  cursor: pointer; display: inline-block;}

      *[contenteditable]:hover, *[contenteditable]:focus, td:hover *[contenteditable], td:focus *[contenteditable], img.hover { background: #DEF; box-shadow: 0 0 1em 0.5em #DEF; }

      /*span[contenteditable] { display: inline-block; }*/

      /* heading */

      h1 { font: bold 100% Ubuntu, Arial, sans-serif; text-align: center; text-transform: uppercase;  }

      /* table */

      table { font-size: 75%; table-layout: fixed; width: 100%; }
      table { border-collapse: separate; border-spacing: 2px; }
      th, td { border-width: 1px; padding: 0.5em; position: relative; text-align: left; }
      th, td { border-radius: 0.25em; border-style: solid; }
      th { background: #EEE; border-color: #BBB; }
      td { border-color: #DDD; }

      /* page */

      html { font: 16px/1 'Open Sans', sans-serif; overflow: auto; }
      html { background: #efefef; cursor: default; }

      body { box-sizing: border-box; margin:0;}
      #wrapper{
        background-color:#bbbbbb0a; 

        margin: 15px auto;
        padding: 50px;
        max-width: 850px;
        background-color: #fff;
        border: 1px solid #ccc;
        -moz-border-radius: 6px;
        -webkit-border-radius: 6px;
        -o-border-radius: 6px;
        border-radius: 6px;

      }
      

      /* header */

      header { margin: 0 0 3em; }
      header:after { clear: both; content: ""; display: table; }

      
      header address { float: left; font-size: 75%; font-style: normal; line-height: 1.25; margin: 0 1em 1em 0; }
      header address p { margin: 0 0 0.25em; }
      header span, header img { display: block; float: right; }
      header span { margin: 0 0 1em 1em; max-height: 25%; max-width: 60%; position: relative; }
      header img { max-height: 100%; max-width: 50%;  padding-right: 90px;}
      header input { cursor: pointer; -ms-filter:"progid:DXImageTransform.Microsoft.Alpha(Opacity=0)"; height: 100%; left: 0; opacity: 0; position: absolute; top: 0; width: 100%; }

      /* article */

      article, article address, table.meta, table.inventory { margin: 0 0 3em; }
      article:after { clear: both; content: ""; display: table; }
      article h1 { clip: rect(0 0 0 0); position: absolute; }

      article address { float: left;font-size: 75%; font-style: normal; line-height: 1.25;}

      /* table meta & balance */

      table.meta, table.balance { float: right; width: 36%; }
      table.meta:after, table.balance:after { clear: both; content: ""; display: table; }

      /* table meta */

      table.meta th { width: 40%; }
      table.meta td { width: 60%; }

      /* table items */

      table.inventory { clear: both; width: 100%; }
      table.inventory th { font-weight: bold; text-align: center; }

      table.inventory td:nth-child(1) { width: 26%; }
      table.inventory td:nth-child(2) { width: 38%; }
      table.inventory td:nth-child(3) { text-align: right; width: 12%; }
      table.inventory td:nth-child(4) { text-align: right; width: 12%; }
      table.inventory td:nth-child(5) { text-align: right; width: 12%; }

      /* table balance */

      table.balance th, table.balance td { width: 50%; }
      table.balance td { text-align: right; }

      /* aside */
    </style>
  </head>
  <body>
    <div id="wrapper">
      @if($data['status'] == 'u')
        <div class="cnrflash">
          <div class="cnrflash-inner-unpaid">
              <span class="cnrflash-label">UNPAID</span>
          </div>
        </div>
      @endif

      <header>
      @if($data['status'] == 'u')
        <h1 class="unpaid">Invoice<i id="status"> - UNPAID</i></h1>
      @endif
      @if($data['status'] == 'pp')
        <h1 class="paid">Invoice<i id="status"> - Partially Paids</i></h1>
      @endif

      @if($data['status'] == 'p')
        <h1 class="paid">Invoice<i id="status"> - PAID</i></h1>
      @endif
        <address >
          <p>{{config('app.name')}}</p>
          <p>Email: {{config('app.email')}}</p>
          <p>TIN: {{config('app.tin_number')}}</p>
          <p>Mobile: {{config('app.mobile')}}</p>
        </address>
        <span><img alt="" src="{{url('img/Cloud-Dev-Logo.png')}}"></span>
      </header>
      <article>
        <address >
          <p>To,</p>
          <p>{{$data['business_name']}}<br>
          {{$data['name']}}<br>
          {{$data['phone_contact']}}<br>
          {{$data['email']}}<br>
          {{$data['address']}}<br>
          </p>
        </address>
        <table class="meta">
          <tr>
            <th><span >Invoice #</span></th>
            <td><span >{{$data['invoice_number']}}</span></td>
            
          </tr>
          <tr>
            <th><span >Date</span></th>
            <td><span >{{$data['created_at']}}</span></td>
            
          </tr>
          @if($data['status'] == 'u')
            <tr>
              <th><span >Due Date</span></th>
              <td><span >{{$data['due_date']}}</span></td>
            </tr>
            <tr>
              <th><span >Amount Due</span></th>
              <td><span id="prefix" >$</span><span>{{$data['total_amount']. ' (VEP)'}}</span></td>
            </tr>
            <tr>
              <th><span >Status</span></th>
              <td><span>Unpaid</span></td>
            </tr>
          @endif

          @if($data['status'] == 'p')
            <tr>
              <th><span >Payment Date</span></th>
              <td><span >{{$data['payment_date']}}</span></td>
            </tr>
            <tr>
              <th><span >Amount Paid</span></th>
              <td><span id="prefix" >$</span><span>{{$data['amount_paid']. ' (VEP)'}}</span></td>
            </tr>
            <tr>
              <th><span >Status</span></th>
              <td><span>Paid</span></td>
            </tr>
          @endif
        </table>
        <table class="inventory">
          <thead>
            <tr>
              <th><span >Item</span></th>
              <th><span >Description</span></th>
              <th><span >Rate</span></th>
              <th><span >Quantity</span></th>
              <th><span >Price</span></th>
            </tr>
          </thead>
          <tbody>
          @foreach($data['charges'] as $charge)
            <tr>
              <td><span >{{ConfigController::get_productName($charge->product_id)}}</span></td>
              <td><span ></span></td>
              <td><span data-prefix>$</span><span >{{$charge->amount}}</span></td>
              <td><span >{{$charge->quantity}}</span></td>
              <td><span data-prefix>$</span><span>{{$charge->amount * $charge->quantity}}</span></td>
            </tr>
          @endforeach
          </tbody>
        </table>
        <table class="balance">
          <tr>
            <th><span >Total</span></th>
            <td><span data-prefix>$</span><span>{{$data['total_amount']}}</span></td>
          </tr>
          <tr>
            <th><span >Amount Paid</span></th>
            <td><span data-prefix>$</span><span >@if($data['status']=='u') 0.00 @endif @if($data['status']=='p') {{$data['total_amount']}} @endif</span></td>
          </tr>
          <tr>
            <th><span >Balance Due</span></th>
            <td><span data-prefix>$</span><span>@if($data['status']=='p') 0.00 @endif @if($data['status']=='u') {{$data['total_amount']}} @endif</span></td>
          </tr>
        </table>
      </article>
    </div>
  </body>
</html>
