<?php use App\Http\Controllers\ConfigController; ?>  

    <div class="card-header" id="card">Payment Type</div>
    <div class="card-body">				
      <form method="post" action="{{url('invoice.payment')}}.{{$uuid}}" id="form-process-invoice">
        <!-- Payment Type -->
        <div class="form-group row">
            <label for="status" class="offset-md-2 col-md-3 control-label control-label-sm">Status</label>
            @csrf
            <div class="col-md-5">
                <select id="status" type="text" class="form-control form-control-sm" name="status">
                      <option value=""></option>
                      <option value="u">Unpaid</option>
                      <option value="pp">Partial Payment</option>
                      <option value="p">Full Payment</option>
                </select>
                <strong id="error_payment_type"></strong>
            </div>
        </div>
        <input type="hidden" name="id" value="{{$id}}">

        <div class="form-group row">
            <label for="total_amount" class="offset-md-2 col-md-3 control-label control-label-sm">Total Amount</label>

            <div class="col-md-5">
                <label for="total_amount" class="control-label control-label-sm">{{$total_amount}}</label>
            </div>
        </div>


        <div class="form-group row" >
            <label for="amount_paid" class="offset-md-2 col-md-3 control-label control-label-sm">Amount Paid</label>
            
            <div class="col-md-5">
                <input type="number" name="amount_paid" id="amount_paid" class="form-control form-control-sm" max="{{$total_amount}}">
                <strong id="error_amount_paid"></strong>
            </div>
        </div>

        <div class="form-group row" id="div-due_date" style="display: none;">
            <label for="due_date" class="offset-md-2 col-md-3 control-label control-label-sm">Due Date</label>
            
            <div class="col-md-5">
                <input type="date" name="due_date" id="due_date" class="form-control form-control-sm" min="{{date('Y-m-d')}}" value="{{date('Y-m-d')}}">
                <strong id="error_due_date"></strong>
            </div>
        </div>

  <!-- Payment Type -->
        <div class="form-group row">
            <label for="payment_type" class="offset-md-2 col-md-3 control-label control-label-sm">Payment Type</label>

            <div class="col-md-5">
            	<select id="payment_type" type="text" class="form-control form-control-sm" name="payment_type">
                      <option value=""></option>
                      <option value="Cash">Cash</option>
                      <option value="Other">Other</option>
                      <option value="Card">Card</option>
                      <option value="Check">Cheque</option>
                      <option value="WireTransfer">Wire Transfer</option>
                      <option value="Voucher">Voucher</option>
                      <option value="MobileMoney">Mobile Money</option>
                      <option value="SplitPayment">Split Payment</option>
                </select>
                <strong id="error_payment_type"></strong>
            </div>
        </div>


        <div class="form-group row" id="div-count" style="display: none;">
          <label for="count" class="offset-md-2 col-md-3 control-label control-label-sm">Count</label>
           <div class="col-md-5">
            <select name="count" class="form-control form-control-sm" id="count">
                  <option value=""></option>
                  <option value="2">2</option>
                  <option value="3">3</option>
            </select>
          </div>
        </div>  

<!-- Payment 1 -->
        <div class="form-group row" id="div-payment_type1" style=" display: none;">
          <label for="payment_type1" class="offset-md-2 col-md-3 control-label control-label-sm">Payment Type 1</label>

          <div class="col-md-3">
            <select name="payment_type1" class="form-control form-control-sm" id="payment_type1">
                  <option value=""></option>
                  <option value="Cash">Cash</option>
                  <option value="Other" >Other</option>
                  <option value="Card">Card</option>
                  <option value="Check">Cheque</option>
                  <option value="WireTransfer">Wire Transfer</option>
                  <option value="Voucher">Voucher</option>
                  <option value="MobileMoney">Mobile Money</option>
            </select>
          </div>

          <div class="col-md-2" id="div-payment_total1">
              <input type="text" name="payment_total1" id="payment_total1" class="form-control form-control-sm" placeholder="$$">
          </div>

        </div>   

<!-- Payment 2 -->
        <div class="form-group row" id="div-payment_type2" style="display: none;">
          <label for="payment_type2" class="offset-md-2 col-md-3 control-label control-label-sm">Payment Type 2</label>

          <div class="col-md-3">
            <select name="payment_type2" class="form-control form-control-sm" id="payment_type2">
                  <option value=""></option>
                  <option value="Cash">Cash</option>
                  <option value="Other" >Other</option>
                  <option value="Card">Card</option>
                  <option value="Check">Cheque</option>
                  <option value="WireTransfer">Wire Transfer</option>
                  <option value="Voucher">Voucher</option>
                  <option value="MobileMoney">Mobile Money</option>
            </select>
          </div>

          <div class="col-md-2" id="div-payment_total2">
              <input type="text" name="payment_total2" id="payment_total2" class="form-control form-control-sm" placeholder="$$">
          </div>

        </div>   


          <!-- Payment 3 -->
        <div class="form-group row" id="div-payment_type3" style="display: none;">
          <label for="payment_type3" class="offset-md-2 col-md-3 control-label control-label-sm">Payment Type 3</label>

          <div class="col-md-4">
            <select name="payment_type3" class="form-control form-control-sm" id="payment_type3">
                  <option value=""></option>
                  <option value="Cash">Cash</option>
                  <option value="Other" >Other</option>
                  <option value="Card">Card</option>
                  <option value="Check">Cheque</option>
                  <option value="WireTransfer">Wire Transfer</option>
                  <option value="Voucher">Voucher</option>
                  <option value="MobileMoney">Mobile Money</option>
            </select>
          </div>
          <div class="col-md-2" id="div-payment_total3">
              <input type="text" name="payment_total3" id="payment_total3" class="form-control" placeholder="$$">
          </div>

        </div>   

        <div class="col-sm-12 offset-5 col-md-5">
            <input type="checkbox" name="sendemail" style="margin-top:15px;" checked /> <label for"sendemail">Send Email</label>
        
        </div>



        <div class="form-group row">
          <div class="col-md-2 offset-md-8">
            <button type="submit" class="btn btn-primary col-12 btn-sm">Process Invoice</button>
          </div>
        </div>
      </form>
    </div>

<script type="text/javascript">

    $('#status').on('change',function(){
      var status = $('#status').val();
          
          if(status == 'pp'){
            $('#amount_paid').prop("readonly", false); 
            $('#amount_paid').attr("value","0");
            $('#div-due_date').fadeIn('slow');

          }

          if(status == 'u'){
            $('#amount_paid').attr("readonly","readonly");
            $('#amount_paid').attr("value","0");
            $('#div-due_date').fadeIn('slow');
          }

          if(status == 'p'){
            $('#amount_paid').attr("readonly","readonly");
            $('#amount_paid').attr("value","{{$total_amount}}");
            $('#div-due_date').fadeOut('slow');
          }
    });

    $('#payment_type').on('change',function(){
      var payment_type = $('#payment_type').val();

      if(payment_type == 'SplitPayment'){
        $('#div-count').fadeIn('slow');

      }
      else
      {
          $('#div-count').fadeOut('slow');
          $('#div-payment_type1').fadeOut('slow');
          $('#div-payment_type2').fadeOut('slow');
          $('#div-payment_type3').fadeOut('slow');
      }


      $('#count').on('change',function(){
        var count = $('#count').val();


        if(count == '2')
        {
          $('#div-payment_type1').fadeIn('slow');
          $('#div-payment_type2').fadeIn('slow');
        }

        if(count == '3')
        {
          $('#div-payment_type1').fadeIn('slow');
          $('#div-payment_type2').fadeIn('slow');
          $('#div-payment_type3').fadeIn('slow');
        }
        if(count == '')
        {
          $('#div-payment_type1').fadeOut('slow');
          $('#div-payment_type2').fadeOut('slow');
          $('#div-payment_type3').fadeOut('slow');
        }

      });

      $('#payment_type1').on('change',function(){

          var value = $(this).val();
          if (value === '') return;

          var option = $("option[value='" + value + "']", '#payment_type2');
          option.attr("disabled","disabled");

          var option = $("option[value='" + value + "']", '#payment_type3');
          option.attr("disabled","disabled");
      });

      $('#payment_type2').on('change',function(){

          var value = $(this).val();
          if (value === '') return;

          var option = $("option[value='" + value + "']", '#payment_type1');
          option.attr("disabled","disabled");

          var option = $("option[value='" + value + "']", '#payment_type3');
          option.attr("disabled","disabled");
      });

      $('#payment_type3').on('change',function(){

          var value = $(this).val();
          if (value === '') return;

          var option = $("option[value='" + value + "']", '#payment_type1');
          option.attr("disabled","disabled");

          var option = $("option[value='" + value + "']", '#payment_type2');
          option.attr("disabled","disabled");
      });

  });




    $('#form-process-invoice').submit(function(e){
      e.preventDefault();

      var data = $(this).serialize();
      var url = $(this).attr('action');
          $.ajax({
            url: url,
            type:"POST",
            data:data,
            success:function(data){
              
              if(data.url)
              {
                window.location.href = data.url;
              }
      
              if(data.unauthorized_access)
              {
                swal({
                      type: 'error',
                      title: 'Oops...',
                      text: data.unauthorized_access,
                      animation: true
                });
              }
      
      
            },
            error:function(data){
              
              var obj = jQuery.parseJSON(data.responseText) ;
                var errors = obj.errors;
      
              if(obj.message)
              {
                swal({
                    type: 'error',
                    title: 'Error!!!',
                    text: obj.message,
                    animation: true
                });
              }
      
            }
          });
    });




</script>