<?php use App\Http\Controllers\ConfigController; ?>	   
<div id="tax-content"></div>

<script type="text/javascript">




       // Tax Sign Starts Here
        document.getElementById("invoiceRequest").innerHTML =
        JSON.stringify(CreateExampleInvoiceRequest(), undefined, 4);
        document.getElementById("taxcore_sign_element").dataset.taxcoreInvoiceRequest =
        JSON.stringify(CreateExampleInvoiceRequest());

      // Listen to messages from TaxCore
      window.onmessage = function (e) 
      {
       
          console.log(e.data);

          var obj = jQuery.parseJSON(e.data);

          //If returns message from Firca then process the payment
        if(obj.status_code == '200'){
            var tax = obj.response;
            var tax_amount,i,x = "";
            
            tax_amount = tax.TaxItems;

              $.ajax({
                type:'post',
                url:"{{url('invoice.frcs.close')}}",
                data:{
                          '_token': $('input[name=_token]').val(),
                          'uuid': "{{$uuid}}",
                          'tax_amount':tax_amount,
                          'url': tax.VerificationUrl,
                          'tax_invoice_number': tax.IN,
                          'invoice_counter': tax.IC,
                          'sdc_time': tax.DT,
                          'payment_type': "{{$payment_type}}"
                      },
                      success:function(data)
                      {
                        @if(ConfigController::check_privilege('ACCESS_JAVASCRIPT_LOGS'))
                          console.log(data);
                        @endif  
                        $('#loader-wrapper').fadeOut('slow');

                        if(data.url)
                        {
                          $('#swal2-title').html('Redirecting ... ');
                          stop_loader();
                          window.location.href = data.url;       
                        } 

                        if(data.error)
                        {
                          swal({
                            type: 'error',
                            title: 'Error',
                            text: data.error,
                            animation: true
                          });
                        }   
                                                                   
                      },
                      error:function(data)
                      {
                        @if(ConfigController::check_privilege('ACCESS_JAVASCRIPT_LOGS'))
                          console.log(data.responseText);
                        @endif  

                      }

              });
          }
          else //Else Get error 
          {
            var tax = obj.response;


            swal({
                type: 'error',
                title: 'Oops...',
                text: tax.Message,
                animation: false,
                customClass: 'animated tada'
            });
          }
      }




    function CreateExampleInvoiceRequest() 
    {
        
        var invoiceRequest = {
            "DateAndTimeOfIssue": "{{date('c')}}",
            "Cashier": "{{Auth::user()->tin_number}}",
            "BD": "{{$b2b}}",//Buyers TIN
            "BuyerCostCenterId": null,//Optional
            "IT": "{{$type}}",
            "TT": "{{$transaction_type}}",
            "PaymentType": "{{$payment_type}}",
            "InvoiceNumber":  "{{$uuid}}",
            "ReferentDocumentNumber": "{{$ref}}",
            "PAC": "{{Auth::user()->pac}}",
            "Options": 
            {
            "OmitTextualRepresentation": 0,
            "OmitQRCodeGen": 0
            },
            "Items": 
            [
              {{ConfigController::items_breakdown_json($invoice_id,$total_amount)}}
            ],//Item ends
            
      	};
      	return invoiceRequest;
    }



</script>