@extends('layouts.app')
@section('pageTitle', 'Clients')
@section('content')

<?php use App\Http\Controllers\ConfigController; ?>
	<div class="container">
	
		<div class="card">
			<div class="card-header">{{ucwords($status)}} Invoices</div>
			<div class="card-body" id="invoices-data">

				@if(count($invoices) > 0)
					<div class="table table-striped table-inverse table-hover table-bordered table-sm table-responsive">
					<table class="table table-striped table-inverse table-hover table-bordered table-sm" style="font-size: 12px;">

						<thead class="thead-dark">
							<tr>
								<th>ID</th>
								<th>Business Name</th>
								<th>Invoice Type</th>
								<th>Transaction Type</th>
								@if($status <> 'ProForma')
									<th>Status</th>
									<th>Balance</th> 
								@endif
								<th>Total Amount</th>
								<th></th>
								<th></th>
							</tr>
						</thead>
						<tbody>
							@foreach($invoices as $invoice)
							<tr @if($invoice->deleted_at <> '') class="bg-danger text-white" @endif  @if($invoice->frcs_verified =='x') class="bg-warning text-white" title="Invoice on DOUBT status. Please check on VMS if this invoice has been created." @endif >
								<td>{{$invoice->uuid}}</td>
								<td>{{ConfigController::get_clientname($invoice->client_id)}}</td>
								<td>{{ucfirst($invoice->invoice_type)}}</td>
								<td>{{ucfirst($invoice->transaction_type)}}</td>
								
								@if($status <> 'ProForma')
									<td>{{ConfigController::print_invoice_status($invoice->status)}}</td>
									<td>{{ConfigController::get_invoice_balance($invoice->id)}}</td>
								@endif
								<td>{{$invoice->total_amount}}</td>
								<td><a href="{{url('invoice.view')}}.{{$invoice->uuid}}" class="btn btn-sm btn-info"><i class="fa fa-eye"></i></a></td>
								@if($invoice->frcs_verified == '1')
								<td><a href="{{url('invoice.pdf.view')}}.{{$invoice->uuid}}" class="btn btn-sm btn-danger"><i class="fas fa-file-pdf"></i></a></td>
								@else
								<td>
									@if(ConfigController::check_privilege('ACCESS_UNLOCK_INVOICE'))
										<a href="{{url('invoice.unlock')}}.{{$invoice->uuid}}" class="btn btn-sm btn-warning"><i class="fas fa-unlock"></i>
										</a>
									@endif
								</td>
								@endif

							</tr>
							@endforeach
						</tbody>
					</table>
					</div>
					{{ $invoices->links() }}
				@else
					<div class="alert alert-warning text-center">No Records Found</div>
				@endif


			</div>
			
		</div>
	
	</div>

@endsection