
<!doctype html>
<html>
  <head>
    <link href="{{url('startbootstrap/vendor/fontawesome-free/css/all.min.css')}}" rel="stylesheet" type="text/css">
    <link href="https://fonts.googleapis.com/css?family=Nunito:200,200i,300,300i,400,400i,600,600i,700,700i,800,800i,900,900i" rel="stylesheet">
  <?php use App\Http\Controllers\ConfigController; ?>    
    <meta charset="utf-8">
    <title>Invoice</title>

    <style type="text/css">
      /* reset */

/*      *{
        border: 0;
        box-sizing: content-box;
        color: inherit;
        font-family: inherit;
        font-size: inherit;
        font-style: inherit;
        font-weight: inherit;
        line-height: inherit;
        list-style: none;
        margin: 0;
        padding: 0;
        text-decoration: none;
        vertical-align: top;
      }*/
/* CSS-only ribbon styles    */
@media (max-width: 1000px) {
  .cnrflash
  {
      /*Position correctly within container*/
      position: absolute;
      top: 85px;
      right: 8%;
      z-index: 1; /*Set overflow to hidden, to mask inner square*/
      overflow: hidden; /*Set size and add subtle rounding      to soften edges*/
      width: 100px;
      height: 100px;
      border-radius: 3px 5px 3px 0;
  }
  #status{
    display: none;
  }
  header h1 {border-radius: 0.25em; color: #FFF; margin: 0 0 1em; padding: 0.5em 0;background-color: black; }
}

@media (min-width: 1001px) {
  .cnrflash
  {
      display: none;
  }
  header h1 {border-radius: 0.25em; color: #FFF; margin: 0 0 1em; padding: 0.5em 0; }
  .unpaid{
    background: red;
  }
  .paid{
    background-color: green;
  }

}



.cnrflash-inner-unpaid
{
    /*Set position, make larger then      container and rotate 45 degrees*/
    position: absolute;
    bottom: 0;
    right: 0;
    width: 145px;
    height: 145px;
    -ms-transform: rotate(45deg); /* IE 9 */
    -o-transform: rotate(45deg); /* Opera */
    -moz-transform: rotate(45deg); /* Firefox */
    -webkit-transform: rotate(45deg); /* Safari and Chrome */
    -webkit-transform-origin: 100% 100%; /*Purely decorative effects to add texture and stuff*/ /* Safari and Chrome */
    -ms-transform-origin: 100% 100%;  /* IE 9 */
    -o-transform-origin: 100% 100%; /* Opera */
    -moz-transform-origin: 100% 100%; /* Firefox */
    background-image: linear-gradient(90deg, transparent 50%, rgba(255,255,255,.1) 50%), linear-gradient(0deg, transparent 0%, rgba(1,1,1,.2) 50%);
    background-size: 4px,auto, auto,auto;
    background-color: #aa0101;
    box-shadow: 0 3px 3px 0 rgba(1,1,1,.5), 0 1px 0 0 rgba(1,1,1,.5), inset 0 -1px 8px 0 rgba(255,255,255,.3), inset 0 -1px 0 0 rgba(255,255,255,.2);
}

.cnrflash-inner-paid
{
    /*Set position, make larger then      container and rotate 45 degrees*/
    position: absolute;
    bottom: 0;
    right: 0;
    width: 145px;
    height: 145px;
    -ms-transform: rotate(45deg); /* IE 9 */
    -o-transform: rotate(45deg); /* Opera */
    -moz-transform: rotate(45deg); /* Firefox */
    -webkit-transform: rotate(45deg); /* Safari and Chrome */
    -webkit-transform-origin: 100% 100%; /*Purely decorative effects to add texture and stuff*/ /* Safari and Chrome */
    -ms-transform-origin: 100% 100%;  /* IE 9 */
    -o-transform-origin: 100% 100%; /* Opera */
    -moz-transform-origin: 100% 100%; /* Firefox */
    background-image: linear-gradient(90deg, transparent 50%, rgba(255,255,255,.1) 50%), linear-gradient(0deg, transparent 0%, rgba(1,1,1,.2) 50%);
    background-size: 4px,auto, auto,auto;
    background-color: #01aa25;
    box-shadow: 0 3px 3px 0 rgba(1,1,1,.5), 0 1px 0 0 rgba(1,1,1,.5), inset 0 -1px 8px 0 rgba(255,255,255,.3), inset 0 -1px 0 0 rgba(255,255,255,.2);
}
.cnrflash-inner:before, .cnrflash-inner:after
{
    /*Use the border triangle trick to make         it look like the ribbon wraps round it's        container*/
    content: " ";
    display: block;
    position: absolute;
    bottom: -16px;
    width: 0;
    height: 0;
    border: 8px solid #800000;
}
.cnrflash-inner:before
{
    left: 1px;
    border-bottom-color: transparent;
    border-right-color: transparent;
}
.cnrflash-inner:after
{
    right: 0;
    border-bottom-color: transparent;
    border-left-color: transparent;
}
.cnrflash-label
{
    /*Make the label look nice*/
    position: absolute;
    bottom: 0;
    left: 0;
    display: block;
    width: 100%;
    padding-bottom: 5px;
    color: #fff;
    text-shadow: 0 1px 1px rgba(1,1,1,.8);
    font-size: 0.95em;
    font-weight: bold;
    text-align: center;
}

      /* content editable */

      *[contenteditable] { border-radius: 0.25em; min-width: 1em; outline: 0;  cursor: pointer; display: inline-block;}

      *[contenteditable]:hover, *[contenteditable]:focus, td:hover *[contenteditable], td:focus *[contenteditable], img.hover { background: #DEF; box-shadow: 0 0 1em 0.5em #DEF; }

      /*span[contenteditable] { display: inline-block; }*/

      /* heading */

      h1 { font: bold 100% Ubuntu, Arial, sans-serif; text-align: center; text-transform: uppercase;  }

      /* table */

      table { font-size: 75%; table-layout: fixed; width: 100%; }
      table { border-collapse: separate; border-spacing: 2px; }
      th, td { border-width: 1px; padding: 0.5em; position: relative; text-align: left; }
      th, td { border-radius: 0.25em; border-style: solid; }
      th { background: #EEE; border-color: #BBB; }
      td { border-color: #DDD; }

      /* page */

      html { font: 16px/1 'Open Sans', sans-serif; overflow: auto; }
      html { background: #efefef; cursor: default; }

      body { box-sizing: border-box; margin:0;}
      #wrapper{
        background-color:#bbbbbb0a; 

        margin: 5px auto;
        padding: 50px;
        max-width: 850px;
        background-color: #fff;
        border: 1px solid #ccc;
        -moz-border-radius: 6px;
        -webkit-border-radius: 6px;
        -o-border-radius: 6px;
        border-radius: 6px;
        font-size: 14px;

      }
      body { background: #FFF;}

      /* header */

      header { margin: 0 0 1.1em }
      header:after { clear: both; content: ""; display: table; }

      
      header address { float: left; font-size: 75%; font-style: normal; line-height: 1.25; margin: 0 1em 1em 0; }
      header address p { margin: 0 0 0.25em; }
      header span, header img { display: block; float: right; }
      header span { margin: 0 0 1em 1em; max-height: 25%; max-width: 60%; position: relative; }
      header img { width: {{config('app.qr_size')}}px; height:{{config('app.qr_size')}}px; }
      header input { cursor: pointer; -ms-filter:"progid:DXImageTransform.Microsoft.Alpha(Opacity=0)"; height: 100%; left: 0; opacity: 0; position: absolute; top: 0; width: 100%; }

      /* article */

      article, article address, table.meta, table.inventory { margin: 0 0 1.1em; }
      article:after { clear: both; content: ""; display: table; }
      article h1 { clip: rect(0 0 0 0); position: absolute; }

      article address { float: left;font-size: 75%; font-style: normal; line-height: 1.25;}
      table.tax {float: left; width: 36%;}      

      table.transaction {float: left; width: 36%; padding-top: 5px;}




      /* table meta & balance */



      table.meta th { width: 40%; }
      table.meta td { width: 60%; }

      /* table items */

      table.inventory { clear: both; width: 100%; }
      table.inventory th { font-weight: bold; text-align: center; }

      table.inventory td:nth-child(1) { width: 26%; }
      table.inventory td:nth-child(2) { width: 38%; }
      table.inventory td:nth-child(3) { text-align: right; width: 12%; }
      table.inventory td:nth-child(4) { text-align: right; width: 12%; }
      table.inventory td:nth-child(5) { text-align: right; width: 12%; }

      /* table balance */
      /* table meta & balance */

      table.meta, table.balance { float: right; width: 36%; }
      table.meta:after, table.balance:after { clear: both; content: ""; display: table; }
      table.balance th, table.balance td { width: 50%; }
      table.balance td { text-align: right; }


      /* table balance */
      table.meta, table.frcs_details { float: right; width: 36%; }
      table.meta:after, table.frcs_details:after { clear: both; content: ""; display: table; }

      table.frcs_details th, table.frcs_details td { width: 50%; }
      table.frcs_details td { text-align: right; }


      @page { margin: 0; }
      .print-page {
          position: fixed;
          right: 1rem;
          top: 1rem;
          width: 3.75rem;
          height: 2.75rem;
          text-align: center;
          color: #fff;
          background: rgba(90,92,105,.5);
          line-height: 46px;
          text-decoration: none;
          border-radius: 6px;
      }

      .back-page {
          position: fixed;
          left: 1rem;
          top: 1rem;
          width: 3.75rem;
          height: 2.75rem;
          text-align: center;
          color: #fff;
          background: rgba(90,92,105,.5);
          line-height: 46px;
          text-decoration: none;
          border-radius: 6px;
      }
      @media print {
        .print-page {
          display: none;
        }        
        .back-page {
          display: none;
        }

        #wrapper{
        
        margin: 0;
        background-color: #fff;

      }
          html, body {
            margin: 0;
            padding: 0;
            background-color: #FFF; 

          }
    }
    </style>
  </head>
  <body style="background-color: #efefef">
    <div id="wrapper">
      <div style="text-align: center;padding-bottom: 10px;"><img alt="" src="{{url('img/Cloud-Dev-Logo.png')}}" height="9%" width="20%" align="center"></div>
      <div style="text-align: center;padding-bottom: 10px; color: #c4c5c2; font-size: 12px;"><i >Specialized in Web and Android Applications</i></div>
      <header>
        
        <h1 class="unpaid">{{ConfigController::get_fiscal_status($invoice->id)}}</h1>
        <address >
          <p>{{config('app.name')}}</p>
          <p>{{config('app.owner')}}<br>Email: {{config('app.email')}}</p>
          <p>{{config('app.mobile')}}</p>
          <p>TIN: {{config('app.tin_number')}}</p>
          <p>Cashier TIN: {{Auth::user()->tin_number}}</p>
        </address>
        
        @if($url <> '')
          <img src="data:image/png;base64,{{DNS2D::getBarcodePNG($url, 'QRCODE')}}" alt="qrcode" id="qrcode"/>
        @else
          <img src="{{url('img/qr_code_na.png')}}" alt="qrcode" id="qrcode"/>
        @endif

      </header>
      <article>
        <address >
          <p>To,</p>
          <p>{{$client->business_name}}<br>{{$client->address}}</p>
          <p>{{$client->phone_contact}}</p>
          @if($client->tin_number <> '')
            <p>Buyer TIN: {{$client->tin_number}}</p>
          @endif
        </address>
        <table class="meta">
          <tr>
            <th><span >Invoice #</span></th>
            <td><span >{{$invoice->uuid}}</span></td>
          </tr>
          <tr>
            <th><span >Date</span></th>
            <td><span >{{$pos_time}}</span></td>
          </tr>
          <tr>
            <th><span >Total Amount</span></th>
            <td><span id="prefix" >$ </span><span>{{$total_amount}}</span></td>
          </tr>
          <tr>
            <th><span >Balance</span></th>
            <td><span id="prefix" >$ </span><span>{{$transaction_bal}}</span></td>
          </tr>

          <tr>
            <th><span >Status</span></th>
            <td><span>{{ConfigController::print_invoice_status($status)}}</span></td>
          </tr>
          </tr>
          <tr>
            <th><span >Payment Type</span></th>
            <td><span>{{$payment_type}}</span></td>
          </tr>

          @if($invoice->payee_reference <> '')
          <tr>
            <th><span >Invoice Ref No.</span></th>
            <td><span>{{ConfigController::get_uuid($invoice->payee_reference)}}</span></td>
          </tr>

          <tr>
            <th><span >SDC Ref No.</span></th>
            <td><span>{{ConfigController::get_sdc_ref($invoice->payee_reference)}}</span></td>
          </tr>
          @endif
        </table>

<!-- Inventory starts here -->

        <table class="inventory">
          <thead>
            <tr><th colspan="5" style="text-align: center;background-color: aliceblue;"><span>{{ConfigController::get_invoice_status($invoice->id)}}</span></th></tr>
            <tr>
              <th><span >Item</span></th>
              <th><span >Description</span></th>
              <th><span >Rate</span></th>
              <th><span >Quantity</span></th>
              <th><span >Price</span></th>
            </tr>
          </thead>
          <tbody>
          @foreach($charges as $charge)
            <tr>
              <td><span >{{ConfigController::get_productName($charge->product_id)}} - {{ConfigController::get_product_labels($charge->product_id)}}</span></td>
              <td><span >{{$charge->description}}</span></td>
              <td><span data-prefix>$</span><span >{{$charge->amount}}</span></td>
              <td><span >{{$charge->quantity}}</span></td>
              <td><span data-prefix>$</span><span>{{$charge->amount * $charge->quantity}}</span></td>
            </tr>
          @endforeach
          </tbody>
        </table>

        <table class="tax">
          <thead>
          <tr><th colspan="4" style="text-align: center;">Tax Details</th></tr>
            <tr>
              <th><span >Label</span></th>
              <th><span >Name</span></th>
              <th><span >Rate</span></th>
              <th><span >Tax</span></th>
            </tr>
          </thead>
          <tbody>
          <?php $total_tax = 0; ?>
          @foreach($taxs as $tax)
            <tr>
              <td><span >{{$tax->label}}</span></td>
              <td><span >{{$tax->name}}</span></td>
              <td><span data-prefix>$</span><span >{{$tax->rate}}</span></td>
              <td><span >{{$tax->tax}}</span></td>
              <?php $total_tax = $total_tax + $tax->tax; ?>
            </tr>
          @endforeach
          </tbody>
        </table>

        <table class="balance">
        <tr><th colspan="2" style="text-align: center;">Totals</th></tr>
          <tr>
            <th><span >Sub Total</span></th>
            <td><span data-prefix>$</span><span><?php echo $total_amount-$total_tax; ?></span></td>
          </tr>
          <tr>
            <th><span >Total Tax</span></th>
            <td><span data-prefix>$</span><span >{{$total_tax}}</span></td>
          </tr>
          <tr>
            <th><span >Total Amount</span></th>
            <td><span data-prefix>$</span><span>{{$total_amount}}</span></td>
          </tr>
        </table>


        <!-- transactions -->
        @if(count($transactions) <> 0)
        <table class="transaction">
          <thead>
          <tr><th colspan="4" style="text-align: center;">Transactions</th></tr>
            <tr>
              <th colspan="2"><span >Brand</span></th>
              <th colspan="2"><span >Amount</span></th>
            </tr>
          </thead>
          <tbody>
          <?php $transaction_total = 0; ?>

          @foreach($transactions as $transaction)
            <tr>
              <td colspan="2"><span >{{ConfigController::get_brand_name($transaction->brand_id)}}</span></td>
              <td colspan="2"><span data-prefix>$</span><span >{{$transaction->amount}}</span></td>
              <?php $transaction_total = $transaction_total + $transaction->amount; ?>
            </tr>
          @endforeach
            <tr>
              <th colspan="2">Balance</th>
              <th colspan="2"><span data-prefix>$</span> {{$transaction_total}}</th>
            </tr>
          </tbody>
        </table>
        @else
          <table class="transaction">
          <thead>
            <tr><th colspan="4" style="text-align: center;">Transactions</th></tr>
          </thead>
          <tbody>
            <tr><td colspan="4" style="text-align: center;">No Transaction found for this Invoice</td></tr>
          </tbody>
        </table>
        @endif

        <table class="frcs_details">
        <tr><th colspan="2" style="text-align: center;">SDC Details</th></tr>
          <tr>
            <th><span >SDC Invoice Number</span></th>
            <td><span>{{$sdc_invoice_no}}</span></td>
          </tr>
          <tr>
            <th><span >Invoice Counter:</span></th>
            <td><span>{{$invoice_counter}}</span></td>
          </tr>
          <tr>
            <th><span >SDC Time</span></th>
            <td><span>{{ConfigController::convert_date($sdc_time)}}</span></td>
          </tr>
        </table>

      </article>

      <h1 class="unpaid">{{ConfigController::get_fiscal_status_end($invoice->id)}}</h1>
    </div>
    <a class="print-page" onclick="window.print();" title="Print">
      <i class="fas fa-print"></i>
    </a>
    <a class="back-page" title="Return to Invoices" href="{{url('invoice.list')}}">
      <i class="fa fa-chevron-left"></i>
    </a>

  </body>
</html>
