@extends('layouts.app')
@section('pageTitle', 'FRCS Verification')
@section('content')

	<label for="invoiceRequest"></label>
    <textarea id="invoiceRequest" cols="100" rows="30" style="display:none"></textarea>
    <label for="taxcore_sign_element"></label>    

	<button style="display: none;" class="btn button btn-block login process_invoice btn-success" type="submit" 
	    id="taxcore_sign_element"
	    data-taxcore-vsdc-url="{{config('app.firca_url')}}"
	    data-taxcore-input-id="invoiceRequest"
	    data-taxcore-output-id="results"
	    data-taxcore-invoice-request=""
	    data-taxcore-debug="true"
	    data-taxcore-signed-invoice-response="">Process VMS Invoice</button>
        

<script type="text/javascript">

	window.addEventListener('load', function() {
		let script = document.createElement('script');
		script.src = "{{config('app.firca_js')}}"; 
		document.head.append(script);

		script.onload  = function(data) {
		   	@if(Auth::user()->pac_status == 'y')
		   		loader();
		   		process_vms();
		    @endif
		};

		script.onerror = function(data) {
			Swal({
				title: 'Error',
				type:'error',
				animation: true,
				text: 'Tax core file not loaded. Please try again later'
			});
		};
	});


		// pac code authentication






	 function process_vms(){
	 	
	 	$.ajax({
	 		type:'post',
	 		url:"{{url('frcs.request')}}",
	 		data:{'_token': $('input[name=_token]').val(),
                'uuid': "{{$uuid}}",
            	'type' : '{{$invoice_type}}',
            	'payment_type': '{{$payment_type}}'
            },
	 		success:function(data){
	 			$('#swal2-title').html('SDC loading ...');
	 			$('#frcs_request').html(data.data);
	 			setTimeout(function() {disable();}, 2000);

	 		},
	 		error:function(data){
	 			console.log(data);
	 		}
	 	});
	 }//END VMS



    //Disable Button and change status to processing
    function disable(){
      
      $('#loader-wrapper').fadeIn('slow');
      //Change status to Processing
      //AJAX CALL
      $.ajax({
        type:'post',
        url:"{{url('invoice.frcs.process')}}",
        data:{
                  '_token': $('input[name=_token]').val(),
                  'id': {{$id}},
              },
        success:function(data)
        {
        	$('#swal2-title').html('Processing Invoice...');
        	$('#taxcore_sign_element').click();
        	
          	console.log(data);
        },
        error:function(data){
          console.log(data);
        }
      });
    }// Disable function finish
</script>

<div id="frcs_request"></div>

<script type="text/javascript">
	function loader(){
	Swal({
		title: 'Loading',
		allowEscapeKey:false,
		allowOutsideClick: false,
	});
	Swal.showLoading()
}

function stop_loader(){
	Swal.close();
}
</script>



@endsection