<!doctype html>
<html>
  <head>
    <link href="{{url('startbootstrap/vendor/fontawesome-free/css/all.min.css')}}" rel="stylesheet" type="text/css">
    <link href="https://fonts.googleapis.com/css?family=Nunito:200,200i,300,300i,400,400i,600,600i,700,700i,800,800i,900,900i" rel="stylesheet">
  <?php use App\Http\Controllers\ConfigController; ?>  

  <script type="text/javascript" language="javascript" src="{{url('js/jquery_3_2_1.min.js')}}"></script>
 <script type="text/javascript" language="javascript" src="{{url('html2canvas/html2canvas.min.js')}}"></script>
<script type="text/javascript" language="javascript" src="{{url('html2canvas/jquery.plugin.html2canvas.js')}}"></script>

  <style type="text/css">
  	@import url("{{url('/startbootstrap/css/sb-admin-2.css')}}");
  	 @media print{

		.table-head 
		{
		    color: #fff !important; background-color: #5a5c69 !important;
		}
        .print-png 
        {
          display: none;
        }    

        .print-page 
        {
          display: none;
        }        
        .back-page 
        {
          display: none;
        }
        .card 
        {
		    position: relative;
		    display: -webkit-box;
		    display: -ms-flexbox;
		    display: flex;
		    -webkit-box-orient: vertical;
		    -webkit-box-direction: normal;
		    -ms-flex-direction: column;
		    flex-direction: column;
		    min-width: 0;
		    word-wrap: break-word;
		    background-color: #fff;
		    background-clip: border-box;
		   	border: 0px solid #fff;
		   	
		}

          html, body {
            margin: 0;
            padding: 0;
            background: #FFF; 
            color:#000;
          }

	    footer{
	    	display: none;
	    }

	}

	body{
		font-size: 12px;
		/*background-color: #efefef;*/
		color: #000;
	}

	footer{
		padding-bottom: 50px;
	}
    .card {
	    position: relative;
	    display: -webkit-box;
	    display: -ms-flexbox;
	    display: flex;
	    -webkit-box-orient: vertical;
	    -webkit-box-direction: normal;
	    -ms-flex-direction: column;
	    flex-direction: column;
	    min-width: 0;
	    word-wrap: break-word;
	    background-color: #fff;
	    background-clip: border-box;
	   	border: 0px;
	   	margin-top: 30px;
	   	/*border: 1px solid #e3e6f0;*/
	}

		.table-head {
		    color: #fff !important;
		    background-color: #5a5c69 !important;
		}
	
      .print-page {
          position: fixed;
          right: 1rem;
          top: 1rem;
          width: 3.75rem;
          height: 2.75rem;
          text-align: center;
          color: #fff;
          background: rgba(90,92,105,.5);
          line-height: 46px;
          text-decoration: none;
          border-radius: 6px;
      }

      .print-png {
          position: fixed;
          right: 1rem;
          top: 5rem;
          width: 3.75rem;
          height: 2.75rem;
          text-align: center;
          color: #fff;
          background: rgba(90,92,105,.5);
          line-height: 46px;
          text-decoration: none;
          border-radius: 6px;
      }
      .back-page {
          position: fixed;
          left: 1rem;
          top: 1rem;
          width: 3.75rem;
          height: 2.75rem;
          text-align: center;
          color: #fff;
          background: rgba(90,92,105,.5);
          line-height: 46px;
          text-decoration: none;
          border-radius: 6px;
      }
      .table {
		    width: 100%;
		    margin-bottom: 1rem;
		    color: #000;
		}
  </style>

</head>

<body>
		<div id="content">		
			<div class="container card my-12">
				<div class="card-body">
					<div class="text-center">
						<div style="text-align: center;padding-bottom: 10px;"><img alt="" src="{{url('img/Cloud-Dev-Logo.png')}}" height="50%" width="20%" align="center"></div>
		      			<div style="text-align: center;padding-bottom: 10px; color: #c4c5c2; font-size: 12px;"><i >Specialized in Web and Android Applications</i></div>
	      			</div>

	      			<div class="col-12"><hr></div>

	      			<div class="col-12">
	      				<div class="text-center">{{ConfigController::get_fiscal_status($invoice->id)}}</div>
	      			</div>
	      			<br>
	      			<div class="row">  <!--QR Code-->
	      				<div class="col-6">
		      				<div class="float-left h-100" style="font-size: 14px;">
		      					<br> 
		      				  	TIN: {{config('app.tin_number')}}<br>       
					          	Company: {{config('app.name')}}<br>
					          	Store: {{config('app.store')}}<br>
					          	Address: {{config('app.address')}}<br>
					          	District: {{config('app.district')}}<br>
					          	Cashier TIN: {{Auth::user()->tin_number}}<br>
					          	Email: {{config('app.email')}}<br>
					           	Mobile: {{config('app.mobile')}}<br>
		      				</div>
		      			</div>
		      			<div class="col-6">
		      				<div class="float-right">
		  		      			@if($url <> '')
						          <img src="data:image/png;base64,{{DNS2D::getBarcodePNG($url, 'QRCODE')}}" alt="qrcode" id="qrcode" width="{{config('app.qr_size')}}" height="{{config('app.qr_size')}}">
						        @else
						          <img src="{{url('img/qr_code_na.png')}}" alt="qrcode" id="qrcode" width="{{config('app.qr_size')}}" height="{{config('app.qr_size')}}">
						        @endif
					         
		      				</div>
		      			</div>

	      			</div> <!--QR Code-->

	      			<br><br>
					<div class="row">
						<div class="col-6">
		      				<div class="float-left"  style="font-size: 14px;">
 								<u>Buyer Details</u><br>
					          {{$client->business_name}}<br>
					          {{$client->address}}<br>
					          Contact: {{$client->phone_contact}}<br>
					          @if($client->tin_number <> '')
					            Buyer TIN: {{$client->tin_number}}<br>
					          @endif
		      				</div>
		      			</div>
						
						<div class="col-6">
							<div class="float-right">
								<div class="table table-responsive table-sm">
							        <table>
							          <tr>
							            <th><span >Invoice #</span></th>
							            <td><span >{{$invoice->uuid}}</span></td>
							          </tr>
							          <tr>
							            <th><span >Date</span></th>
							            <td><span >{{$pos_time}}</span></td>
							          </tr>
							          <tr>
							            <th><span >Total Amount</span></th>
							            <td><span id="prefix" >$ </span><span>{{ConfigController::two_decimal($total_amount)}}</span></td>
							          </tr>
							          <tr>
							            <th><span >Balance</span></th>
							            <td><span id="prefix" >$ </span><span>{{ConfigController::two_decimal($transaction_bal)}}</span></td>
							          </tr>

							          <tr>
							            <th><span >Status</span></th>
							            <td><span>{{ConfigController::print_invoice_status($status)}}</span></td>
							          </tr>
							          </tr>
							          <tr>
							            <th><span >Payment Type</span></th>
							            <td><span>{{$payment_type}}</span></td>
							          </tr>

							          @if($invoice->payee_reference <> '')
							          <tr>
							            <th><span >Invoice Ref No.</span></th>
							            <td><span>{{ConfigController::get_uuid($invoice->payee_reference)}}</span></td>
							          </tr>

							          <tr>
							            <th><span >SDC Ref No.</span></th>
							            <td><span>{{ConfigController::get_sdc_ref($invoice->payee_reference)}}</span></td>
							          </tr>
							          @endif
							        </table>			
								</div>
							</div>
						</div>
					</div>
					<br>
					<div class="col-12 text-center"><span>{{ConfigController::get_invoice_status($invoice->id)}}</span></div>
					<br>
					<div class="row">

						<div class="table table-responsive table-sm col-5">
							<table class="col-12  table-bordered">
					          <thead>
					          	<tr><th colspan="5" style="text-align: center;color: #fff !important; background-color: #5a5c69 !important;">Items</th></tr>
					            <tr style="color: #6e707e;background-color: #eaecf4;border-color: #e3e6f0;">
					              <th><span >Item</span></th>
					              <th><span >Description</span></th>
					              <th><span >Rate</span></th>
					              <th><span >Quantity</span></th>
					              <th><span >Total</span></th>
					            </tr>
					          </thead>
					          <tbody>
					          @foreach($charges as $charge)
					            <tr>
					              <td><span >{{ConfigController::get_productName($charge->product_id)}} - {{ConfigController::get_product_labels($charge->product_id)}}</span></td>
					              <td><span >{{$charge->description}}</span></td>
					              <td><span data-prefix>$</span><span >{{ConfigController::two_decimal($charge->amount)}}</span></td>
					              <td><span >{{$charge->quantity}}</span></td>
					              @if($invoice->transaction_type == 'Refund')
					              	<td><span data-prefix>$</span><span>{{'-'.ConfigController::two_decimal($charge->amount * $charge->quantity)}}</span></td>
					              @else
					              	<td><span data-prefix>$</span><span>{{ConfigController::two_decimal($charge->amount * $charge->quantity)}}</span></td>
					              @endif
					            </tr>
					          @endforeach
					          </tbody>
					        </table>
					    </div>

					    <div class="table table-responsive table-sm  col-5 offset-2">
							<table class="col-12  table-bordered">
						        <tr><th colspan="2" style="text-align: center;color: #fff !important; background-color: #5a5c69 !important;">Totals</th></tr>
						          <tr>
						            <th><span >Sub Total</span></th>
						            <td><span data-prefix>$</span><span><?php echo ConfigController::two_decimal($total_amount-$total_tax); ?></span></td>
						          </tr>
						          <tr>
						            <th><span >Total Tax</span></th>
						            <td><span data-prefix>$</span><span >{{ConfigController::two_decimal($total_tax)}}</span></td>
						          </tr>
						          <tr>
						            <th><span >Total Amount</span></th>
						            <td><span data-prefix>$</span><span>{{ConfigController::two_decimal($total_amount)}}</span></td>
						          </tr>
						    </table>
						</div>


					</div>

					<br>
					<div class="row">
						<div class="table table-responsive table-sm  col-5">
							   	<table class="col-12  table-bordered">
						          <thead >
						          <tr >
						          	<th colspan="4" style="text-align: center;color: #fff !important; background-color: #5a5c69 !important;">Tax Details</th>
						          </tr>
						     	 </thead>
						     	 <thead>
						            <tr style="color: #6e707e;background-color: #eaecf4;border-color: #e3e6f0;">
						              <th><span >Label</span></th>
						              <th><span >Name</span></th>
						              <th><span >Rate</span></th>
						              <th><span >Tax</span></th>
						            </tr>
						          </thead>
						          <tbody>
						          <?php $total_tax = 0; ?>
						          @foreach($taxs as $tax)
						          	@if($tax->label == 'P')
						            <tr>
						              <td><span >{{$tax->label}}</span></td>
						              <td><span >{{$tax->name}}</span></td>
						              <td><span data-prefix>$</span><span >{{ConfigController::two_decimal($tax->rate)}}</span></td>
						              <td><span >{{ConfigController::two_decimal($tax->tax)}}</span></td>
						              <?php $total_tax = $total_tax + $tax->tax; ?>
						            </tr>						          		
						          	@else
						            <tr>
						              <td><span >{{$tax->label}}</span></td>
						              <td><span >{{$tax->name}}</span></td>
						              <td><span >{{$tax->rate.'%'}}</span></td>
						              <td><span >{{ConfigController::two_decimal($tax->tax)}}</span></td>
						              <?php $total_tax = $total_tax + $tax->tax; ?>
						            </tr>
						            @endif
						          @endforeach
						          </tbody>
						        </table>
						    </div>
						

						<div class="table table-responsive table-sm col-5 offset-2">
							<table class="col-12 table-bordered">
						        <tr><th colspan="2" style="text-align: center;color: #fff !important; background-color: #5a5c69 !important;">SDC Details</th></tr>
						          <tr>
						            <th><span >SDC Invoice Number</span></th>
						            <td><span>{{$sdc_invoice_no}}</span></td>
						          </tr>
						          <tr>
						            <th><span >Invoice Counter:</span></th>
						            <td><span>{{$invoice_counter}}</span></td>
						          </tr>
						          <tr>
						            <th><span >SDC Time</span></th>
						            <td><span>{{ConfigController::convert_date($sdc_time)}}</span></td>
						          </tr>
						    </table>
						</div>
					</div>
					<br><br>
					<div class="col-12">
	      				<div class="text-center">{{ConfigController::get_fiscal_status_end($invoice->id)}}</div>
	      			</div>
	      			<br>
				    <div class="table table-responsive table-sm offset-1 col-10">
				        <!-- transactions -->
				        @if(count($transactions) <> 0)
				        <table class="col-12  table-bordered">
				          <thead>
				          <tr><th colspan="6" style="text-align: center;color: #fff !important; background-color: #5a5c69 !important;">Transactions</th></tr>
				            <tr style="color: #6e707e;background-color: #eaecf4;border-color: #e3e6f0;">
				              <th colspan="2"><span >Date</span></th>
				              <th colspan="2"><span >Brand</span></th>
				              <th colspan="2"><span >Amount</span></th>
				            </tr>
				          </thead>
				          <tbody>
				          <?php $transaction_total = 0; ?>

				          @foreach($transactions as $transaction)
				            <tr>
				              <td colspan="2"><span >{{$transaction->created_at}}</span></td>
				              <td colspan="2"><span >{{ConfigController::get_brand_name($transaction->brand_id)}}</span></td>
				              <td colspan="2"><span data-prefix>$ </span><span >{{ConfigController::two_decimal($transaction->amount)}}</span></td>
				              <?php $transaction_total = $transaction_total + $transaction->amount; ?>
				            </tr>
				          @endforeach
				            <tr>
				              <th colspan="4">Balance</th>
				              <th colspan="2"><span data-prefix>$</span> {{ConfigController::two_decimal($transaction_total)}}</th>
				            </tr>
				          </tbody>
				        </table>
				        @else
				          <table class="col-12  table-bordered">
				          <thead>
				            <tr><th colspan="6" style="text-align: center;color: #fff !important; background-color: #5a5c69 !important;">Transactions</th></tr>
				          </thead>
				          <tbody>
				            <tr><td colspan="6" style="text-align: center;">No Transaction found for this Invoice</td></tr>
				          </tbody>
				        </table>
				        @endif
					</div>

	      		</div> <!--Card Body end-->
			</div><!--Card end-->
		</div>
	<a class="print-page" onclick="window.print();" title="Print">
      <i class="fas fa-print"></i>
    </a>

   	<a class="print-png" title="Save">
      <i class="fas fa-camera"></i>
    </a>

    <a class="back-page" title="Return to Invoices" href="{{url('invoice.list')}}">
      <i class="fa fa-chevron-left"></i>
    </a>	

    <script type="text/javascript">
    	$('.print-png').on("click",function(){
	    	$('#content').html2canvas({
	    		onrendered : function(canvas) {
	    		var img = canvas.toDataURL();
	     		
	     			//IE/Edge Support (PNG Only)
	        		if(window.navigator.msSaveBlob)
	        		{
	        			window.navigator.msSaveBlob(canvas.msToBlob(),"{{$invoice->uuid}}.png");
	        		}
	        		else //For other browsers
	        		{
	        			const a = document.createElement("a");
	        			document.body.appendChild(a);
	        			a.href = img;
	        			a.download = "{{$invoice->uuid}}.png";
	        			a.click();
	        			document.body.removeChild(a);
	        		}
	            }
	        });
	    });
    </script>
</body>



<footer>
	
</footer>

</html>