<!doctype html>
<html>
  <head>
  	    <link href="{{url('startbootstrap/vendor/fontawesome-free/css/all.min.css')}}" rel="stylesheet" type="text/css">
    <link href="https://fonts.googleapis.com/css?family=Nunito:200,200i,300,300i,400,400i,600,600i,700,700i,800,800i,900,900i" rel="stylesheet">
  	  <?php use App\Http\Controllers\ConfigController; ?>  

	  <script type="text/javascript" language="javascript" src="{{url('js/jquery_3_2_1.min.js')}}"></script>
	 <script type="text/javascript" language="javascript" src="{{url('html2canvas/html2canvas.min.js')}}"></script>
	<script type="text/javascript" language="javascript" src="{{url('html2canvas/jquery.plugin.html2canvas.js')}}"></script>
   
	<style type="text/css">
	@import url("{{url('/startbootstrap/css/style.css')}}");
	@media print("{{url('/startbootstrap/ccs/print.css')}}");

	@media print{

		.table-head 
		{
		    color: #fff !important; background-color: #5a5c69 !important;
		}
        .print-png 
        {
          display: none;
        }    

        .print-page 
        {
          display: none;
        }        
        .back-page 
        {
          display: none;
        }
        .card 
        {
		    position: relative;
		    display: -webkit-box;
		    display: -ms-flexbox;
		    display: flex;
		    -webkit-box-orient: vertical;
		    -webkit-box-direction: normal;
		    -ms-flex-direction: column;
		    flex-direction: column;
		    min-width: 0;
		    word-wrap: break-word;
		    background-color: #fff;
		    background-clip: border-box;
		   	border: 0px solid #fff;
		   	
		}

          html, body {
            margin: 0;
            padding: 0;
            background: #FFF; 
            color:#000;
          }

	    footer{
	    	display: none;
	    }

	}

	body{
		font-size: 12px;
		/*background-color: #efefef;*/
		color: #000;
	}

	footer{
		padding-bottom: 50px;
	}
    .card {
	    position: relative;
	    display: -webkit-box;
	    display: -ms-flexbox;
	    display: flex;
	    -webkit-box-orient: vertical;
	    -webkit-box-direction: normal;
	    -ms-flex-direction: column;
	    flex-direction: column;
	    min-width: 0;
	    word-wrap: break-word;
	    background-color: #fff;
	    background-clip: border-box;
	   	border: 0px;
	   	margin-top: 30px;
	   	/*border: 1px solid #e3e6f0;*/
	}

		.table-head {
		    color: #fff !important;
		    background-color: #5a5c69 !important;
		}
	
      .print-page {
          position: fixed;
          right: 1rem;
          top: 1rem;
          width: 3.75rem;
          height: 2.75rem;
          text-align: center;
          color: #fff;
          background: rgba(90,92,105,.5);
          line-height: 46px;
          text-decoration: none;
          border-radius: 6px;
      }

      .print-png {
          position: fixed;
          right: 1rem;
          top: 5rem;
          width: 3.75rem;
          height: 2.75rem;
          text-align: center;
          color: #fff;
          background: rgba(90,92,105,.5);
          line-height: 46px;
          text-decoration: none;
          border-radius: 6px;
      }
      .back-page {
          position: fixed;
          left: 1rem;
          top: 1rem;
          width: 3.75rem;
          height: 2.75rem;
          text-align: center;
          color: #fff;
          background: rgba(90,92,105,.5);
          line-height: 46px;
          text-decoration: none;
          border-radius: 6px;
      }
</style>
<!-- 	<link rel='stylesheet' type='text/css' href='css/style.css' />
	<link rel='stylesheet' type='text/css' href='css/print.css' media="print" /> -->


</head>

<body>
<div id="content">	
	<div id="page-wrap">

		<div id="header">INVOICE</div>
		<div class="text-center">{{ConfigController::get_fiscal_status($invoice->id)}}</div>
		<div id="identity">
			
            <div id="address">
            	TIN: {{config('app.tin_number')}}<br>
				Company: {{config('app.name')}}<br>
				Store: {{config('app.store')}}<br>
				Address: {{config('app.address')}}<br>
				District: {{config('app.district')}}<br>
				Cashier TIN: {{Auth::user()->tin_number}}<br>
				Email: {{config('app.email')}}<br>
				Mobile: {{config('app.mobile')}}
			</div>

            <div id="logo">
              <img id="image" src="{{url('img/client_logo.png')}}" alt="logo" height="40px" width="150px" />
            </div>
		
		</div>
		
		<div style="clear:both"></div>
		
		<div id="customer">

            <div id="customer-title" rows="7">
				<br>
				{{$client->business_name}}<br>
				{{$client->address}}<br>
				Contact: {{$client->phone_contact}}<br>
				@if($client->tin_number <> '')<br>
				Buyer TIN: {{$client->tin_number}}<br>
				@endif
			</div>

            <table id="meta">
                <tr>
                    <td class="meta-head">Invoice #</td>
                    <td><textarea>{{$invoice->uuid}}</textarea></td>
                </tr>
                <tr>

                    <td class="meta-head">Pos Date</td>
                    <td>{{$pos_time}}</td>
                </tr>
                <tr>
                    <td class="meta-head">Total Amount</td>
                    <td><div class="due">$ {{ConfigController::two_decimal($total_amount)}}</div></td>
                </tr>
                <tr>
                    <td class="meta-head">Balance</td>
                    <td><div class="due">$ {{ConfigController::two_decimal($transaction_bal)}}</div></td>
                </tr>                

                <tr>
                    <td class="meta-head">Status</td>
                    <td><div class="due">{{ConfigController::print_invoice_status($status)}}</div></td>
                </tr>
                <tr>
                    <td class="meta-head">Payment Type</td>
                    <td><div class="due">{{$payment_type}}</div></td>
                </tr>
                @if($invoice->payee_reference <> '')
                <tr>
                    <td class="meta-head">Invoice Ref No.</td>
                    <td><div class="due">{{ConfigController::get_uuid($invoice->payee_reference)}}</div></td>
                </tr>
                <tr>
                    <td class="meta-head">SDC Ref No.</td>
                    <td><div class="due">{{ConfigController::get_sdc_ref($invoice->payee_reference)}}</div></td>
                </tr>
                @endif
            </table>
		
		</div>
		<br>
		<div class="text-center">{{ConfigController::get_invoice_status($invoice->id)}}</div>
		<table id="items">
		
		  <tr>
		      <th>Item</th>
		      <th>Description</th>
		      <th>Unit Cost</th>
		      <th>Quantity</th>
		      <th>Price</th>
		  </tr>
		  @foreach($charges as $charge)
		  <tr class="item-row">
		      <td class="item-name"><div class="delete-wpr"><textarea readonly="readonly">{{ConfigController::get_productName($charge->product_id)}} - {{ConfigController::get_product_labels($charge->product_id)}}</textarea></div></td>
		      <td class="description"><textarea readonly="readonly">{{$charge->description}}</textarea></td>
		      <td><textarea class="cost" readonly="readonly">$ {{ConfigController::two_decimal($charge->amount)}}</textarea></td>
		      <td><textarea class="qty" readonly="readonly">{{$charge->quantity}}</textarea></td>
		      @if($invoice->transaction_type == 'Refund')
		      <td><span class="price">$ {{'-'.ConfigController::two_decimal($charge->amount * $charge->quantity)}}</span></td>
		      @else
		      <td><span class="price">${{ConfigController::two_decimal($charge->amount * $charge->quantity)}}</span></td>
		      @endif
		  </tr>
		  @endforeach		  		  
		  <tr>
		      <td colspan="2" rowspan="3"style="border-top: 0;border-right: 0;">
		      	<table id="items">
		      		<tr><th colspan="4"style="text-align: center;">Tax Details</th></tr>
		      		<tr>
		              <th><span >Label</span></th>
		              <th><span >Name</span></th>
		              <th><span >Rate</span></th>
		              <th><span >Tax</span></th>
	              	</tr>

  					<?php $total_tax = 0; ?>
		        	@foreach($taxs as $tax)
		          		@if($tax->label == 'P')
		          		<tr>
			              <td><span >{{$tax->label}}</span></td>
			              <td><span >{{$tax->name}}</span></td>
			              <td><span data-prefix>$</span><span >{{ConfigController::two_decimal($tax->rate)}}</span></td>
			              <td><span >{{ConfigController::two_decimal($tax->tax)}}</span></td>
			              <?php $total_tax = $total_tax + $tax->tax; ?>
			            </tr>						          		
			          	@else
			            <tr>
			              <td><span >{{$tax->label}}</span></td>
			              <td><span >{{$tax->name}}</span></td>
			              <td><span >{{$tax->rate.'%'}}</span></td>
			              <td><span >{{ConfigController::two_decimal($tax->tax)}}</span></td>
			              <?php $total_tax = $total_tax + $tax->tax; ?>
			            </tr>
			            @endif
			        @endforeach
		      	</table>
		      </td>
		      <td colspan="1" class="blank"> </td>
		      <td colspan="1" class="total-line">Subtotal</td>
		      <td class="total-value"><div id="subtotal">$ <?php echo ConfigController::two_decimal($total_amount-$total_tax); ?></div></td>
		  </tr>
		  <tr>
		      <td colspan="1" class="blank"> </td>
		      <td colspan="1" class="total-line">Total Tax</td>

		      <td class="total-value"><textarea id="paid">$ {{ConfigController::two_decimal($total_tax)}}</textarea></td>
		  </tr>
		  <tr>
		      <td colspan="1" class="blank"> </td>
		      <td colspan="1" class="total-line balance">Total Amount</td>
		      <td class="total-value balance"><div class="due">$ {{ConfigController::two_decimal($total_amount)}}</div></td>
		  </tr>
		
		</table>
		<table id="items">			
			<tr class="thead-dark">
				<th><span >SDC Invoice Number</span></th>
	            <td><span>{{$sdc_invoice_no}}</span></td>
				<td style="text-align: center;" rowspan="3">		  	
		      		@if($url <> '')
			          <img src="data:image/png;base64,{{DNS2D::getBarcodePNG($url, 'QRCODE')}}" alt="qrcode" id="qrcode" width="{{config('app.qr_size')}}" height="{{config('app.qr_size')}}">
			        @else
			          <img src="{{url('img/qr_code_na.png')}}" alt="qrcode" id="qrcode" width="{{config('app.qr_size')}}" height="{{config('app.qr_size')}}">
			        @endif
				</td>
			</tr>

	          <tr>
	            <th><span >Invoice Counter:</span></th>
	            <td><span>{{$invoice_counter}}</span></td>
	          </tr>
	          <tr>
	            <th><span >SDC Time</span></th>
	            <td><span>{{ConfigController::convert_date($sdc_time)}}</span></td>
	          </tr>
				

			</tr>
		</table>
		<div id="terms">
		  
		  <div class="text-center">{{ConfigController::get_fiscal_status_end($invoice->id)}}</div>
		</div>
	
	</div>
</div>	
	<a class="print-page" onclick="window.print();" title="Print">
      <i class="fas fa-print"></i>
    </a>

   	<a class="print-png" title="Save">
      <i class="fas fa-camera"></i>
    </a>

    <a class="back-page" title="Return to Invoices" href="{{url('invoice.list')}}">
      <i class="fa fa-chevron-left"></i>
    </a>	

    <script type="text/javascript">
    	$('.print-png').on("click",function(){
	    	$('#content').html2canvas({
	    		onrendered : function(canvas) {
	    		var img = canvas.toDataURL();
	     		
	     			//IE/Edge Support (PNG Only)
	        		if(window.navigator.msSaveBlob)
	        		{
	        			window.navigator.msSaveBlob(canvas.msToBlob(),"{{$invoice->uuid}}.png");
	        		}
	        		else //For other browsers
	        		{
	        			const a = document.createElement("a");
	        			document.body.appendChild(a);
	        			a.href = img;
	        			a.download = "{{$invoice->uuid}}.png";
	        			a.click();
	        			document.body.removeChild(a);
	        		}
	            }
	        });
	    });
    </script>
</body>

</html>