@extends('layouts.app')
@section('pageTitle', 'Add Items')
@section('content')

<?php use App\Http\Controllers\ConfigController; 
$total_amount = 0;?>  
<div class="offset-2 col-md-8">
    <div class="progress" style="height: 5px;">
        <div class="progress-bar progress-bar-striped progress-bar-animated" role="progressbar" id="progress" style="width:{{$progress}}%; " aria-valuemin="0" aria-valuemax="100"></div>
  </div>
  <div class="card" id="invoice-content">

		<div class="card-header" id="card">Items</div>
		<div class="card-body">
			<form class="form-horizontal" method="POST" action="{{url('invoice.payment_type.add')}}" id="item-form-submit">
				<!-- Client ID -->
				<input type="hidden" name="id" value="{{$invoice_id}}">
				@csrf
	            <div class="form-group row">
	                <label for="invoice_id" class="offset-md-2 col-md-3 control-label control-label-sm">Invoice ID</label>

	                <div class="col-md-5">
	                	<label for="invoice_id" class="control-label control-label-sm">{{$uuid}}</label>
	                </div>
	            </div>

	            <div class="form-group row">
	                <label for="client_id" class="offset-md-2 col-md-3 control-label control-label-sm">Client</label>

	                <div class="col-md-5">
	                	<label for="client_id" class="control-label control-label-sm">{{$client_id}}</label>
	                </div>
	            </div>

				<!-- Transaction Type -->
	            <div class="form-group row">
	                <label for="transaction_type" class="offset-md-2 col-md-3 control-label control-label-sm">Transaction Type</label>

	                <div class="col-md-5">
	                    <label for="transaction_type" class="control-label control-label-sm">{{$transaction_type}}</label>
	                </div>
	            </div>


				<!-- Invoice Type -->
	            <div class="form-group row">
	                <label for="invoice_type" class="offset-md-2 col-md-3 control-label control-label-sm">Invoice Type</label>

	                <div class="col-md-5">
	                	<label for="invoice_type" class="control-label control-label-sm">{{$invoice_type}}</label>
	                    <strong id="error_invoice_type"></strong>
	                </div>
	            </div>

	            <div class="col-md-12 col-sm-12">
	            	<input type="text" name="product_search" id="product_search" placeholder="Search Product" class="form-control form-control-sm">
	            	<br>
		            <div class="well form-group" id="product_well">
		            	@include('invoices.product_data')
		            </div>
	            </div>

	            <div class="col-md-12 col-sm-12">
		            <div id="charges" class="card-body">
		            	@include('invoices.charges')
		            </div>
		        </div>

	            
			</form>
		</div>


<input type="hidden" id="check_result">
<!-- MODAL -->
<div class="modal fade" id="modal-add">
    <div class="modal-dialog">
      <div class="modal-content">
      
        <!-- Modal Header -->
        <div class="modal-header">
          <h4 class="modal-title">Add Items</h4>
          <button type="button" class="close" data-dismiss="modal">&times;</button>
        </div>

        <!-- Modal body -->
        <div class="modal-body">
                <form id="addChargeItems" method="POST" action="{{url('charges.products.add')}}">
                    @csrf
                    <div class="form-group">
                        <div>
                            <input type="hidden" name="invoice_id" id="modal_invoice_id" value="{{$invoice_id}}">
                            <input type="hidden" name="product_id" id="modal_product_id">
                            <input type="hidden" name="type" id="modal_type">
                            <input type="text" class="form-control" name="amount" id="modal_amount" placeholder="Enter Amount ... ">
                        </div>
                    </div>


                    <div class="form-group">
                        <div>
                        	<textarea class="form-control" id="modal_description" name="description" placeholder="Describe product here..."></textarea>
                        </div>
                    </div>
                    
                </form>
        </div>
        
        <!-- Modal footer -->
        <div class="modal-footer">
          <button type="submit" class="btn btn-primary" id="submit-add">Add</button>

          <button type="button" class="btn btn-danger" data-dismiss="modal">Close</button>
        </div>
        
      </div>
    </div>
  </div>
<!-- MODAL END -->



<script type="text/javascript">
$(document).ready(function(){
	$('#submit-add').on('click',function(e){
		e.preventDefault();
		var form, url;
		url = $('#addChargeItems').attr('action');
		form = $('#addChargeItems').serialize();
		
				$.ajax({
				url: url,
				type:"POST",
				data:form,
				success:function(data){
					stop_loader();
					console.log(data);
					if(data.html){
						swal({
							  	type: 'success',
							  	title: 'Yah, Product added !!!',
							  	animation: true
						});
					

						$('#charges').html(data.html);
						$('#modal-add').modal('hide');
					}

					if(data.unauthorized_access){
						swal({
							  	type: 'error',
							  	title: 'Oops...',
							  	text: data.unauthorized_access,
							  	animation: true
						});
					}


				},
				error:function(data){
					stop_loader();
					swal({
						  	type: 'error',
						  	title: 'Error!!!',
						  	text: 'Something went wrong. Please try again later.',
						  	animation: true
					});
				}
			});
	});
})

function checks(id,product_type)
{
	var result = null;
	$.ajax({
			url: "{{url('charges.products.checks')}}",
			type:"POST",
			data:{
				'_token': $('input[name=_token]').val(),
				'invoice_id': '{{$invoice_id}}',
				'product_id': id
			},
			success:function(data){
				if(data.result === '0')
				{
					$.ajax({
						url: "{{url('charges.products.add')}}",
						type:"POST",
						data:{
							'_token': $('input[name=_token]').val(),
							'invoice_id': '{{$invoice_id}}',
							'product_id': id,
							'type': product_type,
						},
						success:function(result){
							stop_loader();
							console.log(result);
							if(result.html){
								swal({
									  	type: 'success',
									  	title: 'Yah, Product added !!!',
									  	animation: true
								});
							

								$('#charges').html(result.html);
							}

							if(result.unauthorized_access){
								swal({
									  	type: 'error',
									  	title: 'Oops...',
									  	text: data.unauthorized_access,
									  	animation: true
								});
							}


						},
						error:function(result){
							stop_loader();
							swal({
								  	type: 'error',
								  	title: 'Error!!!',
								  	text: 'Something went wrong. Please try again later.',
								  	animation: true
							});
						}
					});
				}
				
				if(data.result === '1') //return false 
				{
					stop_loader();	
					document.getElementById('modal_product_id').value = id;
					document.getElementById('modal_type').value = product_type;
					document.getElementById('modal_amount').value = '';
					document.getElementById('modal_description').value = '';
					$('#modal-add').modal('show');
				}
			},
			error:function(data){
				stop_loader();
				swal({
					  	type: 'error',
					  	title: 'Error!!!',
					  	text: 'Something went wrong. Please try again later.',
					  	animation: true
				});
			}
		});

	return result;
}


function add_cost(id,product_type)
{
	loader();

	if(product_type === 'x')
	{
		checks(id,product_type);
		
	}
	
	if(product_type === 'f')
	{
		$.ajax({
			url: "{{url('charges.products.add')}}",
			type:"POST",
			data:{
				'_token': $('input[name=_token]').val(),
				'invoice_id': '{{$invoice_id}}',
				'product_id': id,
				'type': product_type,
			},
			success:function(data){
				stop_loader();
				console.log(data);
				if(data.html){
					swal({
						  	type: 'success',
						  	title: 'Yah, Product added !!!',
						  	animation: true
					});
				

					$('#charges').html(data.html);
				}

				if(data.unauthorized_access){
					swal({
						  	type: 'error',
						  	title: 'Oops...',
						  	text: data.unauthorized_access,
						  	animation: true
					});
				}


			},
			error:function(data){
				stop_loader();
				swal({
					  	type: 'error',
					  	title: 'Error!!!',
					  	text: 'Something went wrong. Please try again later.',
					  	animation: true
				});
			}
		});
	}


}


function minus(id){
	loader();
		$.ajax({
			type: 'POST',
			url: "{{url('charges.product.one.remove')}}",
			data:{
				'_token': $('input[name=_token]').val(),
				'charge_id': id,
				'invoice_id':"{{$invoice_id}}"
			},
			success:function(data)
			{
				stop_loader();
				console.log(data);
				if(data.unauthorized_access){
					swal({
					  	type: 'error',
					  	title: 'Oops...',
					  	text: data.unauthorized_access,
					    animation: true
					});
				}

				if(data.html){
					swal({
						  	type: 'success',
						  	title: 'One quantity removed',
						  	animation: true
					});
				

					$('#charges').html(data.html);
				}


			},
			error:function(data){
				stop_loader();
				swal({
					  	type: 'error',
					  	title: 'Error!!!',
					  	text: 'Something went wrong. Please try again later.',
					  	animation: true
				});		
			}
		});
	}



function remove(id){
	loader();
		$.ajax({
			type: 'POST',
			url: "{{url('charges.product.remove')}}",
			data:{
				'_token': $('input[name=_token]').val(),
				'charge_id': id,
				'invoice_id':"{{$invoice_id}}"
			},
			success:function(data)
			{
				stop_loader();
				console.log(data);
				if(data.unauthorized_access){
					swal({
					  	type: 'error',
					  	title: 'Oops...',
					  	text: data.unauthorized_access,
					    animation: true
					});
				}

				if(data.html){
					swal({
						  	type: 'success',
						  	title: 'Product removed.',
						  	animation: true
					});
				

					$('#charges').html(data.html);
				}


			},
			error:function(data){
				stop_loader();
				swal({
					  	type: 'error',
					  	title: 'Error!!!',
					  	text: 'Something went wrong. Please try again later.',
					  	animation: true
				});		
			}
		});
	}

	$('#product_search').on('keyup',function(){
		var value = $(this).val();

		$.ajax({
			type:'post',
			url:"{{url('charges.products.search')}}",
			data:{
				'_token': $('input[name=_token]').val(),
				'name': value
			},
			success:function(data){
				$('#product_well').html(data.products);
			},
			error:function(data){
				swal({
					  	type: 'error',
					  	title: 'Error!!!',
					  	text: 'Something went wrong. Please try again later.',
					  	animation: true
				});	
			}
		});
	});

	// submit items form 
	$('#item-form-submit').submit(function(e){
		e.preventDefault();
		loader();

		var formData, url;
		formData = $(this).serialize();
		url = $(this).attr('action');
		$.ajax({
			url: url,
			type:"POST",
			data:formData,
			success:function(data){
				stop_loader();
				if(data.html){
					document.getElementById('progress').style.width = data.progress+'%';
					$('#invoice-content').html(data.html);
				}

				if(data.unauthorized_access){
					swal({
						  	type: 'error',
						  	title: 'Oops...',
						  	text: data.unauthorized_access,
						  	animation: true
					});
				}

				if(data.errors){
					swal({
						  	type: 'error',
						  	title: 'Oops...',
						  	text: data.errors,
						  	animation: true
					});
				}

			},
			error:function(data){
				stop_loader();
				var obj = jQuery.parseJSON(data.responseText) ;
				var errors = obj.errors;

				if(obj.message)
				{
					swal({
					  	type: 'error',
					  	title: 'Error!!!',
					  	text: obj.message,
					  	animation: true
					});
				}

			}
		});


	});

</script>
@endsection