<?php use App\Http\Controllers\ConfigController; ?>
@if(count($roles)>'0')
	<div class="table-responsive">
		<table class="table table-striped table-bordered  table-hover table-sm" style="font-size: 12px;">
			<thead class="thead-dark">
				<th>ID</th>
				<th>Name</th>
				<th>Desc</th>
				<th>Created By</th>
				<th>Updated By</th>
				<th>Status</th>
				@if(ConfigController::check_privilege('ACCESS_ADD_PRIVILEGES_TO_ROLES'))
					<th></th>
				@endif
			</thead>
			<tbody>
			
				@foreach($roles as $role)
					<tr>
						<td>{{$role->id}}</td>
						<td>{{$role->name}}</td>
						<td>{{$role->description}}</td>
						<td>{{ConfigController::get_username($role->created_by)}}</td>
						<td>{{ConfigController::get_username($role->updated_by)}}</td>
						<td>@if($role->status == 'a') Active @else Not Active @endif</td>
						@if(ConfigController::check_privilege('ACCESS_ADD_PRIVILEGES_TO_ROLES'))
							<td><a href="{{url('/role.add.privileges')}}.{{$role->id}}" class="btn btn-primary btn-sm" title="Add Privilege"><span class="fa fa-plus"></span></a></td>		
						@endif		
					</tr>
				@endforeach
			
			</tbody>
		</table>
	</div>
@else
	<div class="alert alert-warning">
		<div>Sorry, no result found.</div>
	</div>
@endif