@extends('layouts.app')
@section('pageTitle', 'Add Role')
@section('content')
<?php use App\Http\Controllers\ConfigController; ?>
<div class="offset-2 col-8">
	<div class="card" id="form_style">
	<div class="card-header">
		Add Role 
			<div class="float-right" style="padding-right: 10px;">
				<a href="{{url('/role.list')}}" class="btn btn-sm btn-primary"><span class="fa fa-arrow-circle-o-left"></span> Go Back to Roles</a>
			</div>
		
		
	</div>
		<div class="card card-body">
		
        <div class="alert" style="display: none;" id="alert">
            <span><strong id="alert_message"></strong></span>
        </div>

		<form class="form-horizontal" method="POST" id="add_role" action="{{url('/role.add.save')}}" novalidate>
			<!--ROle Name DIV-->
			{{ csrf_field() }}
            <div class="form-group row" id="div-name">
                <label for="name" class="col-4 control-label control-label-sm">Role Name</label>

                <div class="col-6">
                    <input id="name" type="text" class="form-control form-control-sm" name="name"/>
                    <strong id="error_name"></strong>
                    
                </div>
            </div>
            <!--Role Desc DIV-->
            <div class="form-group row" id="div-desc">
                <label for="desc" class="col-4 control-label control-label-sm">Description</label>

                <div class="col-6">
                    <textarea class="form-control form-control-sm" name="description" rows="4" id="desc"></textarea>
                            <strong id="error_desc"></strong>
                    
                </div>
            </div>

            <div class="form-group col-12">
                <div class="col-md-3 offset-7  col-sm-12">
                    <button type="submit" class="btn btn-primary btn-sm col-12" id="submit">
                        Add
                    </button>

                </div>
            </div>
		</form>



		</div>
	</div>

</div>

<script type="text/javascript">
	$(document).ready(function(){
		$('#add_role').submit(function(e){

			e.preventDefault();

			var url, formData;

			url = $(this).attr('action');
			formData = $('#add_role').serialize();

			$.ajax({
				type:'post',
				data:formData,
				url:url,
				beforeSend:function(){
					$('#submit').addClass('loading');
					$('#name').removeClass('is-invalid');
					$('#error_name').html('');
					$('#desc').removeClass('is-invalid');
					$('#error_desc').html('');

					$('#alert').fadeOut('slow');
					$('#alert').removeClass('alert-success');
					$('#alert').removeClass('alert-danger');


				},
				success:function(data){

					@if(ConfigController::check_privilege('ACCESS_JAVASCRIPT_LOGS'))
	                	console.log(data);
	                @endif

					$('#submit').removeClass('loading');

					if(data.message){
						$('#alert').addClass('alert-success');
						$('#alert_message').html(data.message);
						$('#alert').fadeIn('slow');

						$('#submit').attr('disabled',true);

						setTimeout(function(){
							$('#submit').attr('disabled',false);
						},10000);
					}

				},
				error:function(data){
					
            	@if(ConfigController::check_privilege('ACCESS_JAVASCRIPT_LOGS'))
                	console.log(data.responseText);
                @endif      

					$('#submit').removeClass('loading');	

					var obj = jQuery.parseJSON(data.responseText);

					var errors = obj.errors;

					if(obj.message){
						$('#alert').fadeIn('slow');
						$('#alert').addClass('alert-danger');
						$('#alert_message').html(obj.message);

					}

					if(errors.name){
						$('#name').addClass('is-invalid');
						$('#error_name').addClass('invalid-feedback');
						$('#error_name').html(errors.name);
					}	

					if(errors.description){
						$('#desc').addClass('is-invalid');
						$('#error_desc').addClass('invalid-feedback');
						$('#error_desc').html(errors.description);
					}			
				}
			});
		});
	});

</script>

@endsection