@extends('layouts.app')
@section('pageTitle', 'Privilege Mapping')
@section('content')
<?php use App\Http\Controllers\ConfigController; ?>

	<div class="container">
		<div class="card">
			<div class="card-header">Privilege Mapping <div class="float-right"><a href="{{url('/role.list')}}" class="btn btn-danger btn-sm btn-spacer">Back to Cofigs</a></div></div>
				<div class="card-body">
                    <form  method="POST" id="mapping" action="{{url('sync.privileges')}}" novalidate>
							<input type="hidden" name="role_id" value="{{$id}}">
							{{ csrf_field() }}
							<div class="offset-10 col-md-2">
								<button class="btn btn-danger" type="submit">Update</button>
							</div>
						<div class="col-md-12">
							<hr>
						</div>
						<div id="data-id">
							@include('configs.addPrivilegeToRole_data')
						</div>
					</form>
				</div>
					
		</div>
	</div>



<script type="text/javascript"> 
$(document).ready(function(){
     $('#mapping').submit(function(e){
        e.preventDefault();

        var url, formData;
        url = $(this).attr('action');
        formData = $('#mapping').serialize();

        $.ajax({
            type: 'POST',
            url: url,
            data: formData,
            success:function(data){
                console.log(data);
                if(data.success)
                {
                        swal({
                            title: 'Success',
                            text: data.success,
                            type: 'success',
                            animation:true
                        });
                        refresh();
                }

                if(data.error)
                {
                    swal({
                        title: 'Oops',
                        text: data.error,
                        type: 'error',
                        animation:true
                    });
                }
                refresh();
            },
            error:function(data){
                console.log(data);
            }
        });

        // refresh();
     });   

});


        function show(id)
        {
           if(document.getElementById('checkbox'+id).checked)
           {
                document.getElementById('productCheckbox'+id).value = 'yes';
                
                $('#div-percentage'+id).fadeIn('slow');
           }
           else
           {
                document.getElementById('productCheckbox'+id).value = 'no';
                $('#div-percentage'+id).fadeOut('slow');
           }
        }




     function refresh()
     {
        $.ajax({
            type:'get',
            url:"{{url('role.add.privileges')}}.{{$id}}",
            data: '',
            success:function(data){
                
                $('#data-id').html(data.html);
            },
            error:function(data){
                alert('error');
            }
        });
     }  
</script>
@endsection