@extends('layouts.app')
@section('pageTitle', 'Subscriptions')
@section('content')
<?php use App\Http\Controllers\ConfigController; ?>

<div class="col-12">
	<div class="card">
		<input type="hidden" name="toggle" value="y" id="toggle">
		<div class="card-header bg-secondary text-white"><a class="btn btn-sm btn-link btn-spacer" title="Back" href="{{url('client.list')}}"><i class="fa fa-chevron-left"></i></a>{{$client->business_name.' -> ID '.$client->id}} <div class="float-right"><i class="btn btn-sm btn-warning btn-spacer">Traning Bal: $ {{$client->training_balance}} FJD</i> <i class="btn btn-sm btn-danger btn-spacer">Balance: $ {{$client->balance}} FJD</i> <i class="btn btn-info btn-sm btn-spacer" id="showorhide" onclick="showorhide();"><i class="fas fa-window-minimize"></i></i> @if($client->deleted_at <> '')<i class="btn btn-danger btn-sm">Inactive</i> @else <i class="btn btn-success btn-sm">Active</i> @endif</div></div>
		<div class="card-body" >
			<div id="client-body">
				<div class="form-group row">
					
	                <label for="contact_name" class="col-md-1 col-form-label col-form-label-sm">Contact Name</label>
	                <div class="col-md-3">
	                    <input type="text" class="form-control form-control-sm" name="contact_name" id="contact_name" value="{{$client->contact_name}}" readonly="readonly">
	                </div>

	                <label for="phone_contact" class="col-md-1 col-form-label col-form-label-sm">Phone</label>
	                <div class="col-md-2" >
	                    <input type="text" class="form-control form-
	                    control-sm" name="phone_contact" id="phone_contact" value="{{$client->phone_contact}}" readonly="readonly">
	                </div>


	                <label for="email" class="col-md-1 col-form-label col-form-label-sm">Email</label>
	                <div class="col-md-3 ">
	                    <input type="text" class="form-control form-control-sm" name="email" id="email" value="{{$client->email}}" readonly="readonly">
	                </div>

	            </div>
            <!-- Row ends -->
            
	            <div class="form-group row">
	            	<label for="tin_number" class="col-md-1" >Tin #</label>
	            	<div class="col-md-3">
	            		<input type="text" name="tin_number" id="tin_number" class="form-control form-control-sm" readonly="readonly" value="{{$client->tin_number}}">
	            	</div>

	                <label for="created_by" class="col-md-1 col-form-label col-form-label-sm">Created By</label>
	                <div class="col-md-2 ">
	                    <input type="text" class="form-control form-control-sm" name="email" id="email" value="{{ConfigController::get_username($client->created_by)}}" readonly="readonly">
	                </div>

	                <label for="created_at" class="col-md-1 col-form-label col-form-label-sm">Created At</label>
	               	<div class="col-md-3 ">
	                    <input type="text" class="form-control form-control-sm" name="created_at" id="created_at" value="{{$client->created_at}}" readonly="readonly">
	                </div>
	            </div>

	            <div class="form-group row">

	            	<label for="address" class="col-md-1 col-form-label col-form-label-sm">Address</label>
	            	<div class="col-md-3">
	            		<textarea class="form-control form-control-sm" rows="4" name="address" id="address" readonly="readonly">{!! $client->address !!}</textarea>
	            	</div>

	                <label for="updated_by" class="col-md-1 col-form-label col-form-label-sm">Updated By</label>
	                <div class="col-md-2 ">
	                    <input type="text" class="form-control form-control-sm" name="email" id="email" value="{{ConfigController::get_username($client->updated_by)}}" readonly="readonly">
	                </div>

	                <label for="updated_at" class="col-md-1 col-form-label col-form-label-sm">Updated At</label>
	               	<div class="col-md-3 ">
	                    <input type="text" class="form-control form-control-sm" name="updated_at" id="updated_at" value="{{$client->updated_at}}" readonly="readonly">
	                </div>
	            </div>	            
	        

	            <br>
				<hr class="offset-4 col-4" style="background-color: #00ffc112;">
			</div>
		<!-- Nav tabs -->
		<ul class="nav nav-tabs justify-content-end" id="myTab" role="tablist">
		@if(ConfigController::check_privilege('ACCESS_SUBSCRIPTION_VIEW'))
		  <li class="nav-item">
		    <a class="nav-link" id="subscription-tab" data-toggle="tab" href="#subscription" role="tab" aria-controls="subscription" aria-selected="true">Subscriptions</a>
		  </li>
		@endif

		@if(ConfigController::check_privilege('ACCESS_VIEW_INVOICE'))
		  <li class="nav-item">
		    <a class="nav-link" id="invoices-tab" data-toggle="tab" href="#invoices" role="tab" aria-controls="invoices" aria-selected="false">Invoices</a>
		  </li>
		@endif

		  <li class="nav-item">
		    <a class="nav-link" id="support-tab" data-toggle="tab" href="#support" role="tab" aria-controls="support" aria-selected="false">Support Tickets</a>
		  </li>
		  <li class="nav-item">
		    <a class="nav-link" id="settings-tab" data-toggle="tab" href="#settings" role="tab" aria-controls="settings" aria-selected="false">Settings</a>
		  </li>
		</ul>

		<!-- Tab panes -->
		<div class="tab-content">
		@if(ConfigController::check_privilege('ACCESS_SUBSCRIPTION_VIEW'))
		  <div class="tab-pane active" id="subscription" role="tabpanel" aria-labelledby="subscription-tab"></div>
		@endif

		@if(ConfigController::check_privilege('ACCESS_VIEW_INVOICE'))
		  <div class="tab-pane" id="invoices" role="tabpanel" aria-labelledby="invoices-tab"></div>
		@endif

		  <div class="tab-pane" id="support" role="tabpanel" aria-labelledby="support-tab"></div>
		  <div class="tab-pane" id="settings" role="tabpanel" aria-labelledby="settings-tab"></div>
		</div>


		</div> 
		<!-- card body  ends-->
		
	</div>
</div>

<script type="text/javascript">
$(document).ready(function(){
@if(ConfigController::check_privilege('ACCESS_SUBSCRIPTION_VIEW'))

	$('#subscription-tab').on('click', function (e) {
	  e.preventDefault();
	  loader();
	  setTimeout(function()
	  {
		  //AJAX Call
		  $.ajax({
		  	type:'POST',
		  	url: "{{url('client.subscription')}}.{{$id}}",
		  	data:{'_token': $('input[name=_token]').val()},
		  	success:function(data){
		  		stop_loader();
		  		console.log(data);
		  		$('#subscription').fadeIn('slow');
		  		$('#subscription').html(data.html);
		  	},
		  	error:function(data){
		  		stop_loader();
		  		// var obj = jQuery.parseJSON(data.responseText) ;
      //     		var errors = obj.errors;
		  		if(data.message)
		  		{
		  			swal({
		  				type:'error',
		  				title: 'Error occured',
		  				text: 'Oops, Something went wrong. Please contact admin.',
		  				animation:true
		  			});
		  		}

		  	}
		  });

	  	},1000);

	});
@endif




@if(ConfigController::check_privilege('ACCESS_VIEW_INVOICE'))

	$('#invoices-tab').on('click', function (e) {
	  e.preventDefault();
	  loader();
	  setTimeout(function()
	  {
		  //AJAX Call
		  $.ajax({
		  	type:'POST',
		  	url: "{{url('client.invoice')}}.{{$id}}",
		  	data:{'_token': $('input[name=_token]').val()},
		  	success:function(data){
		  		stop_loader();
		  		console.log(data);
		  		$('#invoices').fadeIn('slow');
		  		$('#invoices').html(data.html);
		  	},
		  	error:function(data){
		  		stop_loader();
		  		// var obj = jQuery.parseJSON(data.responseText) ;
      //     		var errors = obj.errors;
		  		if(data.message)
		  		{
		  			swal({
		  				type:'error',
		  				title: 'Error occured',
		  				text: 'Oops, Something went wrong. Please contact admin.',
		  				animation:true
		  			});
		  		}

		  	}
		  });

	  	},1000);

	});//End Invoice 
@endif

});

function loader(){
	Swal({
		title: 'Loading',
		allowEscapeKey:false,
		allowOutsideClick: false,
	});
	Swal.showLoading()
}

function stop_loader(){
	Swal.close();
}



function showorhide(){
  if(document.getElementById("toggle").value=="y")
  {
  	$('#client-body').fadeOut('slow');
   	document.getElementById("toggle").value="n";
   	document.getElementById("showorhide").innerHTML='<i class="fas fa-window-maximize"></i>';
  }
  else
  {
  	$('#client-body').fadeIn('slow');
    document.getElementById("toggle").value="y";
    document.getElementById("showorhide").innerHTML='<i class="fas fa-window-minimize"></i>';
  }
}

</script>

@endsection