 <?php use App\Http\Controllers\ConfigController; ?>
  <!-- The Modal -->
  <div class="modal fade" id="modal-subEdit">
    <div class="modal-dialog">
      <div class="modal-content">
      
        <!-- Modal Header -->
        <div class="modal-header">
          <h4 class="modal-title">Edit Subscription</h4>
          <button type="button" class="close" data-dismiss="modal">&times;</button>
        </div>

        <!-- Modal body -->
        <div class="modal-body">
          <div id="edit_alert" class="alert" style="display: none;"></div>
                <form id="editClientSubscription" method="POST" action="{{url('subscription.edit')}}">
                    @csrf
                    <div class="form-group">
                        <div>
                            <input type="hidden" name="client_id" id="edit_client_id">
                            <input type="hidden" name="id" id="edit_id">
                            <select class="form-control" name="product_id" id="edit_product_id">
                              <option value=""><---Select Product ---></option>
                              @foreach($products as $product)
                                @if($product->type == 'f')
                                  <option value="{{$product->id}}" data-amount="{{$product->amount}}" data-type="{{$product->type}}">{{$product->name .' - FJD $ '.$product->amount}}</option>
                                @endif

                                @if($product->type == 'x')
                                  <option value="{{$product->id}}" data-amount="{{$product->amount}}" data-type="{{$product->type}}">{{$product->name}}</option>
                                @endif
                              @endforeach
                            </select>
                        </div>
                    </div>


                    <div class="form-group">
                        <div>
                            <select class="form-control" name="type" id="edit_type">
                              <option value="one">One Time Payment</option>
                              <option value="monthly">Monthly Payment</option>
                              <option value="quarterly">Quarterly Payment</option>
                              <option value="bi">Bi Annually Payment</option>
                              <option value="annually">Annually Payment</option>
                            </select>
                        </div>
                    </div>

                    <div class="form-group" id="div-edit_amount">
                        <div>
                          <input type="number" name="amount" id="edit_amount" class="form-control">
                        </div>
                    </div>
                    
                </form>
        </div>
        
        <!-- Modal footer -->
        <div class="modal-footer">
          <button type="submit" class="btn btn-primary" id="submit-edit">Edit</button>
          <button type="button" class="btn btn-danger" data-dismiss="modal">Close</button>
        </div>
        
      </div>
    </div>
  </div>
  
</div>

<script type="text/javascript">
  $(document).ready(function(){
    $('#submit-edit').on('click',function(){
      var dataForm = $('#editClientSubscription').serialize();
      
      $.ajax({
        type:"post",
        url:"{{url('subscription.edit')}}",
        data: dataForm,
        beforeSend:function(data){
            $('#edit_alert').removeClass('alert-success');
            $('#edit_alert').removeClass('alert-danger');
            $('#edit_alert').fadeOut('slow');

            //Error remove classes
            $('#edit_product_id').removeClass('is-invalid');
            $('#edit_type').removeClass('is-invalid');
            $('#edit_amount').removeClass('is-invalid');

        },
        success:function(data){
          if(data.success)
          {
            $('#edit_alert').addClass('alert-success');
            $('#edit_alert').fadeIn('slow');
            $('#edit_alert').html(data.success);
            setTimeout(function() {

              $('#modal-subEdit').modal('hide');
              load_subscription();
            }, 2000);

          }

          if(data.error)
          {
            $('#edit_alert').addClass('alert-danger');
            $('#edit_alert').fadeIn('slow');
            $('#edit_alert').html(data.error);
          }
        },
        error:function(data){

          var obj = jQuery.parseJSON(data.responseText) ;
          var errors = obj.errors;

          if(obj.message)
          {
            $('#alert').addClass('alert-danger');
            $('#alert').fadeIn('slow');
            $('#alert').html(obj.message);
          }

          if(errors.edit_product_id)
          {
            $('#edit_product_id').addClass('is-invalid');
          }

          if(errors.edit_type)
          {
            $('#edit_type').addClass('is-invalid');
          }

          if(errors.edit_amount)
          {
            $('#edit_amount').addClass('is-invalid');
          }
        }
      });
    });



    $('#edit_product_id').on('change',function(){
      var edit_type = $(this).find(':selected').data('edit_type');

      if(edit_type === 'f')
      {
        var edit_amount = $(this).find(':selected').data('amount');
        $('#edit_amount').attr('readonly','readonly');
        $('#edit_amount').attr('value',edit_amount);
        $('#div-edit_amount').fadeIn('slow');
      }

      if(edit_type === 'x')
      {
        $('#div-edit_amount').fadeIn('slow');
        $('#edit_amount').removeAttr('readonly');
        $('#edit_amount').removeAttr('value');
        $('#edit_amount').attr('placeholder','Please enter amount');
      }

    });

  });

  $('.editSubs').on('click',function(){
    $('#edit_id').val($(this).data('id'));
    $('#edit_client_id').val($(this).data('client_id'));
    $('#edit_type').val($(this).data('type'));
    $('#edit_days').val($(this).data('days'));
    $('#edit_product_id').val($(this).data('product_id'));
    $('#edit_amount').val($(this).data('amount'));
    $('#modal-subEdit').modal('show');
  });

</script>