  <!-- The Modal -->
  <div class="modal fade" id="modal-subDelete">
    <div class="modal-dialog">
      <div class="modal-content">
      
        <!-- Modal Header -->
        <div class="modal-header">
          <h4 class="modal-title">Delete Subscription</h4>
          <button type="button" class="close" data-dismiss="modal">&times;</button>
        </div>
        <input type="hidden" id="delete_id">
        <!-- Modal body -->
        <div class="modal-body">
            <div id="delete_alert"></div>
            <div>Do you wish to remove Subscription id <span id='param'></span>?</div>
        </div>
        
        <!-- Modal footer -->
        <div class="modal-footer">
          <button type="submit" class="btn btn-danger" id="submit-delete">Remove</button>
          <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
        </div>
        
      </div>
    </div>
  </div>
  

<script type="text/javascript">
  $(document).ready(function(){
    $('#submit-delete').on('click',function(){
      loader();
      $.ajax({
        type:"post",
        url:"{{url('subscription.delete')}}",
        data:{
            '_token': $('input[name=_token]').val(),
            'id': $('#delete_id').val() 
        },
        beforeSend:function(data){
            $('#delete_alert').removeClass('alert-success');
            $('#delete_alert').removeClass('alert-danger');
            $('#delete_alert').fadeOut('slow');

        },
        success:function(data){
          if(data.success)
          {
            $('#delete_alert').addClass('alert-success');
            $('#delete_alert').fadeIn('slow');
            $('#delete_alert').html(data.success);
            
            swal({
              type:'success',
              title: 'Done',
              text: 'Removed successfully'
            });
            load_subscription();

            setTimeout(function() {

              $('#modal-subDelete').modal('hide');
            }, 4000);
          }

          if(data.error)
          {
            $('#delete_alert').addClass('alert-danger');
            $('#delete_alert').fadeIn('slow');
            $('#delete_alert').html(data.error);
          }
        },
        error:function(data){

          var obj = jQuery.parseJSON(data.responseText) ;
          var errors = obj.errors;

          if(obj.message)
          {
            $('#delete_alert').addClass('alert-danger');
            $('#delete_alert').fadeIn('slow');
            $('#delete_alert').html(obj.message);
          }

        }
      });
    });//end AJAX edit 

  });//end ready doc


  $('.deleteSubs').on('click',function(){
      $('#delete_id').val($(this).data('id'));
      $('#param').text($(this).data('id'));

      $('#modal-subDelete').modal('show');
  });
</script>