<?php use App\Http\Controllers\ConfigController; ?>
@if(count($subscriptions) > 0)
<table class="table table-hover table-striped table-bordered table-sm table-responsive-sm" style="font-size: 12px;>

	<thead>
		<th>Subscription ID</th>
		<th>Product</th>
		<th>Next Payment</th>
		<th>Type</th>
		<th>Days</th>
		<th>Created by</th>
		<th>Updated by</th>
		<th>Created at</th>
		<th>Updated at</th>
		<th></th>
		<th></th>
	</thead>
	<tbody>
		@foreach($subscriptions as $subscription)
		<tr>
			<td>{{$subscription->id}}</td>
			<td>{{ConfigController::get_productName($subscription->product_id)}} - {{$subscription->amount}} FJD</td>
			<td>{{$subscription->next_payment}}</td>
			<td>{{$subscription->type}}</td>
			<td>{{$subscription->days}}</td>
			<td>{{ConfigController::get_username($subscription->created_by)}}</td>
			<td>{{ConfigController::get_username($subscription->updated_by)}}</td>
			<td>{{$subscription->created_at}}</td>
			<td>{{$subscription->updated_at}}</td>
			@if($subscription->deleted_at == '')
			<td><a class="btn btn-info btn-sm editSubs"
						data-client_id="{{$subscription->client_id}}" 
						data-id="{{$subscription->id}}"
						data-type="{{$subscription->type}}"
						data-days="{{$subscription->days}}"
						data-amount="{{$subscription->amount}}"
						data-product_id="{{$subscription->product_id}}"
				><i class="fa fa-pencil-square-o"></i></a></td>
			<td><a class="btn btn-danger btn-sm deleteSubs" data-id="{{$subscription->id}}"><i class="fas fa-trash"></i></a></td>
			@else
				<td colspan="2" style="text-align: center;"><a class="btn btn-warning btn-sm restoreSubs" data-id="{{$subscription->id}}"><i class="fab fa-creative-commons-sa"></i></a></td>
			@endif
		</tr>
		@endforeach
	</tbody>
</table>
@else
	<div class="alert alert-info text-center">No data found.</div>
@endif

