<br>
<?php use App\Http\Controllers\ConfigController; ?>
@if(ConfigController::check_privilege('ACCESS_ADD_SUBSCRIPTION'))
	@include('clients.sub_add')
@endif

@if(ConfigController::check_privilege('ACCESS_EDIT_SUBSCRIPTION'))
	@include('clients.sub_edit')
@endif

@if(ConfigController::check_privilege('ACCESS_DELETE_SUBSCRIPTION'))
	@include('clients.sub_delete')
@endif

@if(ConfigController::check_privilege('ACCESS_RESTORE_SUBSCRIPTION'))
	@include('clients.sub_restore')
@endif

<div class="col-md-12">
	<div class="card">
		<div class="card-header"><span class="float-right">@if(ConfigController::check_privilege('ACCESS_ADD_SUBSCRIPTION'))<i class="btn btn-sm btn-primary"  data-toggle="modal" data-target="#modal-add"><span class="fa fa-plus"></span></i>@endif</span></div>
		<div class="card-body" id="subs-data">
			@if(count($subscriptions) > 0)
			<table class="table table-hover table-striped table-bordered table-sm table-responsive-sm" style="font-size: 12px;">
			
				<thead class="thead-dark">
					<th>Subscription ID</th>
					<th>Product</th>
					<th>Next Payment</th>
					<th>Type</th>
					<th>Days</th>
					<th>Created by</th>
					<th>Updated by</th>
					<th>Created at</th>
					<th>Updated at</th>
					<th></th>
					@if(ConfigController::check_privilege('ACCESS_DELETE_SUBSCRIPTION'))
						<th></th>
					@endif
				</thead>
				<tbody>
					@foreach($subscriptions as $subscription)
					<tr>
						<td>{{$subscription->id}}</td>
						<td>{{ConfigController::get_productName($subscription->product_id)}} - {{$subscription->amount}} FJD</td>
						<td>{{$subscription->next_payment}}</td>
						<td>{{$subscription->type}}</td>
						<td>{{$subscription->days}}</td>
						<td>{{ConfigController::get_username($subscription->created_by)}}</td>
						<td>{{ConfigController::get_username($subscription->updated_by)}}</td>
						<td>{{$subscription->created_at}}</td>
						<td>{{$subscription->updated_at}}</td>
						@if($subscription->deleted_at == '')
						<td><a class="btn btn-info btn-sm editSubs"
									data-client_id="{{$subscription->client_id}}" 
									data-id="{{$subscription->id}}"
									data-type="{{$subscription->type}}"
									data-days="{{$subscription->days}}"
									data-amount="{{$subscription->amount}}"
									data-product_id="{{$subscription->product_id}}"
							><span class="fa fa-edit"></span></a></td>
						<td><a class="btn btn-danger btn-sm deleteSubs" data-id="{{$subscription->id}}"><i class="fas fa-trash"></i></a></td>
						@else
							<td colspan="2" style="text-align: center;"><a class="btn btn-warning btn-sm restoreSubs" data-id="{{$subscription->id}}"><i class="fab fa-creative-commons-sa"></i></a></td>
						@endif
					</tr>
					@endforeach
				</tbody>
			</table>
			@else
				<div class="alert alert-info text-center">No data found.</div>
			@endif
		</div>
	</div>
</div>


<script type="text/javascript">
	function load_subscription(){
		$.ajax({
			type:'post',
			url: "{{url('subscription.client.load')}}",
			data:{'_token': $('input[name=_token]').val(), 'client_id':'{{$id}}'},
			beforeSend:function(){
				loader();
			},
			success:function(data){
				stop_loader();
				if(data.html)
				{
					$('#subs-data').html(data.html);
				}		
			},
			error:function(data){
				stop_loader();	

				swal({
	  				type:'error',
	  				title: 'Error occured',
	  				text: 'Oops, Something went wrong. Please contact admin.',
	  				animation:true
	  			});
			}
		});	
	}
</script>

